/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mailmanager.model.ActionFailurePolicy;
import software.amazon.awssdk.services.mailmanager.model.SnsNotificationEncoding;
import software.amazon.awssdk.services.mailmanager.model.SnsNotificationPayloadType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SnsAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SnsAction> {
    private static final SdkField<String> ACTION_FAILURE_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActionFailurePolicy").getter(SnsAction.getter(SnsAction::actionFailurePolicyAsString)).setter(SnsAction.setter(Builder::actionFailurePolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionFailurePolicy").build()}).build();
    private static final SdkField<String> ENCODING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Encoding").getter(SnsAction.getter(SnsAction::encodingAsString)).setter(SnsAction.setter(Builder::encoding)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encoding").build()}).build();
    private static final SdkField<String> PAYLOAD_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PayloadType").getter(SnsAction.getter(SnsAction::payloadTypeAsString)).setter(SnsAction.setter(Builder::payloadType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PayloadType").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(SnsAction.getter(SnsAction::roleArn)).setter(SnsAction.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<String> TOPIC_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TopicArn").getter(SnsAction.getter(SnsAction::topicArn)).setter(SnsAction.setter(Builder::topicArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FAILURE_POLICY_FIELD, ENCODING_FIELD, PAYLOAD_TYPE_FIELD, ROLE_ARN_FIELD, TOPIC_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SnsAction.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String actionFailurePolicy;
    private final String encoding;
    private final String payloadType;
    private final String roleArn;
    private final String topicArn;

    private SnsAction(BuilderImpl builder) {
        this.actionFailurePolicy = builder.actionFailurePolicy;
        this.encoding = builder.encoding;
        this.payloadType = builder.payloadType;
        this.roleArn = builder.roleArn;
        this.topicArn = builder.topicArn;
    }

    public final ActionFailurePolicy actionFailurePolicy() {
        return ActionFailurePolicy.fromValue(this.actionFailurePolicy);
    }

    public final String actionFailurePolicyAsString() {
        return this.actionFailurePolicy;
    }

    public final SnsNotificationEncoding encoding() {
        return SnsNotificationEncoding.fromValue(this.encoding);
    }

    public final String encodingAsString() {
        return this.encoding;
    }

    public final SnsNotificationPayloadType payloadType() {
        return SnsNotificationPayloadType.fromValue(this.payloadType);
    }

    public final String payloadTypeAsString() {
        return this.payloadType;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String topicArn() {
        return this.topicArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionFailurePolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.encodingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.payloadTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.topicArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnsAction)) {
            return false;
        }
        SnsAction other = (SnsAction)obj;
        return Objects.equals(this.actionFailurePolicyAsString(), other.actionFailurePolicyAsString()) && Objects.equals(this.encodingAsString(), other.encodingAsString()) && Objects.equals(this.payloadTypeAsString(), other.payloadTypeAsString()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.topicArn(), other.topicArn());
    }

    public final String toString() {
        return ToString.builder((String)"SnsAction").add("ActionFailurePolicy", (Object)this.actionFailurePolicyAsString()).add("Encoding", (Object)this.encodingAsString()).add("PayloadType", (Object)this.payloadTypeAsString()).add("RoleArn", (Object)this.roleArn()).add("TopicArn", (Object)this.topicArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActionFailurePolicy": {
                return Optional.ofNullable(clazz.cast(this.actionFailurePolicyAsString()));
            }
            case "Encoding": {
                return Optional.ofNullable(clazz.cast(this.encodingAsString()));
            }
            case "PayloadType": {
                return Optional.ofNullable(clazz.cast(this.payloadTypeAsString()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "TopicArn": {
                return Optional.ofNullable(clazz.cast(this.topicArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ActionFailurePolicy", ACTION_FAILURE_POLICY_FIELD);
        map.put("Encoding", ENCODING_FIELD);
        map.put("PayloadType", PAYLOAD_TYPE_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("TopicArn", TOPIC_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SnsAction, T> g) {
        return obj -> g.apply((SnsAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String actionFailurePolicy;
        private String encoding;
        private String payloadType;
        private String roleArn;
        private String topicArn;

        private BuilderImpl() {
        }

        private BuilderImpl(SnsAction model) {
            this.actionFailurePolicy(model.actionFailurePolicy);
            this.encoding(model.encoding);
            this.payloadType(model.payloadType);
            this.roleArn(model.roleArn);
            this.topicArn(model.topicArn);
        }

        public final String getActionFailurePolicy() {
            return this.actionFailurePolicy;
        }

        public final void setActionFailurePolicy(String actionFailurePolicy) {
            this.actionFailurePolicy = actionFailurePolicy;
        }

        @Override
        public final Builder actionFailurePolicy(String actionFailurePolicy) {
            this.actionFailurePolicy = actionFailurePolicy;
            return this;
        }

        @Override
        public final Builder actionFailurePolicy(ActionFailurePolicy actionFailurePolicy) {
            this.actionFailurePolicy(actionFailurePolicy == null ? null : actionFailurePolicy.toString());
            return this;
        }

        public final String getEncoding() {
            return this.encoding;
        }

        public final void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        @Override
        public final Builder encoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        @Override
        public final Builder encoding(SnsNotificationEncoding encoding) {
            this.encoding(encoding == null ? null : encoding.toString());
            return this;
        }

        public final String getPayloadType() {
            return this.payloadType;
        }

        public final void setPayloadType(String payloadType) {
            this.payloadType = payloadType;
        }

        @Override
        public final Builder payloadType(String payloadType) {
            this.payloadType = payloadType;
            return this;
        }

        @Override
        public final Builder payloadType(SnsNotificationPayloadType payloadType) {
            this.payloadType(payloadType == null ? null : payloadType.toString());
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getTopicArn() {
            return this.topicArn;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public SnsAction build() {
            return new SnsAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SnsAction> {
        public Builder actionFailurePolicy(String var1);

        public Builder actionFailurePolicy(ActionFailurePolicy var1);

        public Builder encoding(String var1);

        public Builder encoding(SnsNotificationEncoding var1);

        public Builder payloadType(String var1);

        public Builder payloadType(SnsNotificationPayloadType var1);

        public Builder roleArn(String var1);

        public Builder topicArn(String var1);
    }
}

