/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mailmanager.MailManagerAsyncClient;
import software.amazon.awssdk.services.mailmanager.internal.UserAgentUtils;
import software.amazon.awssdk.services.mailmanager.model.ListTrafficPoliciesRequest;
import software.amazon.awssdk.services.mailmanager.model.ListTrafficPoliciesResponse;
import software.amazon.awssdk.services.mailmanager.model.TrafficPolicy;

public class ListTrafficPoliciesPublisher
implements SdkPublisher<ListTrafficPoliciesResponse> {
    private final MailManagerAsyncClient client;
    private final ListTrafficPoliciesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTrafficPoliciesPublisher(MailManagerAsyncClient client, ListTrafficPoliciesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTrafficPoliciesPublisher(MailManagerAsyncClient client, ListTrafficPoliciesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTrafficPoliciesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTrafficPoliciesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TrafficPolicy> trafficPolicies() {
        Function<ListTrafficPoliciesResponse, Iterator> getIterator = response -> {
            if (response != null && response.trafficPolicies() != null) {
                return response.trafficPolicies().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListTrafficPoliciesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListTrafficPoliciesResponseFetcher
    implements AsyncPageFetcher<ListTrafficPoliciesResponse> {
        private ListTrafficPoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListTrafficPoliciesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTrafficPoliciesResponse> nextPage(ListTrafficPoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListTrafficPoliciesPublisher.this.client.listTrafficPolicies(ListTrafficPoliciesPublisher.this.firstRequest);
            }
            return ListTrafficPoliciesPublisher.this.client.listTrafficPolicies((ListTrafficPoliciesRequest)((Object)ListTrafficPoliciesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

