/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mailmanager.MailManagerClient;
import software.amazon.awssdk.services.mailmanager.internal.UserAgentUtils;
import software.amazon.awssdk.services.mailmanager.model.AddonSubscription;
import software.amazon.awssdk.services.mailmanager.model.ListAddonSubscriptionsRequest;
import software.amazon.awssdk.services.mailmanager.model.ListAddonSubscriptionsResponse;

public class ListAddonSubscriptionsIterable
implements SdkIterable<ListAddonSubscriptionsResponse> {
    private final MailManagerClient client;
    private final ListAddonSubscriptionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAddonSubscriptionsIterable(MailManagerClient client, ListAddonSubscriptionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAddonSubscriptionsResponseFetcher();
    }

    public Iterator<ListAddonSubscriptionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AddonSubscription> addonSubscriptions() {
        Function<ListAddonSubscriptionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.addonSubscriptions() != null) {
                return response.addonSubscriptions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAddonSubscriptionsResponseFetcher
    implements SyncPageFetcher<ListAddonSubscriptionsResponse> {
        private ListAddonSubscriptionsResponseFetcher() {
        }

        public boolean hasNextPage(ListAddonSubscriptionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAddonSubscriptionsResponse nextPage(ListAddonSubscriptionsResponse previousPage) {
            if (previousPage == null) {
                return ListAddonSubscriptionsIterable.this.client.listAddonSubscriptions(ListAddonSubscriptionsIterable.this.firstRequest);
            }
            return ListAddonSubscriptionsIterable.this.client.listAddonSubscriptions((ListAddonSubscriptionsRequest)((Object)ListAddonSubscriptionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

