/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RuleVerdict {
    PASS("PASS"),
    FAIL("FAIL"),
    GRAY("GRAY"),
    PROCESSING_FAILED("PROCESSING_FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RuleVerdict> VALUE_MAP;
    private final String value;

    private RuleVerdict(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RuleVerdict fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RuleVerdict> knownValues() {
        EnumSet<RuleVerdict> knownValues = EnumSet.allOf(RuleVerdict.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RuleVerdict.class, RuleVerdict::toString);
    }
}

