/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mailmanager.MailManagerClient;
import software.amazon.awssdk.services.mailmanager.internal.UserAgentUtils;
import software.amazon.awssdk.services.mailmanager.model.IngressPoint;
import software.amazon.awssdk.services.mailmanager.model.ListIngressPointsRequest;
import software.amazon.awssdk.services.mailmanager.model.ListIngressPointsResponse;

public class ListIngressPointsIterable
implements SdkIterable<ListIngressPointsResponse> {
    private final MailManagerClient client;
    private final ListIngressPointsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListIngressPointsIterable(MailManagerClient client, ListIngressPointsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListIngressPointsResponseFetcher();
    }

    public Iterator<ListIngressPointsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<IngressPoint> ingressPoints() {
        Function<ListIngressPointsResponse, Iterator> getIterator = response -> {
            if (response != null && response.ingressPoints() != null) {
                return response.ingressPoints().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListIngressPointsResponseFetcher
    implements SyncPageFetcher<ListIngressPointsResponse> {
        private ListIngressPointsResponseFetcher() {
        }

        public boolean hasNextPage(ListIngressPointsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListIngressPointsResponse nextPage(ListIngressPointsResponse previousPage) {
            if (previousPage == null) {
                return ListIngressPointsIterable.this.client.listIngressPoints(ListIngressPointsIterable.this.firstRequest);
            }
            return ListIngressPointsIterable.this.client.listIngressPoints((ListIngressPointsRequest)((Object)ListIngressPointsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

