/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mailmanager.model.RuleAddressListArnListCopier;
import software.amazon.awssdk.services.mailmanager.model.RuleAddressListEmailAttribute;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RuleIsInAddressList
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RuleIsInAddressList> {
    private static final SdkField<List<String>> ADDRESS_LISTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AddressLists").getter(RuleIsInAddressList.getter(RuleIsInAddressList::addressLists)).setter(RuleIsInAddressList.setter(Builder::addressLists)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressLists").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ATTRIBUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Attribute").getter(RuleIsInAddressList.getter(RuleIsInAddressList::attributeAsString)).setter(RuleIsInAddressList.setter(Builder::attribute)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attribute").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDRESS_LISTS_FIELD, ATTRIBUTE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RuleIsInAddressList.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> addressLists;
    private final String attribute;

    private RuleIsInAddressList(BuilderImpl builder) {
        this.addressLists = builder.addressLists;
        this.attribute = builder.attribute;
    }

    public final boolean hasAddressLists() {
        return this.addressLists != null && !(this.addressLists instanceof SdkAutoConstructList);
    }

    public final List<String> addressLists() {
        return this.addressLists;
    }

    public final RuleAddressListEmailAttribute attribute() {
        return RuleAddressListEmailAttribute.fromValue(this.attribute);
    }

    public final String attributeAsString() {
        return this.attribute;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAddressLists() ? this.addressLists() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleIsInAddressList)) {
            return false;
        }
        RuleIsInAddressList other = (RuleIsInAddressList)obj;
        return this.hasAddressLists() == other.hasAddressLists() && Objects.equals(this.addressLists(), other.addressLists()) && Objects.equals(this.attributeAsString(), other.attributeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RuleIsInAddressList").add("AddressLists", this.hasAddressLists() ? this.addressLists() : null).add("Attribute", (Object)this.attributeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AddressLists": {
                return Optional.ofNullable(clazz.cast(this.addressLists()));
            }
            case "Attribute": {
                return Optional.ofNullable(clazz.cast(this.attributeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AddressLists", ADDRESS_LISTS_FIELD);
        map.put("Attribute", ATTRIBUTE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RuleIsInAddressList, T> g) {
        return obj -> g.apply((RuleIsInAddressList)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> addressLists = DefaultSdkAutoConstructList.getInstance();
        private String attribute;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleIsInAddressList model) {
            this.addressLists(model.addressLists);
            this.attribute(model.attribute);
        }

        public final Collection<String> getAddressLists() {
            if (this.addressLists instanceof SdkAutoConstructList) {
                return null;
            }
            return this.addressLists;
        }

        public final void setAddressLists(Collection<String> addressLists) {
            this.addressLists = RuleAddressListArnListCopier.copy(addressLists);
        }

        @Override
        public final Builder addressLists(Collection<String> addressLists) {
            this.addressLists = RuleAddressListArnListCopier.copy(addressLists);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addressLists(String ... addressLists) {
            this.addressLists(Arrays.asList(addressLists));
            return this;
        }

        public final String getAttribute() {
            return this.attribute;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        @Override
        public final Builder attribute(RuleAddressListEmailAttribute attribute) {
            this.attribute(attribute == null ? null : attribute.toString());
            return this;
        }

        public RuleIsInAddressList build() {
            return new RuleIsInAddressList(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RuleIsInAddressList> {
        public Builder addressLists(Collection<String> var1);

        public Builder addressLists(String ... var1);

        public Builder attribute(String var1);

        public Builder attribute(RuleAddressListEmailAttribute var1);
    }
}

