/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.macie2.Macie2AsyncClient;
import software.amazon.awssdk.services.macie2.internal.UserAgentUtils;
import software.amazon.awssdk.services.macie2.model.BucketMetadata;
import software.amazon.awssdk.services.macie2.model.DescribeBucketsRequest;
import software.amazon.awssdk.services.macie2.model.DescribeBucketsResponse;

public class DescribeBucketsPublisher
implements SdkPublisher<DescribeBucketsResponse> {
    private final Macie2AsyncClient client;
    private final DescribeBucketsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeBucketsPublisher(Macie2AsyncClient client, DescribeBucketsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeBucketsPublisher(Macie2AsyncClient client, DescribeBucketsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeBucketsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeBucketsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<BucketMetadata> buckets() {
        Function<DescribeBucketsResponse, Iterator> getIterator = response -> {
            if (response != null && response.buckets() != null) {
                return response.buckets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeBucketsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeBucketsResponseFetcher
    implements AsyncPageFetcher<DescribeBucketsResponse> {
        private DescribeBucketsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeBucketsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeBucketsResponse> nextPage(DescribeBucketsResponse previousPage) {
            if (previousPage == null) {
                return DescribeBucketsPublisher.this.client.describeBuckets(DescribeBucketsPublisher.this.firstRequest);
            }
            return DescribeBucketsPublisher.this.client.describeBuckets((DescribeBucketsRequest)((Object)DescribeBucketsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

