/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.macie2.model.Macie2Response;
import software.amazon.awssdk.services.macie2.model.SensitivityInspectionTemplateExcludes;
import software.amazon.awssdk.services.macie2.model.SensitivityInspectionTemplateIncludes;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSensitivityInspectionTemplateResponse
extends Macie2Response
implements ToCopyableBuilder<Builder, GetSensitivityInspectionTemplateResponse> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetSensitivityInspectionTemplateResponse.getter(GetSensitivityInspectionTemplateResponse::description)).setter(GetSensitivityInspectionTemplateResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<SensitivityInspectionTemplateExcludes> EXCLUDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("excludes").getter(GetSensitivityInspectionTemplateResponse.getter(GetSensitivityInspectionTemplateResponse::excludes)).setter(GetSensitivityInspectionTemplateResponse.setter(Builder::excludes)).constructor(SensitivityInspectionTemplateExcludes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("excludes").build()}).build();
    private static final SdkField<SensitivityInspectionTemplateIncludes> INCLUDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("includes").getter(GetSensitivityInspectionTemplateResponse.getter(GetSensitivityInspectionTemplateResponse::includes)).setter(GetSensitivityInspectionTemplateResponse.setter(Builder::includes)).constructor(SensitivityInspectionTemplateIncludes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includes").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetSensitivityInspectionTemplateResponse.getter(GetSensitivityInspectionTemplateResponse::name)).setter(GetSensitivityInspectionTemplateResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> SENSITIVITY_INSPECTION_TEMPLATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sensitivityInspectionTemplateId").getter(GetSensitivityInspectionTemplateResponse.getter(GetSensitivityInspectionTemplateResponse::sensitivityInspectionTemplateId)).setter(GetSensitivityInspectionTemplateResponse.setter(Builder::sensitivityInspectionTemplateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sensitivityInspectionTemplateId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, EXCLUDES_FIELD, INCLUDES_FIELD, NAME_FIELD, SENSITIVITY_INSPECTION_TEMPLATE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetSensitivityInspectionTemplateResponse.memberNameToFieldInitializer();
    private final String description;
    private final SensitivityInspectionTemplateExcludes excludes;
    private final SensitivityInspectionTemplateIncludes includes;
    private final String name;
    private final String sensitivityInspectionTemplateId;

    private GetSensitivityInspectionTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.excludes = builder.excludes;
        this.includes = builder.includes;
        this.name = builder.name;
        this.sensitivityInspectionTemplateId = builder.sensitivityInspectionTemplateId;
    }

    public final String description() {
        return this.description;
    }

    public final SensitivityInspectionTemplateExcludes excludes() {
        return this.excludes;
    }

    public final SensitivityInspectionTemplateIncludes includes() {
        return this.includes;
    }

    public final String name() {
        return this.name;
    }

    public final String sensitivityInspectionTemplateId() {
        return this.sensitivityInspectionTemplateId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.excludes());
        hashCode = 31 * hashCode + Objects.hashCode(this.includes());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.sensitivityInspectionTemplateId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSensitivityInspectionTemplateResponse)) {
            return false;
        }
        GetSensitivityInspectionTemplateResponse other = (GetSensitivityInspectionTemplateResponse)((Object)obj);
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.excludes(), other.excludes()) && Objects.equals(this.includes(), other.includes()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.sensitivityInspectionTemplateId(), other.sensitivityInspectionTemplateId());
    }

    public final String toString() {
        return ToString.builder((String)"GetSensitivityInspectionTemplateResponse").add("Description", (Object)this.description()).add("Excludes", (Object)this.excludes()).add("Includes", (Object)this.includes()).add("Name", (Object)this.name()).add("SensitivityInspectionTemplateId", (Object)this.sensitivityInspectionTemplateId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "excludes": {
                return Optional.ofNullable(clazz.cast(this.excludes()));
            }
            case "includes": {
                return Optional.ofNullable(clazz.cast(this.includes()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "sensitivityInspectionTemplateId": {
                return Optional.ofNullable(clazz.cast(this.sensitivityInspectionTemplateId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("description", DESCRIPTION_FIELD);
        map.put("excludes", EXCLUDES_FIELD);
        map.put("includes", INCLUDES_FIELD);
        map.put("name", NAME_FIELD);
        map.put("sensitivityInspectionTemplateId", SENSITIVITY_INSPECTION_TEMPLATE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSensitivityInspectionTemplateResponse, T> g) {
        return obj -> g.apply((GetSensitivityInspectionTemplateResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Macie2Response.BuilderImpl
    implements Builder {
        private String description;
        private SensitivityInspectionTemplateExcludes excludes;
        private SensitivityInspectionTemplateIncludes includes;
        private String name;
        private String sensitivityInspectionTemplateId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSensitivityInspectionTemplateResponse model) {
            super(model);
            this.description(model.description);
            this.excludes(model.excludes);
            this.includes(model.includes);
            this.name(model.name);
            this.sensitivityInspectionTemplateId(model.sensitivityInspectionTemplateId);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final SensitivityInspectionTemplateExcludes.Builder getExcludes() {
            return this.excludes != null ? this.excludes.toBuilder() : null;
        }

        public final void setExcludes(SensitivityInspectionTemplateExcludes.BuilderImpl excludes) {
            this.excludes = excludes != null ? excludes.build() : null;
        }

        @Override
        public final Builder excludes(SensitivityInspectionTemplateExcludes excludes) {
            this.excludes = excludes;
            return this;
        }

        public final SensitivityInspectionTemplateIncludes.Builder getIncludes() {
            return this.includes != null ? this.includes.toBuilder() : null;
        }

        public final void setIncludes(SensitivityInspectionTemplateIncludes.BuilderImpl includes) {
            this.includes = includes != null ? includes.build() : null;
        }

        @Override
        public final Builder includes(SensitivityInspectionTemplateIncludes includes) {
            this.includes = includes;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSensitivityInspectionTemplateId() {
            return this.sensitivityInspectionTemplateId;
        }

        public final void setSensitivityInspectionTemplateId(String sensitivityInspectionTemplateId) {
            this.sensitivityInspectionTemplateId = sensitivityInspectionTemplateId;
        }

        @Override
        public final Builder sensitivityInspectionTemplateId(String sensitivityInspectionTemplateId) {
            this.sensitivityInspectionTemplateId = sensitivityInspectionTemplateId;
            return this;
        }

        @Override
        public GetSensitivityInspectionTemplateResponse build() {
            return new GetSensitivityInspectionTemplateResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Macie2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSensitivityInspectionTemplateResponse> {
        public Builder description(String var1);

        public Builder excludes(SensitivityInspectionTemplateExcludes var1);

        default public Builder excludes(Consumer<SensitivityInspectionTemplateExcludes.Builder> excludes) {
            return this.excludes((SensitivityInspectionTemplateExcludes)((SensitivityInspectionTemplateExcludes.Builder)SensitivityInspectionTemplateExcludes.builder().applyMutation(excludes)).build());
        }

        public Builder includes(SensitivityInspectionTemplateIncludes var1);

        default public Builder includes(Consumer<SensitivityInspectionTemplateIncludes.Builder> includes) {
            return this.includes((SensitivityInspectionTemplateIncludes)((SensitivityInspectionTemplateIncludes.Builder)SensitivityInspectionTemplateIncludes.builder().applyMutation(includes)).build());
        }

        public Builder name(String var1);

        public Builder sensitivityInspectionTemplateId(String var1);
    }
}

