/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.macie2.Macie2Client;
import software.amazon.awssdk.services.macie2.internal.UserAgentUtils;
import software.amazon.awssdk.services.macie2.model.Detection;
import software.amazon.awssdk.services.macie2.model.ListResourceProfileDetectionsRequest;
import software.amazon.awssdk.services.macie2.model.ListResourceProfileDetectionsResponse;

public class ListResourceProfileDetectionsIterable
implements SdkIterable<ListResourceProfileDetectionsResponse> {
    private final Macie2Client client;
    private final ListResourceProfileDetectionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListResourceProfileDetectionsIterable(Macie2Client client, ListResourceProfileDetectionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListResourceProfileDetectionsResponseFetcher();
    }

    public Iterator<ListResourceProfileDetectionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Detection> detections() {
        Function<ListResourceProfileDetectionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.detections() != null) {
                return response.detections().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListResourceProfileDetectionsResponseFetcher
    implements SyncPageFetcher<ListResourceProfileDetectionsResponse> {
        private ListResourceProfileDetectionsResponseFetcher() {
        }

        public boolean hasNextPage(ListResourceProfileDetectionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListResourceProfileDetectionsResponse nextPage(ListResourceProfileDetectionsResponse previousPage) {
            if (previousPage == null) {
                return ListResourceProfileDetectionsIterable.this.client.listResourceProfileDetections(ListResourceProfileDetectionsIterable.this.firstRequest);
            }
            return ListResourceProfileDetectionsIterable.this.client.listResourceProfileDetections((ListResourceProfileDetectionsRequest)((Object)ListResourceProfileDetectionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

