/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.macie2.model.Macie2Request;
import software.amazon.awssdk.services.macie2.model.SearchResourcesBucketCriteria;
import software.amazon.awssdk.services.macie2.model.SearchResourcesSortCriteria;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchResourcesRequest
extends Macie2Request
implements ToCopyableBuilder<Builder, SearchResourcesRequest> {
    private static final SdkField<SearchResourcesBucketCriteria> BUCKET_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("bucketCriteria").getter(SearchResourcesRequest.getter(SearchResourcesRequest::bucketCriteria)).setter(SearchResourcesRequest.setter(Builder::bucketCriteria)).constructor(SearchResourcesBucketCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketCriteria").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(SearchResourcesRequest.getter(SearchResourcesRequest::maxResults)).setter(SearchResourcesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(SearchResourcesRequest.getter(SearchResourcesRequest::nextToken)).setter(SearchResourcesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<SearchResourcesSortCriteria> SORT_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sortCriteria").getter(SearchResourcesRequest.getter(SearchResourcesRequest::sortCriteria)).setter(SearchResourcesRequest.setter(Builder::sortCriteria)).constructor(SearchResourcesSortCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortCriteria").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_CRITERIA_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SORT_CRITERIA_FIELD));
    private final SearchResourcesBucketCriteria bucketCriteria;
    private final Integer maxResults;
    private final String nextToken;
    private final SearchResourcesSortCriteria sortCriteria;

    private SearchResourcesRequest(BuilderImpl builder) {
        super(builder);
        this.bucketCriteria = builder.bucketCriteria;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.sortCriteria = builder.sortCriteria;
    }

    public final SearchResourcesBucketCriteria bucketCriteria() {
        return this.bucketCriteria;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final SearchResourcesSortCriteria sortCriteria() {
        return this.sortCriteria;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortCriteria());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchResourcesRequest)) {
            return false;
        }
        SearchResourcesRequest other = (SearchResourcesRequest)((Object)obj);
        return Objects.equals(this.bucketCriteria(), other.bucketCriteria()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.sortCriteria(), other.sortCriteria());
    }

    public final String toString() {
        return ToString.builder((String)"SearchResourcesRequest").add("BucketCriteria", (Object)this.bucketCriteria()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("SortCriteria", (Object)this.sortCriteria()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "bucketCriteria": {
                return Optional.ofNullable(clazz.cast(this.bucketCriteria()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "sortCriteria": {
                return Optional.ofNullable(clazz.cast(this.sortCriteria()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchResourcesRequest, T> g) {
        return obj -> g.apply((SearchResourcesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Macie2Request.BuilderImpl
    implements Builder {
        private SearchResourcesBucketCriteria bucketCriteria;
        private Integer maxResults;
        private String nextToken;
        private SearchResourcesSortCriteria sortCriteria;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchResourcesRequest model) {
            super(model);
            this.bucketCriteria(model.bucketCriteria);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.sortCriteria(model.sortCriteria);
        }

        public final SearchResourcesBucketCriteria.Builder getBucketCriteria() {
            return this.bucketCriteria != null ? this.bucketCriteria.toBuilder() : null;
        }

        public final void setBucketCriteria(SearchResourcesBucketCriteria.BuilderImpl bucketCriteria) {
            this.bucketCriteria = bucketCriteria != null ? bucketCriteria.build() : null;
        }

        @Override
        @Transient
        public final Builder bucketCriteria(SearchResourcesBucketCriteria bucketCriteria) {
            this.bucketCriteria = bucketCriteria;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final SearchResourcesSortCriteria.Builder getSortCriteria() {
            return this.sortCriteria != null ? this.sortCriteria.toBuilder() : null;
        }

        public final void setSortCriteria(SearchResourcesSortCriteria.BuilderImpl sortCriteria) {
            this.sortCriteria = sortCriteria != null ? sortCriteria.build() : null;
        }

        @Override
        @Transient
        public final Builder sortCriteria(SearchResourcesSortCriteria sortCriteria) {
            this.sortCriteria = sortCriteria;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchResourcesRequest build() {
            return new SearchResourcesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Macie2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchResourcesRequest> {
        public Builder bucketCriteria(SearchResourcesBucketCriteria var1);

        default public Builder bucketCriteria(Consumer<SearchResourcesBucketCriteria.Builder> bucketCriteria) {
            return this.bucketCriteria((SearchResourcesBucketCriteria)((SearchResourcesBucketCriteria.Builder)SearchResourcesBucketCriteria.builder().applyMutation(bucketCriteria)).build());
        }

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder sortCriteria(SearchResourcesSortCriteria var1);

        default public Builder sortCriteria(Consumer<SearchResourcesSortCriteria.Builder> sortCriteria) {
            return this.sortCriteria((SearchResourcesSortCriteria)((SearchResourcesSortCriteria.Builder)SearchResourcesSortCriteria.builder().applyMutation(sortCriteria)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

