/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class ___listOfFindingsFilterListItemCopier {
    static List<FindingsFilterListItem> copy(Collection<? extends FindingsFilterListItem> __listOfFindingsFilterListItemParam) {
        List<FindingsFilterListItem> list;
        if (__listOfFindingsFilterListItemParam == null || __listOfFindingsFilterListItemParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<FindingsFilterListItem> modifiableList = new ArrayList<>();
            __listOfFindingsFilterListItemParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<FindingsFilterListItem> copyFromBuilder(
            Collection<? extends FindingsFilterListItem.Builder> __listOfFindingsFilterListItemParam) {
        List<FindingsFilterListItem> list;
        if (__listOfFindingsFilterListItemParam == null || __listOfFindingsFilterListItemParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<FindingsFilterListItem> modifiableList = new ArrayList<>();
            __listOfFindingsFilterListItemParam.forEach(entry -> {
                FindingsFilterListItem member = entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<FindingsFilterListItem.Builder> copyToBuilder(
            Collection<? extends FindingsFilterListItem> __listOfFindingsFilterListItemParam) {
        List<FindingsFilterListItem.Builder> list;
        if (__listOfFindingsFilterListItemParam == null || __listOfFindingsFilterListItemParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<FindingsFilterListItem.Builder> modifiableList = new ArrayList<>();
            __listOfFindingsFilterListItemParam.forEach(entry -> {
                FindingsFilterListItem.Builder member = entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
