/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the resources that a finding applies to.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourcesAffected implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourcesAffected.Builder, ResourcesAffected> {
    private static final SdkField<S3Bucket> S3_BUCKET_FIELD = SdkField.<S3Bucket> builder(MarshallingType.SDK_POJO)
            .memberName("s3Bucket").getter(getter(ResourcesAffected::s3Bucket)).setter(setter(Builder::s3Bucket))
            .constructor(S3Bucket::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Bucket").build()).build();

    private static final SdkField<S3Object> S3_OBJECT_FIELD = SdkField.<S3Object> builder(MarshallingType.SDK_POJO)
            .memberName("s3Object").getter(getter(ResourcesAffected::s3Object)).setter(setter(Builder::s3Object))
            .constructor(S3Object::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Object").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_BUCKET_FIELD,
            S3_OBJECT_FIELD));

    private static final long serialVersionUID = 1L;

    private final S3Bucket s3Bucket;

    private final S3Object s3Object;

    private ResourcesAffected(BuilderImpl builder) {
        this.s3Bucket = builder.s3Bucket;
        this.s3Object = builder.s3Object;
    }

    /**
     * <p>
     * The details of the S3 bucket that the finding applies to.
     * </p>
     * 
     * @return The details of the S3 bucket that the finding applies to.
     */
    public final S3Bucket s3Bucket() {
        return s3Bucket;
    }

    /**
     * <p>
     * The details of the S3 object that the finding applies to.
     * </p>
     * 
     * @return The details of the S3 object that the finding applies to.
     */
    public final S3Object s3Object() {
        return s3Object;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(s3Object());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourcesAffected)) {
            return false;
        }
        ResourcesAffected other = (ResourcesAffected) obj;
        return Objects.equals(s3Bucket(), other.s3Bucket()) && Objects.equals(s3Object(), other.s3Object());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourcesAffected").add("S3Bucket", s3Bucket()).add("S3Object", s3Object()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "s3Bucket":
            return Optional.ofNullable(clazz.cast(s3Bucket()));
        case "s3Object":
            return Optional.ofNullable(clazz.cast(s3Object()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourcesAffected, T> g) {
        return obj -> g.apply((ResourcesAffected) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourcesAffected> {
        /**
         * <p>
         * The details of the S3 bucket that the finding applies to.
         * </p>
         * 
         * @param s3Bucket
         *        The details of the S3 bucket that the finding applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Bucket(S3Bucket s3Bucket);

        /**
         * <p>
         * The details of the S3 bucket that the finding applies to.
         * </p>
         * This is a convenience that creates an instance of the {@link S3Bucket.Builder} avoiding the need to create
         * one manually via {@link S3Bucket#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3Bucket.Builder#build()} is called immediately and its result is
         * passed to {@link #s3Bucket(S3Bucket)}.
         * 
         * @param s3Bucket
         *        a consumer that will call methods on {@link S3Bucket.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Bucket(S3Bucket)
         */
        default Builder s3Bucket(Consumer<S3Bucket.Builder> s3Bucket) {
            return s3Bucket(S3Bucket.builder().applyMutation(s3Bucket).build());
        }

        /**
         * <p>
         * The details of the S3 object that the finding applies to.
         * </p>
         * 
         * @param s3Object
         *        The details of the S3 object that the finding applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Object(S3Object s3Object);

        /**
         * <p>
         * The details of the S3 object that the finding applies to.
         * </p>
         * This is a convenience that creates an instance of the {@link S3Object.Builder} avoiding the need to create
         * one manually via {@link S3Object#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3Object.Builder#build()} is called immediately and its result is
         * passed to {@link #s3Object(S3Object)}.
         * 
         * @param s3Object
         *        a consumer that will call methods on {@link S3Object.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Object(S3Object)
         */
        default Builder s3Object(Consumer<S3Object.Builder> s3Object) {
            return s3Object(S3Object.builder().applyMutation(s3Object).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private S3Bucket s3Bucket;

        private S3Object s3Object;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourcesAffected model) {
            s3Bucket(model.s3Bucket);
            s3Object(model.s3Object);
        }

        public final S3Bucket.Builder getS3Bucket() {
            return s3Bucket != null ? s3Bucket.toBuilder() : null;
        }

        public final void setS3Bucket(S3Bucket.BuilderImpl s3Bucket) {
            this.s3Bucket = s3Bucket != null ? s3Bucket.build() : null;
        }

        @Override
        @Transient
        public final Builder s3Bucket(S3Bucket s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final S3Object.Builder getS3Object() {
            return s3Object != null ? s3Object.toBuilder() : null;
        }

        public final void setS3Object(S3Object.BuilderImpl s3Object) {
            this.s3Object = s3Object != null ? s3Object.build() : null;
        }

        @Override
        @Transient
        public final Builder s3Object(S3Object s3Object) {
            this.s3Object = s3Object;
            return this;
        }

        @Override
        public ResourcesAffected build() {
            return new ResourcesAffected(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
