/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a property- or tag-based condition that defines criteria for including or excluding S3 objects from a
 * classification job. A JobScopeTerm object can contain only one simpleScopeTerm object or one tagScopeTerm object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobScopeTerm implements SdkPojo, Serializable, ToCopyableBuilder<JobScopeTerm.Builder, JobScopeTerm> {
    private static final SdkField<SimpleScopeTerm> SIMPLE_SCOPE_TERM_FIELD = SdkField
            .<SimpleScopeTerm> builder(MarshallingType.SDK_POJO).memberName("simpleScopeTerm")
            .getter(getter(JobScopeTerm::simpleScopeTerm)).setter(setter(Builder::simpleScopeTerm))
            .constructor(SimpleScopeTerm::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("simpleScopeTerm").build()).build();

    private static final SdkField<TagScopeTerm> TAG_SCOPE_TERM_FIELD = SdkField.<TagScopeTerm> builder(MarshallingType.SDK_POJO)
            .memberName("tagScopeTerm").getter(getter(JobScopeTerm::tagScopeTerm)).setter(setter(Builder::tagScopeTerm))
            .constructor(TagScopeTerm::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagScopeTerm").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIMPLE_SCOPE_TERM_FIELD,
            TAG_SCOPE_TERM_FIELD));

    private static final long serialVersionUID = 1L;

    private final SimpleScopeTerm simpleScopeTerm;

    private final TagScopeTerm tagScopeTerm;

    private JobScopeTerm(BuilderImpl builder) {
        this.simpleScopeTerm = builder.simpleScopeTerm;
        this.tagScopeTerm = builder.tagScopeTerm;
    }

    /**
     * <p>
     * A property-based condition that defines a property, operator, and one or more values for including or excluding
     * objects from the job.
     * </p>
     * 
     * @return A property-based condition that defines a property, operator, and one or more values for including or
     *         excluding objects from the job.
     */
    public final SimpleScopeTerm simpleScopeTerm() {
        return simpleScopeTerm;
    }

    /**
     * <p>
     * A tag-based condition that defines the operator and tag keys or tag key and value pairs for including or
     * excluding objects from the job.
     * </p>
     * 
     * @return A tag-based condition that defines the operator and tag keys or tag key and value pairs for including or
     *         excluding objects from the job.
     */
    public final TagScopeTerm tagScopeTerm() {
        return tagScopeTerm;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(simpleScopeTerm());
        hashCode = 31 * hashCode + Objects.hashCode(tagScopeTerm());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobScopeTerm)) {
            return false;
        }
        JobScopeTerm other = (JobScopeTerm) obj;
        return Objects.equals(simpleScopeTerm(), other.simpleScopeTerm()) && Objects.equals(tagScopeTerm(), other.tagScopeTerm());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobScopeTerm").add("SimpleScopeTerm", simpleScopeTerm()).add("TagScopeTerm", tagScopeTerm())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "simpleScopeTerm":
            return Optional.ofNullable(clazz.cast(simpleScopeTerm()));
        case "tagScopeTerm":
            return Optional.ofNullable(clazz.cast(tagScopeTerm()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobScopeTerm, T> g) {
        return obj -> g.apply((JobScopeTerm) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobScopeTerm> {
        /**
         * <p>
         * A property-based condition that defines a property, operator, and one or more values for including or
         * excluding objects from the job.
         * </p>
         * 
         * @param simpleScopeTerm
         *        A property-based condition that defines a property, operator, and one or more values for including or
         *        excluding objects from the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder simpleScopeTerm(SimpleScopeTerm simpleScopeTerm);

        /**
         * <p>
         * A property-based condition that defines a property, operator, and one or more values for including or
         * excluding objects from the job.
         * </p>
         * This is a convenience that creates an instance of the {@link SimpleScopeTerm.Builder} avoiding the need to
         * create one manually via {@link SimpleScopeTerm#builder()}.
         *
         * When the {@link Consumer} completes, {@link SimpleScopeTerm.Builder#build()} is called immediately and its
         * result is passed to {@link #simpleScopeTerm(SimpleScopeTerm)}.
         * 
         * @param simpleScopeTerm
         *        a consumer that will call methods on {@link SimpleScopeTerm.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #simpleScopeTerm(SimpleScopeTerm)
         */
        default Builder simpleScopeTerm(Consumer<SimpleScopeTerm.Builder> simpleScopeTerm) {
            return simpleScopeTerm(SimpleScopeTerm.builder().applyMutation(simpleScopeTerm).build());
        }

        /**
         * <p>
         * A tag-based condition that defines the operator and tag keys or tag key and value pairs for including or
         * excluding objects from the job.
         * </p>
         * 
         * @param tagScopeTerm
         *        A tag-based condition that defines the operator and tag keys or tag key and value pairs for including
         *        or excluding objects from the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagScopeTerm(TagScopeTerm tagScopeTerm);

        /**
         * <p>
         * A tag-based condition that defines the operator and tag keys or tag key and value pairs for including or
         * excluding objects from the job.
         * </p>
         * This is a convenience that creates an instance of the {@link TagScopeTerm.Builder} avoiding the need to
         * create one manually via {@link TagScopeTerm#builder()}.
         *
         * When the {@link Consumer} completes, {@link TagScopeTerm.Builder#build()} is called immediately and its
         * result is passed to {@link #tagScopeTerm(TagScopeTerm)}.
         * 
         * @param tagScopeTerm
         *        a consumer that will call methods on {@link TagScopeTerm.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagScopeTerm(TagScopeTerm)
         */
        default Builder tagScopeTerm(Consumer<TagScopeTerm.Builder> tagScopeTerm) {
            return tagScopeTerm(TagScopeTerm.builder().applyMutation(tagScopeTerm).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SimpleScopeTerm simpleScopeTerm;

        private TagScopeTerm tagScopeTerm;

        private BuilderImpl() {
        }

        private BuilderImpl(JobScopeTerm model) {
            simpleScopeTerm(model.simpleScopeTerm);
            tagScopeTerm(model.tagScopeTerm);
        }

        public final SimpleScopeTerm.Builder getSimpleScopeTerm() {
            return simpleScopeTerm != null ? simpleScopeTerm.toBuilder() : null;
        }

        public final void setSimpleScopeTerm(SimpleScopeTerm.BuilderImpl simpleScopeTerm) {
            this.simpleScopeTerm = simpleScopeTerm != null ? simpleScopeTerm.build() : null;
        }

        @Override
        @Transient
        public final Builder simpleScopeTerm(SimpleScopeTerm simpleScopeTerm) {
            this.simpleScopeTerm = simpleScopeTerm;
            return this;
        }

        public final TagScopeTerm.Builder getTagScopeTerm() {
            return tagScopeTerm != null ? tagScopeTerm.toBuilder() : null;
        }

        public final void setTagScopeTerm(TagScopeTerm.BuilderImpl tagScopeTerm) {
            this.tagScopeTerm = tagScopeTerm != null ? tagScopeTerm.build() : null;
        }

        @Override
        @Transient
        public final Builder tagScopeTerm(TagScopeTerm tagScopeTerm) {
            this.tagScopeTerm = tagScopeTerm;
            return this;
        }

        @Override
        public JobScopeTerm build() {
            return new JobScopeTerm(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
