/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies whether any one-time or recurring classification jobs are configured to analyze data in an S3 bucket, and,
 * if so, the details of the job that ran most recently.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobDetails implements SdkPojo, Serializable, ToCopyableBuilder<JobDetails.Builder, JobDetails> {
    private static final SdkField<String> IS_DEFINED_IN_JOB_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("isDefinedInJob").getter(getter(JobDetails::isDefinedInJobAsString))
            .setter(setter(Builder::isDefinedInJob))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isDefinedInJob").build()).build();

    private static final SdkField<String> IS_MONITORED_BY_JOB_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("isMonitoredByJob").getter(getter(JobDetails::isMonitoredByJobAsString))
            .setter(setter(Builder::isMonitoredByJob))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isMonitoredByJob").build()).build();

    private static final SdkField<String> LAST_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastJobId").getter(getter(JobDetails::lastJobId)).setter(setter(Builder::lastJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastJobId").build()).build();

    private static final SdkField<Instant> LAST_JOB_RUN_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastJobRunTime")
            .getter(getter(JobDetails::lastJobRunTime))
            .setter(setter(Builder::lastJobRunTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastJobRunTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IS_DEFINED_IN_JOB_FIELD,
            IS_MONITORED_BY_JOB_FIELD, LAST_JOB_ID_FIELD, LAST_JOB_RUN_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String isDefinedInJob;

    private final String isMonitoredByJob;

    private final String lastJobId;

    private final Instant lastJobRunTime;

    private JobDetails(BuilderImpl builder) {
        this.isDefinedInJob = builder.isDefinedInJob;
        this.isMonitoredByJob = builder.isMonitoredByJob;
        this.lastJobId = builder.lastJobId;
        this.lastJobRunTime = builder.lastJobRunTime;
    }

    /**
     * <p>
     * Specifies whether any one-time or recurring jobs are configured to analyze data in the bucket. Possible values
     * are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * TRUE - The bucket is explicitly included in the bucket definition (S3BucketDefinitionForJob) for one or more jobs
     * and at least one of those jobs has a status other than CANCELLED. Or the bucket matched the bucket criteria
     * (S3BucketCriteriaForJob) for at least one job that previously ran.
     * </p>
     * </li>
     * <li>
     * <p>
     * FALSE - The bucket isn't explicitly included in the bucket definition (S3BucketDefinitionForJob) for any jobs,
     * all the jobs that explicitly include the bucket in their bucket definitions have a status of CANCELLED, or the
     * bucket didn't match the bucket criteria (S3BucketCriteriaForJob) for any jobs that previously ran.
     * </p>
     * </li>
     * <li>
     * <p>
     * UNKNOWN - An exception occurred when Amazon Macie attempted to retrieve job data for the bucket.
     * </p>
     * </li>
     * </ul>
     * <p>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #isDefinedInJob}
     * will return {@link IsDefinedInJob#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #isDefinedInJobAsString}.
     * </p>
     * 
     * @return Specifies whether any one-time or recurring jobs are configured to analyze data in the bucket. Possible
     *         values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         TRUE - The bucket is explicitly included in the bucket definition (S3BucketDefinitionForJob) for one or
     *         more jobs and at least one of those jobs has a status other than CANCELLED. Or the bucket matched the
     *         bucket criteria (S3BucketCriteriaForJob) for at least one job that previously ran.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FALSE - The bucket isn't explicitly included in the bucket definition (S3BucketDefinitionForJob) for any
     *         jobs, all the jobs that explicitly include the bucket in their bucket definitions have a status of
     *         CANCELLED, or the bucket didn't match the bucket criteria (S3BucketCriteriaForJob) for any jobs that
     *         previously ran.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNKNOWN - An exception occurred when Amazon Macie attempted to retrieve job data for the bucket.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     * @see IsDefinedInJob
     */
    public final IsDefinedInJob isDefinedInJob() {
        return IsDefinedInJob.fromValue(isDefinedInJob);
    }

    /**
     * <p>
     * Specifies whether any one-time or recurring jobs are configured to analyze data in the bucket. Possible values
     * are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * TRUE - The bucket is explicitly included in the bucket definition (S3BucketDefinitionForJob) for one or more jobs
     * and at least one of those jobs has a status other than CANCELLED. Or the bucket matched the bucket criteria
     * (S3BucketCriteriaForJob) for at least one job that previously ran.
     * </p>
     * </li>
     * <li>
     * <p>
     * FALSE - The bucket isn't explicitly included in the bucket definition (S3BucketDefinitionForJob) for any jobs,
     * all the jobs that explicitly include the bucket in their bucket definitions have a status of CANCELLED, or the
     * bucket didn't match the bucket criteria (S3BucketCriteriaForJob) for any jobs that previously ran.
     * </p>
     * </li>
     * <li>
     * <p>
     * UNKNOWN - An exception occurred when Amazon Macie attempted to retrieve job data for the bucket.
     * </p>
     * </li>
     * </ul>
     * <p>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #isDefinedInJob}
     * will return {@link IsDefinedInJob#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #isDefinedInJobAsString}.
     * </p>
     * 
     * @return Specifies whether any one-time or recurring jobs are configured to analyze data in the bucket. Possible
     *         values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         TRUE - The bucket is explicitly included in the bucket definition (S3BucketDefinitionForJob) for one or
     *         more jobs and at least one of those jobs has a status other than CANCELLED. Or the bucket matched the
     *         bucket criteria (S3BucketCriteriaForJob) for at least one job that previously ran.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FALSE - The bucket isn't explicitly included in the bucket definition (S3BucketDefinitionForJob) for any
     *         jobs, all the jobs that explicitly include the bucket in their bucket definitions have a status of
     *         CANCELLED, or the bucket didn't match the bucket criteria (S3BucketCriteriaForJob) for any jobs that
     *         previously ran.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNKNOWN - An exception occurred when Amazon Macie attempted to retrieve job data for the bucket.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     * @see IsDefinedInJob
     */
    public final String isDefinedInJobAsString() {
        return isDefinedInJob;
    }

    /**
     * <p>
     * Specifies whether any recurring jobs are configured to analyze data in the bucket. Possible values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * TRUE - The bucket is explicitly included in the bucket definition (S3BucketDefinitionForJob) for one or more
     * recurring jobs or the bucket matches the bucket criteria (S3BucketCriteriaForJob) for one or more recurring jobs.
     * At least one of those jobs has a status other than CANCELLED.
     * </p>
     * </li>
     * <li>
     * <p>
     * FALSE - The bucket isn't explicitly included in the bucket definition (S3BucketDefinitionForJob) for any
     * recurring jobs, the bucket doesn't match the bucket criteria (S3BucketCriteriaForJob) for any recurring jobs, or
     * all the recurring jobs that are configured to analyze data in the bucket have a status of CANCELLED.
     * </p>
     * </li>
     * <li>
     * <p>
     * UNKNOWN - An exception occurred when Amazon Macie attempted to retrieve job data for the bucket.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #isMonitoredByJob}
     * will return {@link IsMonitoredByJob#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #isMonitoredByJobAsString}.
     * </p>
     * 
     * @return Specifies whether any recurring jobs are configured to analyze data in the bucket. Possible values
     *         are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         TRUE - The bucket is explicitly included in the bucket definition (S3BucketDefinitionForJob) for one or
     *         more recurring jobs or the bucket matches the bucket criteria (S3BucketCriteriaForJob) for one or more
     *         recurring jobs. At least one of those jobs has a status other than CANCELLED.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FALSE - The bucket isn't explicitly included in the bucket definition (S3BucketDefinitionForJob) for any
     *         recurring jobs, the bucket doesn't match the bucket criteria (S3BucketCriteriaForJob) for any recurring
     *         jobs, or all the recurring jobs that are configured to analyze data in the bucket have a status of
     *         CANCELLED.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNKNOWN - An exception occurred when Amazon Macie attempted to retrieve job data for the bucket.
     *         </p>
     *         </li>
     * @see IsMonitoredByJob
     */
    public final IsMonitoredByJob isMonitoredByJob() {
        return IsMonitoredByJob.fromValue(isMonitoredByJob);
    }

    /**
     * <p>
     * Specifies whether any recurring jobs are configured to analyze data in the bucket. Possible values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * TRUE - The bucket is explicitly included in the bucket definition (S3BucketDefinitionForJob) for one or more
     * recurring jobs or the bucket matches the bucket criteria (S3BucketCriteriaForJob) for one or more recurring jobs.
     * At least one of those jobs has a status other than CANCELLED.
     * </p>
     * </li>
     * <li>
     * <p>
     * FALSE - The bucket isn't explicitly included in the bucket definition (S3BucketDefinitionForJob) for any
     * recurring jobs, the bucket doesn't match the bucket criteria (S3BucketCriteriaForJob) for any recurring jobs, or
     * all the recurring jobs that are configured to analyze data in the bucket have a status of CANCELLED.
     * </p>
     * </li>
     * <li>
     * <p>
     * UNKNOWN - An exception occurred when Amazon Macie attempted to retrieve job data for the bucket.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #isMonitoredByJob}
     * will return {@link IsMonitoredByJob#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #isMonitoredByJobAsString}.
     * </p>
     * 
     * @return Specifies whether any recurring jobs are configured to analyze data in the bucket. Possible values
     *         are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         TRUE - The bucket is explicitly included in the bucket definition (S3BucketDefinitionForJob) for one or
     *         more recurring jobs or the bucket matches the bucket criteria (S3BucketCriteriaForJob) for one or more
     *         recurring jobs. At least one of those jobs has a status other than CANCELLED.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FALSE - The bucket isn't explicitly included in the bucket definition (S3BucketDefinitionForJob) for any
     *         recurring jobs, the bucket doesn't match the bucket criteria (S3BucketCriteriaForJob) for any recurring
     *         jobs, or all the recurring jobs that are configured to analyze data in the bucket have a status of
     *         CANCELLED.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNKNOWN - An exception occurred when Amazon Macie attempted to retrieve job data for the bucket.
     *         </p>
     *         </li>
     * @see IsMonitoredByJob
     */
    public final String isMonitoredByJobAsString() {
        return isMonitoredByJob;
    }

    /**
     * <p>
     * The unique identifier for the job that ran most recently and is configured to analyze data in the bucket, either
     * the latest run of a recurring job or the only run of a one-time job.
     * </p>
     * <p>
     * This value is typically null if the value for the isDefinedInJob property is FALSE or UNKNOWN.
     * </p>
     * 
     * @return The unique identifier for the job that ran most recently and is configured to analyze data in the bucket,
     *         either the latest run of a recurring job or the only run of a one-time job.</p>
     *         <p>
     *         This value is typically null if the value for the isDefinedInJob property is FALSE or UNKNOWN.
     */
    public final String lastJobId() {
        return lastJobId;
    }

    /**
     * <p>
     * The date and time, in UTC and extended ISO 8601 format, when the job (lastJobId) started. If the job is a
     * recurring job, this value indicates when the most recent run started.
     * </p>
     * <p>
     * This value is typically null if the value for the isDefinedInJob property is FALSE or UNKNOWN.
     * </p>
     * 
     * @return The date and time, in UTC and extended ISO 8601 format, when the job (lastJobId) started. If the job is a
     *         recurring job, this value indicates when the most recent run started.</p>
     *         <p>
     *         This value is typically null if the value for the isDefinedInJob property is FALSE or UNKNOWN.
     */
    public final Instant lastJobRunTime() {
        return lastJobRunTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(isDefinedInJobAsString());
        hashCode = 31 * hashCode + Objects.hashCode(isMonitoredByJobAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastJobId());
        hashCode = 31 * hashCode + Objects.hashCode(lastJobRunTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobDetails)) {
            return false;
        }
        JobDetails other = (JobDetails) obj;
        return Objects.equals(isDefinedInJobAsString(), other.isDefinedInJobAsString())
                && Objects.equals(isMonitoredByJobAsString(), other.isMonitoredByJobAsString())
                && Objects.equals(lastJobId(), other.lastJobId()) && Objects.equals(lastJobRunTime(), other.lastJobRunTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobDetails").add("IsDefinedInJob", isDefinedInJobAsString())
                .add("IsMonitoredByJob", isMonitoredByJobAsString()).add("LastJobId", lastJobId())
                .add("LastJobRunTime", lastJobRunTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "isDefinedInJob":
            return Optional.ofNullable(clazz.cast(isDefinedInJobAsString()));
        case "isMonitoredByJob":
            return Optional.ofNullable(clazz.cast(isMonitoredByJobAsString()));
        case "lastJobId":
            return Optional.ofNullable(clazz.cast(lastJobId()));
        case "lastJobRunTime":
            return Optional.ofNullable(clazz.cast(lastJobRunTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobDetails, T> g) {
        return obj -> g.apply((JobDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobDetails> {
        /**
         * <p>
         * Specifies whether any one-time or recurring jobs are configured to analyze data in the bucket. Possible
         * values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * TRUE - The bucket is explicitly included in the bucket definition (S3BucketDefinitionForJob) for one or more
         * jobs and at least one of those jobs has a status other than CANCELLED. Or the bucket matched the bucket
         * criteria (S3BucketCriteriaForJob) for at least one job that previously ran.
         * </p>
         * </li>
         * <li>
         * <p>
         * FALSE - The bucket isn't explicitly included in the bucket definition (S3BucketDefinitionForJob) for any
         * jobs, all the jobs that explicitly include the bucket in their bucket definitions have a status of CANCELLED,
         * or the bucket didn't match the bucket criteria (S3BucketCriteriaForJob) for any jobs that previously ran.
         * </p>
         * </li>
         * <li>
         * <p>
         * UNKNOWN - An exception occurred when Amazon Macie attempted to retrieve job data for the bucket.
         * </p>
         * </li>
         * </ul>
         * <p>
         * </p>
         * 
         * @param isDefinedInJob
         *        Specifies whether any one-time or recurring jobs are configured to analyze data in the bucket.
         *        Possible values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        TRUE - The bucket is explicitly included in the bucket definition (S3BucketDefinitionForJob) for one
         *        or more jobs and at least one of those jobs has a status other than CANCELLED. Or the bucket matched
         *        the bucket criteria (S3BucketCriteriaForJob) for at least one job that previously ran.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FALSE - The bucket isn't explicitly included in the bucket definition (S3BucketDefinitionForJob) for
         *        any jobs, all the jobs that explicitly include the bucket in their bucket definitions have a status of
         *        CANCELLED, or the bucket didn't match the bucket criteria (S3BucketCriteriaForJob) for any jobs that
         *        previously ran.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UNKNOWN - An exception occurred when Amazon Macie attempted to retrieve job data for the bucket.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         * @see IsDefinedInJob
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IsDefinedInJob
         */
        Builder isDefinedInJob(String isDefinedInJob);

        /**
         * <p>
         * Specifies whether any one-time or recurring jobs are configured to analyze data in the bucket. Possible
         * values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * TRUE - The bucket is explicitly included in the bucket definition (S3BucketDefinitionForJob) for one or more
         * jobs and at least one of those jobs has a status other than CANCELLED. Or the bucket matched the bucket
         * criteria (S3BucketCriteriaForJob) for at least one job that previously ran.
         * </p>
         * </li>
         * <li>
         * <p>
         * FALSE - The bucket isn't explicitly included in the bucket definition (S3BucketDefinitionForJob) for any
         * jobs, all the jobs that explicitly include the bucket in their bucket definitions have a status of CANCELLED,
         * or the bucket didn't match the bucket criteria (S3BucketCriteriaForJob) for any jobs that previously ran.
         * </p>
         * </li>
         * <li>
         * <p>
         * UNKNOWN - An exception occurred when Amazon Macie attempted to retrieve job data for the bucket.
         * </p>
         * </li>
         * </ul>
         * <p>
         * </p>
         * 
         * @param isDefinedInJob
         *        Specifies whether any one-time or recurring jobs are configured to analyze data in the bucket.
         *        Possible values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        TRUE - The bucket is explicitly included in the bucket definition (S3BucketDefinitionForJob) for one
         *        or more jobs and at least one of those jobs has a status other than CANCELLED. Or the bucket matched
         *        the bucket criteria (S3BucketCriteriaForJob) for at least one job that previously ran.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FALSE - The bucket isn't explicitly included in the bucket definition (S3BucketDefinitionForJob) for
         *        any jobs, all the jobs that explicitly include the bucket in their bucket definitions have a status of
         *        CANCELLED, or the bucket didn't match the bucket criteria (S3BucketCriteriaForJob) for any jobs that
         *        previously ran.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UNKNOWN - An exception occurred when Amazon Macie attempted to retrieve job data for the bucket.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         * @see IsDefinedInJob
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IsDefinedInJob
         */
        Builder isDefinedInJob(IsDefinedInJob isDefinedInJob);

        /**
         * <p>
         * Specifies whether any recurring jobs are configured to analyze data in the bucket. Possible values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * TRUE - The bucket is explicitly included in the bucket definition (S3BucketDefinitionForJob) for one or more
         * recurring jobs or the bucket matches the bucket criteria (S3BucketCriteriaForJob) for one or more recurring
         * jobs. At least one of those jobs has a status other than CANCELLED.
         * </p>
         * </li>
         * <li>
         * <p>
         * FALSE - The bucket isn't explicitly included in the bucket definition (S3BucketDefinitionForJob) for any
         * recurring jobs, the bucket doesn't match the bucket criteria (S3BucketCriteriaForJob) for any recurring jobs,
         * or all the recurring jobs that are configured to analyze data in the bucket have a status of CANCELLED.
         * </p>
         * </li>
         * <li>
         * <p>
         * UNKNOWN - An exception occurred when Amazon Macie attempted to retrieve job data for the bucket.
         * </p>
         * </li>
         * </ul>
         * 
         * @param isMonitoredByJob
         *        Specifies whether any recurring jobs are configured to analyze data in the bucket. Possible values
         *        are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        TRUE - The bucket is explicitly included in the bucket definition (S3BucketDefinitionForJob) for one
         *        or more recurring jobs or the bucket matches the bucket criteria (S3BucketCriteriaForJob) for one or
         *        more recurring jobs. At least one of those jobs has a status other than CANCELLED.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FALSE - The bucket isn't explicitly included in the bucket definition (S3BucketDefinitionForJob) for
         *        any recurring jobs, the bucket doesn't match the bucket criteria (S3BucketCriteriaForJob) for any
         *        recurring jobs, or all the recurring jobs that are configured to analyze data in the bucket have a
         *        status of CANCELLED.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UNKNOWN - An exception occurred when Amazon Macie attempted to retrieve job data for the bucket.
         *        </p>
         *        </li>
         * @see IsMonitoredByJob
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IsMonitoredByJob
         */
        Builder isMonitoredByJob(String isMonitoredByJob);

        /**
         * <p>
         * Specifies whether any recurring jobs are configured to analyze data in the bucket. Possible values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * TRUE - The bucket is explicitly included in the bucket definition (S3BucketDefinitionForJob) for one or more
         * recurring jobs or the bucket matches the bucket criteria (S3BucketCriteriaForJob) for one or more recurring
         * jobs. At least one of those jobs has a status other than CANCELLED.
         * </p>
         * </li>
         * <li>
         * <p>
         * FALSE - The bucket isn't explicitly included in the bucket definition (S3BucketDefinitionForJob) for any
         * recurring jobs, the bucket doesn't match the bucket criteria (S3BucketCriteriaForJob) for any recurring jobs,
         * or all the recurring jobs that are configured to analyze data in the bucket have a status of CANCELLED.
         * </p>
         * </li>
         * <li>
         * <p>
         * UNKNOWN - An exception occurred when Amazon Macie attempted to retrieve job data for the bucket.
         * </p>
         * </li>
         * </ul>
         * 
         * @param isMonitoredByJob
         *        Specifies whether any recurring jobs are configured to analyze data in the bucket. Possible values
         *        are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        TRUE - The bucket is explicitly included in the bucket definition (S3BucketDefinitionForJob) for one
         *        or more recurring jobs or the bucket matches the bucket criteria (S3BucketCriteriaForJob) for one or
         *        more recurring jobs. At least one of those jobs has a status other than CANCELLED.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FALSE - The bucket isn't explicitly included in the bucket definition (S3BucketDefinitionForJob) for
         *        any recurring jobs, the bucket doesn't match the bucket criteria (S3BucketCriteriaForJob) for any
         *        recurring jobs, or all the recurring jobs that are configured to analyze data in the bucket have a
         *        status of CANCELLED.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UNKNOWN - An exception occurred when Amazon Macie attempted to retrieve job data for the bucket.
         *        </p>
         *        </li>
         * @see IsMonitoredByJob
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IsMonitoredByJob
         */
        Builder isMonitoredByJob(IsMonitoredByJob isMonitoredByJob);

        /**
         * <p>
         * The unique identifier for the job that ran most recently and is configured to analyze data in the bucket,
         * either the latest run of a recurring job or the only run of a one-time job.
         * </p>
         * <p>
         * This value is typically null if the value for the isDefinedInJob property is FALSE or UNKNOWN.
         * </p>
         * 
         * @param lastJobId
         *        The unique identifier for the job that ran most recently and is configured to analyze data in the
         *        bucket, either the latest run of a recurring job or the only run of a one-time job.</p>
         *        <p>
         *        This value is typically null if the value for the isDefinedInJob property is FALSE or UNKNOWN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastJobId(String lastJobId);

        /**
         * <p>
         * The date and time, in UTC and extended ISO 8601 format, when the job (lastJobId) started. If the job is a
         * recurring job, this value indicates when the most recent run started.
         * </p>
         * <p>
         * This value is typically null if the value for the isDefinedInJob property is FALSE or UNKNOWN.
         * </p>
         * 
         * @param lastJobRunTime
         *        The date and time, in UTC and extended ISO 8601 format, when the job (lastJobId) started. If the job
         *        is a recurring job, this value indicates when the most recent run started.</p>
         *        <p>
         *        This value is typically null if the value for the isDefinedInJob property is FALSE or UNKNOWN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastJobRunTime(Instant lastJobRunTime);
    }

    static final class BuilderImpl implements Builder {
        private String isDefinedInJob;

        private String isMonitoredByJob;

        private String lastJobId;

        private Instant lastJobRunTime;

        private BuilderImpl() {
        }

        private BuilderImpl(JobDetails model) {
            isDefinedInJob(model.isDefinedInJob);
            isMonitoredByJob(model.isMonitoredByJob);
            lastJobId(model.lastJobId);
            lastJobRunTime(model.lastJobRunTime);
        }

        public final String getIsDefinedInJob() {
            return isDefinedInJob;
        }

        public final void setIsDefinedInJob(String isDefinedInJob) {
            this.isDefinedInJob = isDefinedInJob;
        }

        @Override
        @Transient
        public final Builder isDefinedInJob(String isDefinedInJob) {
            this.isDefinedInJob = isDefinedInJob;
            return this;
        }

        @Override
        @Transient
        public final Builder isDefinedInJob(IsDefinedInJob isDefinedInJob) {
            this.isDefinedInJob(isDefinedInJob == null ? null : isDefinedInJob.toString());
            return this;
        }

        public final String getIsMonitoredByJob() {
            return isMonitoredByJob;
        }

        public final void setIsMonitoredByJob(String isMonitoredByJob) {
            this.isMonitoredByJob = isMonitoredByJob;
        }

        @Override
        @Transient
        public final Builder isMonitoredByJob(String isMonitoredByJob) {
            this.isMonitoredByJob = isMonitoredByJob;
            return this;
        }

        @Override
        @Transient
        public final Builder isMonitoredByJob(IsMonitoredByJob isMonitoredByJob) {
            this.isMonitoredByJob(isMonitoredByJob == null ? null : isMonitoredByJob.toString());
            return this;
        }

        public final String getLastJobId() {
            return lastJobId;
        }

        public final void setLastJobId(String lastJobId) {
            this.lastJobId = lastJobId;
        }

        @Override
        @Transient
        public final Builder lastJobId(String lastJobId) {
            this.lastJobId = lastJobId;
            return this;
        }

        public final Instant getLastJobRunTime() {
            return lastJobRunTime;
        }

        public final void setLastJobRunTime(Instant lastJobRunTime) {
            this.lastJobRunTime = lastJobRunTime;
        }

        @Override
        @Transient
        public final Builder lastJobRunTime(Instant lastJobRunTime) {
            this.lastJobRunTime = lastJobRunTime;
            return this;
        }

        @Override
        public JobDetails build() {
            return new JobDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
