/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the number of S3 buckets whose bucket policies do or don't require server-side encryption
 * of objects when objects are uploaded to the buckets.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BucketCountPolicyAllowsUnencryptedObjectUploads
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<BucketCountPolicyAllowsUnencryptedObjectUploads.Builder, BucketCountPolicyAllowsUnencryptedObjectUploads> {
    private static final SdkField<Long> ALLOWS_UNENCRYPTED_OBJECT_UPLOADS_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("allowsUnencryptedObjectUploads")
            .getter(getter(BucketCountPolicyAllowsUnencryptedObjectUploads::allowsUnencryptedObjectUploads))
            .setter(setter(Builder::allowsUnencryptedObjectUploads))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowsUnencryptedObjectUploads")
                    .build()).build();

    private static final SdkField<Long> DENIES_UNENCRYPTED_OBJECT_UPLOADS_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("deniesUnencryptedObjectUploads")
            .getter(getter(BucketCountPolicyAllowsUnencryptedObjectUploads::deniesUnencryptedObjectUploads))
            .setter(setter(Builder::deniesUnencryptedObjectUploads))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deniesUnencryptedObjectUploads")
                    .build()).build();

    private static final SdkField<Long> UNKNOWN_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("unknown")
            .getter(getter(BucketCountPolicyAllowsUnencryptedObjectUploads::unknown)).setter(setter(Builder::unknown))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unknown").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ALLOWS_UNENCRYPTED_OBJECT_UPLOADS_FIELD, DENIES_UNENCRYPTED_OBJECT_UPLOADS_FIELD, UNKNOWN_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long allowsUnencryptedObjectUploads;

    private final Long deniesUnencryptedObjectUploads;

    private final Long unknown;

    private BucketCountPolicyAllowsUnencryptedObjectUploads(BuilderImpl builder) {
        this.allowsUnencryptedObjectUploads = builder.allowsUnencryptedObjectUploads;
        this.deniesUnencryptedObjectUploads = builder.deniesUnencryptedObjectUploads;
        this.unknown = builder.unknown;
    }

    /**
     * <p>
     * The total number of buckets that don't have a bucket policy or have a bucket policy that doesn't require
     * server-side encryption of new objects. If a bucket policy exists, the policy doesn't require PutObject requests
     * to include the x-amz-server-side-encryption header and it doesn't require the value for that header to be AES256
     * or aws:kms.
     * </p>
     * 
     * @return The total number of buckets that don't have a bucket policy or have a bucket policy that doesn't require
     *         server-side encryption of new objects. If a bucket policy exists, the policy doesn't require PutObject
     *         requests to include the x-amz-server-side-encryption header and it doesn't require the value for that
     *         header to be AES256 or aws:kms.
     */
    public final Long allowsUnencryptedObjectUploads() {
        return allowsUnencryptedObjectUploads;
    }

    /**
     * <p>
     * The total number of buckets whose bucket policies require server-side encryption of new objects. PutObject
     * requests for these buckets must include the x-amz-server-side-encryption header and the value for that header
     * must be AES256 or aws:kms.
     * </p>
     * 
     * @return The total number of buckets whose bucket policies require server-side encryption of new objects.
     *         PutObject requests for these buckets must include the x-amz-server-side-encryption header and the value
     *         for that header must be AES256 or aws:kms.
     */
    public final Long deniesUnencryptedObjectUploads() {
        return deniesUnencryptedObjectUploads;
    }

    /**
     * <p>
     * The total number of buckets that Amazon Macie wasn't able to evaluate server-side encryption requirements for.
     * Macie can't determine whether the bucket policies for these buckets require server-side encryption of new
     * objects.
     * </p>
     * 
     * @return The total number of buckets that Amazon Macie wasn't able to evaluate server-side encryption requirements
     *         for. Macie can't determine whether the bucket policies for these buckets require server-side encryption
     *         of new objects.
     */
    public final Long unknown() {
        return unknown;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(allowsUnencryptedObjectUploads());
        hashCode = 31 * hashCode + Objects.hashCode(deniesUnencryptedObjectUploads());
        hashCode = 31 * hashCode + Objects.hashCode(unknown());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BucketCountPolicyAllowsUnencryptedObjectUploads)) {
            return false;
        }
        BucketCountPolicyAllowsUnencryptedObjectUploads other = (BucketCountPolicyAllowsUnencryptedObjectUploads) obj;
        return Objects.equals(allowsUnencryptedObjectUploads(), other.allowsUnencryptedObjectUploads())
                && Objects.equals(deniesUnencryptedObjectUploads(), other.deniesUnencryptedObjectUploads())
                && Objects.equals(unknown(), other.unknown());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BucketCountPolicyAllowsUnencryptedObjectUploads")
                .add("AllowsUnencryptedObjectUploads", allowsUnencryptedObjectUploads())
                .add("DeniesUnencryptedObjectUploads", deniesUnencryptedObjectUploads()).add("Unknown", unknown()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "allowsUnencryptedObjectUploads":
            return Optional.ofNullable(clazz.cast(allowsUnencryptedObjectUploads()));
        case "deniesUnencryptedObjectUploads":
            return Optional.ofNullable(clazz.cast(deniesUnencryptedObjectUploads()));
        case "unknown":
            return Optional.ofNullable(clazz.cast(unknown()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BucketCountPolicyAllowsUnencryptedObjectUploads, T> g) {
        return obj -> g.apply((BucketCountPolicyAllowsUnencryptedObjectUploads) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BucketCountPolicyAllowsUnencryptedObjectUploads> {
        /**
         * <p>
         * The total number of buckets that don't have a bucket policy or have a bucket policy that doesn't require
         * server-side encryption of new objects. If a bucket policy exists, the policy doesn't require PutObject
         * requests to include the x-amz-server-side-encryption header and it doesn't require the value for that header
         * to be AES256 or aws:kms.
         * </p>
         * 
         * @param allowsUnencryptedObjectUploads
         *        The total number of buckets that don't have a bucket policy or have a bucket policy that doesn't
         *        require server-side encryption of new objects. If a bucket policy exists, the policy doesn't require
         *        PutObject requests to include the x-amz-server-side-encryption header and it doesn't require the value
         *        for that header to be AES256 or aws:kms.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowsUnencryptedObjectUploads(Long allowsUnencryptedObjectUploads);

        /**
         * <p>
         * The total number of buckets whose bucket policies require server-side encryption of new objects. PutObject
         * requests for these buckets must include the x-amz-server-side-encryption header and the value for that header
         * must be AES256 or aws:kms.
         * </p>
         * 
         * @param deniesUnencryptedObjectUploads
         *        The total number of buckets whose bucket policies require server-side encryption of new objects.
         *        PutObject requests for these buckets must include the x-amz-server-side-encryption header and the
         *        value for that header must be AES256 or aws:kms.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deniesUnencryptedObjectUploads(Long deniesUnencryptedObjectUploads);

        /**
         * <p>
         * The total number of buckets that Amazon Macie wasn't able to evaluate server-side encryption requirements
         * for. Macie can't determine whether the bucket policies for these buckets require server-side encryption of
         * new objects.
         * </p>
         * 
         * @param unknown
         *        The total number of buckets that Amazon Macie wasn't able to evaluate server-side encryption
         *        requirements for. Macie can't determine whether the bucket policies for these buckets require
         *        server-side encryption of new objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unknown(Long unknown);
    }

    static final class BuilderImpl implements Builder {
        private Long allowsUnencryptedObjectUploads;

        private Long deniesUnencryptedObjectUploads;

        private Long unknown;

        private BuilderImpl() {
        }

        private BuilderImpl(BucketCountPolicyAllowsUnencryptedObjectUploads model) {
            allowsUnencryptedObjectUploads(model.allowsUnencryptedObjectUploads);
            deniesUnencryptedObjectUploads(model.deniesUnencryptedObjectUploads);
            unknown(model.unknown);
        }

        public final Long getAllowsUnencryptedObjectUploads() {
            return allowsUnencryptedObjectUploads;
        }

        public final void setAllowsUnencryptedObjectUploads(Long allowsUnencryptedObjectUploads) {
            this.allowsUnencryptedObjectUploads = allowsUnencryptedObjectUploads;
        }

        @Override
        @Transient
        public final Builder allowsUnencryptedObjectUploads(Long allowsUnencryptedObjectUploads) {
            this.allowsUnencryptedObjectUploads = allowsUnencryptedObjectUploads;
            return this;
        }

        public final Long getDeniesUnencryptedObjectUploads() {
            return deniesUnencryptedObjectUploads;
        }

        public final void setDeniesUnencryptedObjectUploads(Long deniesUnencryptedObjectUploads) {
            this.deniesUnencryptedObjectUploads = deniesUnencryptedObjectUploads;
        }

        @Override
        @Transient
        public final Builder deniesUnencryptedObjectUploads(Long deniesUnencryptedObjectUploads) {
            this.deniesUnencryptedObjectUploads = deniesUnencryptedObjectUploads;
            return this;
        }

        public final Long getUnknown() {
            return unknown;
        }

        public final void setUnknown(Long unknown) {
            this.unknown = unknown;
        }

        @Override
        @Transient
        public final Builder unknown(Long unknown) {
            this.unknown = unknown;
            return this;
        }

        @Override
        public BucketCountPolicyAllowsUnencryptedObjectUploads build() {
            return new BucketCountPolicyAllowsUnencryptedObjectUploads(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
