/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.macie2.model.AcceptInvitationRequest;
import software.amazon.awssdk.services.macie2.model.AcceptInvitationResponse;
import software.amazon.awssdk.services.macie2.model.BatchGetCustomDataIdentifiersRequest;
import software.amazon.awssdk.services.macie2.model.BatchGetCustomDataIdentifiersResponse;
import software.amazon.awssdk.services.macie2.model.CreateClassificationJobRequest;
import software.amazon.awssdk.services.macie2.model.CreateClassificationJobResponse;
import software.amazon.awssdk.services.macie2.model.CreateCustomDataIdentifierRequest;
import software.amazon.awssdk.services.macie2.model.CreateCustomDataIdentifierResponse;
import software.amazon.awssdk.services.macie2.model.CreateFindingsFilterRequest;
import software.amazon.awssdk.services.macie2.model.CreateFindingsFilterResponse;
import software.amazon.awssdk.services.macie2.model.CreateInvitationsRequest;
import software.amazon.awssdk.services.macie2.model.CreateInvitationsResponse;
import software.amazon.awssdk.services.macie2.model.CreateMemberRequest;
import software.amazon.awssdk.services.macie2.model.CreateMemberResponse;
import software.amazon.awssdk.services.macie2.model.CreateSampleFindingsRequest;
import software.amazon.awssdk.services.macie2.model.CreateSampleFindingsResponse;
import software.amazon.awssdk.services.macie2.model.DeclineInvitationsRequest;
import software.amazon.awssdk.services.macie2.model.DeclineInvitationsResponse;
import software.amazon.awssdk.services.macie2.model.DeleteCustomDataIdentifierRequest;
import software.amazon.awssdk.services.macie2.model.DeleteCustomDataIdentifierResponse;
import software.amazon.awssdk.services.macie2.model.DeleteFindingsFilterRequest;
import software.amazon.awssdk.services.macie2.model.DeleteFindingsFilterResponse;
import software.amazon.awssdk.services.macie2.model.DeleteInvitationsRequest;
import software.amazon.awssdk.services.macie2.model.DeleteInvitationsResponse;
import software.amazon.awssdk.services.macie2.model.DeleteMemberRequest;
import software.amazon.awssdk.services.macie2.model.DeleteMemberResponse;
import software.amazon.awssdk.services.macie2.model.DescribeBucketsRequest;
import software.amazon.awssdk.services.macie2.model.DescribeBucketsResponse;
import software.amazon.awssdk.services.macie2.model.DescribeClassificationJobRequest;
import software.amazon.awssdk.services.macie2.model.DescribeClassificationJobResponse;
import software.amazon.awssdk.services.macie2.model.DescribeOrganizationConfigurationRequest;
import software.amazon.awssdk.services.macie2.model.DescribeOrganizationConfigurationResponse;
import software.amazon.awssdk.services.macie2.model.DisableMacieRequest;
import software.amazon.awssdk.services.macie2.model.DisableMacieResponse;
import software.amazon.awssdk.services.macie2.model.DisableOrganizationAdminAccountRequest;
import software.amazon.awssdk.services.macie2.model.DisableOrganizationAdminAccountResponse;
import software.amazon.awssdk.services.macie2.model.DisassociateFromAdministratorAccountRequest;
import software.amazon.awssdk.services.macie2.model.DisassociateFromAdministratorAccountResponse;
import software.amazon.awssdk.services.macie2.model.DisassociateFromMasterAccountRequest;
import software.amazon.awssdk.services.macie2.model.DisassociateFromMasterAccountResponse;
import software.amazon.awssdk.services.macie2.model.DisassociateMemberRequest;
import software.amazon.awssdk.services.macie2.model.DisassociateMemberResponse;
import software.amazon.awssdk.services.macie2.model.EnableMacieRequest;
import software.amazon.awssdk.services.macie2.model.EnableMacieResponse;
import software.amazon.awssdk.services.macie2.model.EnableOrganizationAdminAccountRequest;
import software.amazon.awssdk.services.macie2.model.EnableOrganizationAdminAccountResponse;
import software.amazon.awssdk.services.macie2.model.GetAdministratorAccountRequest;
import software.amazon.awssdk.services.macie2.model.GetAdministratorAccountResponse;
import software.amazon.awssdk.services.macie2.model.GetBucketStatisticsRequest;
import software.amazon.awssdk.services.macie2.model.GetBucketStatisticsResponse;
import software.amazon.awssdk.services.macie2.model.GetClassificationExportConfigurationRequest;
import software.amazon.awssdk.services.macie2.model.GetClassificationExportConfigurationResponse;
import software.amazon.awssdk.services.macie2.model.GetCustomDataIdentifierRequest;
import software.amazon.awssdk.services.macie2.model.GetCustomDataIdentifierResponse;
import software.amazon.awssdk.services.macie2.model.GetFindingStatisticsRequest;
import software.amazon.awssdk.services.macie2.model.GetFindingStatisticsResponse;
import software.amazon.awssdk.services.macie2.model.GetFindingsFilterRequest;
import software.amazon.awssdk.services.macie2.model.GetFindingsFilterResponse;
import software.amazon.awssdk.services.macie2.model.GetFindingsPublicationConfigurationRequest;
import software.amazon.awssdk.services.macie2.model.GetFindingsPublicationConfigurationResponse;
import software.amazon.awssdk.services.macie2.model.GetFindingsRequest;
import software.amazon.awssdk.services.macie2.model.GetFindingsResponse;
import software.amazon.awssdk.services.macie2.model.GetInvitationsCountRequest;
import software.amazon.awssdk.services.macie2.model.GetInvitationsCountResponse;
import software.amazon.awssdk.services.macie2.model.GetMacieSessionRequest;
import software.amazon.awssdk.services.macie2.model.GetMacieSessionResponse;
import software.amazon.awssdk.services.macie2.model.GetMasterAccountRequest;
import software.amazon.awssdk.services.macie2.model.GetMasterAccountResponse;
import software.amazon.awssdk.services.macie2.model.GetMemberRequest;
import software.amazon.awssdk.services.macie2.model.GetMemberResponse;
import software.amazon.awssdk.services.macie2.model.GetUsageStatisticsRequest;
import software.amazon.awssdk.services.macie2.model.GetUsageStatisticsResponse;
import software.amazon.awssdk.services.macie2.model.GetUsageTotalsRequest;
import software.amazon.awssdk.services.macie2.model.GetUsageTotalsResponse;
import software.amazon.awssdk.services.macie2.model.ListClassificationJobsRequest;
import software.amazon.awssdk.services.macie2.model.ListClassificationJobsResponse;
import software.amazon.awssdk.services.macie2.model.ListCustomDataIdentifiersRequest;
import software.amazon.awssdk.services.macie2.model.ListCustomDataIdentifiersResponse;
import software.amazon.awssdk.services.macie2.model.ListFindingsFiltersRequest;
import software.amazon.awssdk.services.macie2.model.ListFindingsFiltersResponse;
import software.amazon.awssdk.services.macie2.model.ListFindingsRequest;
import software.amazon.awssdk.services.macie2.model.ListFindingsResponse;
import software.amazon.awssdk.services.macie2.model.ListInvitationsRequest;
import software.amazon.awssdk.services.macie2.model.ListInvitationsResponse;
import software.amazon.awssdk.services.macie2.model.ListManagedDataIdentifiersRequest;
import software.amazon.awssdk.services.macie2.model.ListManagedDataIdentifiersResponse;
import software.amazon.awssdk.services.macie2.model.ListMembersRequest;
import software.amazon.awssdk.services.macie2.model.ListMembersResponse;
import software.amazon.awssdk.services.macie2.model.ListOrganizationAdminAccountsRequest;
import software.amazon.awssdk.services.macie2.model.ListOrganizationAdminAccountsResponse;
import software.amazon.awssdk.services.macie2.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.macie2.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.macie2.model.PutClassificationExportConfigurationRequest;
import software.amazon.awssdk.services.macie2.model.PutClassificationExportConfigurationResponse;
import software.amazon.awssdk.services.macie2.model.PutFindingsPublicationConfigurationRequest;
import software.amazon.awssdk.services.macie2.model.PutFindingsPublicationConfigurationResponse;
import software.amazon.awssdk.services.macie2.model.SearchResourcesRequest;
import software.amazon.awssdk.services.macie2.model.SearchResourcesResponse;
import software.amazon.awssdk.services.macie2.model.TagResourceRequest;
import software.amazon.awssdk.services.macie2.model.TagResourceResponse;
import software.amazon.awssdk.services.macie2.model.TestCustomDataIdentifierRequest;
import software.amazon.awssdk.services.macie2.model.TestCustomDataIdentifierResponse;
import software.amazon.awssdk.services.macie2.model.UntagResourceRequest;
import software.amazon.awssdk.services.macie2.model.UntagResourceResponse;
import software.amazon.awssdk.services.macie2.model.UpdateClassificationJobRequest;
import software.amazon.awssdk.services.macie2.model.UpdateClassificationJobResponse;
import software.amazon.awssdk.services.macie2.model.UpdateFindingsFilterRequest;
import software.amazon.awssdk.services.macie2.model.UpdateFindingsFilterResponse;
import software.amazon.awssdk.services.macie2.model.UpdateMacieSessionRequest;
import software.amazon.awssdk.services.macie2.model.UpdateMacieSessionResponse;
import software.amazon.awssdk.services.macie2.model.UpdateMemberSessionRequest;
import software.amazon.awssdk.services.macie2.model.UpdateMemberSessionResponse;
import software.amazon.awssdk.services.macie2.model.UpdateOrganizationConfigurationRequest;
import software.amazon.awssdk.services.macie2.model.UpdateOrganizationConfigurationResponse;
import software.amazon.awssdk.services.macie2.paginators.DescribeBucketsPublisher;
import software.amazon.awssdk.services.macie2.paginators.GetUsageStatisticsPublisher;
import software.amazon.awssdk.services.macie2.paginators.ListClassificationJobsPublisher;
import software.amazon.awssdk.services.macie2.paginators.ListCustomDataIdentifiersPublisher;
import software.amazon.awssdk.services.macie2.paginators.ListFindingsFiltersPublisher;
import software.amazon.awssdk.services.macie2.paginators.ListFindingsPublisher;
import software.amazon.awssdk.services.macie2.paginators.ListInvitationsPublisher;
import software.amazon.awssdk.services.macie2.paginators.ListMembersPublisher;
import software.amazon.awssdk.services.macie2.paginators.ListOrganizationAdminAccountsPublisher;
import software.amazon.awssdk.services.macie2.paginators.SearchResourcesPublisher;

/**
 * Service client for accessing Amazon Macie 2 asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * Amazon Macie is a fully managed data security and data privacy service that uses machine learning and pattern
 * matching to discover and protect your sensitive data in AWS. Macie automates the discovery of sensitive data, such as
 * PII and intellectual property, to provide you with insight into the data that your organization stores in AWS. Macie
 * also provides an inventory of your Amazon S3 buckets, which it continually monitors for you. If Macie detects
 * sensitive data or potential data access issues, it generates detailed findings for you to review and act upon as
 * necessary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface Macie2AsyncClient extends SdkClient {
    String SERVICE_NAME = "macie2";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "macie2";

    /**
     * Create a {@link Macie2AsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static Macie2AsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link Macie2AsyncClient}.
     */
    static Macie2AsyncClientBuilder builder() {
        return new DefaultMacie2AsyncClientBuilder();
    }

    /**
     * <p>
     * Accepts an Amazon Macie membership invitation that was received from a specific account.
     * </p>
     *
     * @param acceptInvitationRequest
     * @return A Java Future containing the result of the AcceptInvitation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.AcceptInvitation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/AcceptInvitation" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AcceptInvitationResponse> acceptInvitation(AcceptInvitationRequest acceptInvitationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Accepts an Amazon Macie membership invitation that was received from a specific account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AcceptInvitationRequest.Builder} avoiding the need
     * to create one manually via {@link AcceptInvitationRequest#builder()}
     * </p>
     *
     * @param acceptInvitationRequest
     *        A {@link Consumer} that will call methods on {@link AcceptInvitationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the AcceptInvitation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.AcceptInvitation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/AcceptInvitation" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AcceptInvitationResponse> acceptInvitation(
            Consumer<AcceptInvitationRequest.Builder> acceptInvitationRequest) {
        return acceptInvitation(AcceptInvitationRequest.builder().applyMutation(acceptInvitationRequest).build());
    }

    /**
     * <p>
     * Retrieves information about one or more custom data identifiers.
     * </p>
     *
     * @param batchGetCustomDataIdentifiersRequest
     * @return A Java Future containing the result of the BatchGetCustomDataIdentifiers operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.BatchGetCustomDataIdentifiers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/BatchGetCustomDataIdentifiers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetCustomDataIdentifiersResponse> batchGetCustomDataIdentifiers(
            BatchGetCustomDataIdentifiersRequest batchGetCustomDataIdentifiersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about one or more custom data identifiers.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetCustomDataIdentifiersRequest.Builder}
     * avoiding the need to create one manually via {@link BatchGetCustomDataIdentifiersRequest#builder()}
     * </p>
     *
     * @param batchGetCustomDataIdentifiersRequest
     *        A {@link Consumer} that will call methods on {@link BatchGetCustomDataIdentifiersRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the BatchGetCustomDataIdentifiers operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.BatchGetCustomDataIdentifiers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/BatchGetCustomDataIdentifiers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetCustomDataIdentifiersResponse> batchGetCustomDataIdentifiers(
            Consumer<BatchGetCustomDataIdentifiersRequest.Builder> batchGetCustomDataIdentifiersRequest) {
        return batchGetCustomDataIdentifiers(BatchGetCustomDataIdentifiersRequest.builder()
                .applyMutation(batchGetCustomDataIdentifiersRequest).build());
    }

    /**
     * <p>
     * Creates and defines the settings for a classification job.
     * </p>
     *
     * @param createClassificationJobRequest
     * @return A Java Future containing the result of the CreateClassificationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.CreateClassificationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/CreateClassificationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateClassificationJobResponse> createClassificationJob(
            CreateClassificationJobRequest createClassificationJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates and defines the settings for a classification job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateClassificationJobRequest.Builder} avoiding
     * the need to create one manually via {@link CreateClassificationJobRequest#builder()}
     * </p>
     *
     * @param createClassificationJobRequest
     *        A {@link Consumer} that will call methods on {@link CreateClassificationJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateClassificationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.CreateClassificationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/CreateClassificationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateClassificationJobResponse> createClassificationJob(
            Consumer<CreateClassificationJobRequest.Builder> createClassificationJobRequest) {
        return createClassificationJob(CreateClassificationJobRequest.builder().applyMutation(createClassificationJobRequest)
                .build());
    }

    /**
     * <p>
     * Creates and defines the criteria and other settings for a custom data identifier.
     * </p>
     *
     * @param createCustomDataIdentifierRequest
     * @return A Java Future containing the result of the CreateCustomDataIdentifier operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.CreateCustomDataIdentifier
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/CreateCustomDataIdentifier"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCustomDataIdentifierResponse> createCustomDataIdentifier(
            CreateCustomDataIdentifierRequest createCustomDataIdentifierRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates and defines the criteria and other settings for a custom data identifier.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCustomDataIdentifierRequest.Builder} avoiding
     * the need to create one manually via {@link CreateCustomDataIdentifierRequest#builder()}
     * </p>
     *
     * @param createCustomDataIdentifierRequest
     *        A {@link Consumer} that will call methods on {@link CreateCustomDataIdentifierRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateCustomDataIdentifier operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.CreateCustomDataIdentifier
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/CreateCustomDataIdentifier"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCustomDataIdentifierResponse> createCustomDataIdentifier(
            Consumer<CreateCustomDataIdentifierRequest.Builder> createCustomDataIdentifierRequest) {
        return createCustomDataIdentifier(CreateCustomDataIdentifierRequest.builder()
                .applyMutation(createCustomDataIdentifierRequest).build());
    }

    /**
     * <p>
     * Creates and defines the criteria and other settings for a findings filter.
     * </p>
     *
     * @param createFindingsFilterRequest
     * @return A Java Future containing the result of the CreateFindingsFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.CreateFindingsFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/CreateFindingsFilter" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateFindingsFilterResponse> createFindingsFilter(
            CreateFindingsFilterRequest createFindingsFilterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates and defines the criteria and other settings for a findings filter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFindingsFilterRequest.Builder} avoiding the
     * need to create one manually via {@link CreateFindingsFilterRequest#builder()}
     * </p>
     *
     * @param createFindingsFilterRequest
     *        A {@link Consumer} that will call methods on {@link CreateFindingsFilterRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateFindingsFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.CreateFindingsFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/CreateFindingsFilter" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateFindingsFilterResponse> createFindingsFilter(
            Consumer<CreateFindingsFilterRequest.Builder> createFindingsFilterRequest) {
        return createFindingsFilter(CreateFindingsFilterRequest.builder().applyMutation(createFindingsFilterRequest).build());
    }

    /**
     * <p>
     * Sends an Amazon Macie membership invitation to one or more accounts.
     * </p>
     *
     * @param createInvitationsRequest
     * @return A Java Future containing the result of the CreateInvitations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.CreateInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/CreateInvitations" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateInvitationsResponse> createInvitations(CreateInvitationsRequest createInvitationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sends an Amazon Macie membership invitation to one or more accounts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateInvitationsRequest.Builder} avoiding the need
     * to create one manually via {@link CreateInvitationsRequest#builder()}
     * </p>
     *
     * @param createInvitationsRequest
     *        A {@link Consumer} that will call methods on {@link CreateInvitationsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateInvitations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.CreateInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/CreateInvitations" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateInvitationsResponse> createInvitations(
            Consumer<CreateInvitationsRequest.Builder> createInvitationsRequest) {
        return createInvitations(CreateInvitationsRequest.builder().applyMutation(createInvitationsRequest).build());
    }

    /**
     * <p>
     * Associates an account with an Amazon Macie administrator account.
     * </p>
     *
     * @param createMemberRequest
     * @return A Java Future containing the result of the CreateMember operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.CreateMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/CreateMember" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateMemberResponse> createMember(CreateMemberRequest createMemberRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates an account with an Amazon Macie administrator account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMemberRequest.Builder} avoiding the need to
     * create one manually via {@link CreateMemberRequest#builder()}
     * </p>
     *
     * @param createMemberRequest
     *        A {@link Consumer} that will call methods on {@link CreateMemberRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateMember operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.CreateMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/CreateMember" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateMemberResponse> createMember(Consumer<CreateMemberRequest.Builder> createMemberRequest) {
        return createMember(CreateMemberRequest.builder().applyMutation(createMemberRequest).build());
    }

    /**
     * <p>
     * Creates sample findings.
     * </p>
     *
     * @param createSampleFindingsRequest
     * @return A Java Future containing the result of the CreateSampleFindings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.CreateSampleFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/CreateSampleFindings" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateSampleFindingsResponse> createSampleFindings(
            CreateSampleFindingsRequest createSampleFindingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates sample findings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSampleFindingsRequest.Builder} avoiding the
     * need to create one manually via {@link CreateSampleFindingsRequest#builder()}
     * </p>
     *
     * @param createSampleFindingsRequest
     *        A {@link Consumer} that will call methods on {@link CreateSampleFindingsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateSampleFindings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.CreateSampleFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/CreateSampleFindings" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateSampleFindingsResponse> createSampleFindings(
            Consumer<CreateSampleFindingsRequest.Builder> createSampleFindingsRequest) {
        return createSampleFindings(CreateSampleFindingsRequest.builder().applyMutation(createSampleFindingsRequest).build());
    }

    /**
     * <p>
     * Declines Amazon Macie membership invitations that were received from specific accounts.
     * </p>
     *
     * @param declineInvitationsRequest
     * @return A Java Future containing the result of the DeclineInvitations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.DeclineInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DeclineInvitations" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeclineInvitationsResponse> declineInvitations(DeclineInvitationsRequest declineInvitationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Declines Amazon Macie membership invitations that were received from specific accounts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeclineInvitationsRequest.Builder} avoiding the
     * need to create one manually via {@link DeclineInvitationsRequest#builder()}
     * </p>
     *
     * @param declineInvitationsRequest
     *        A {@link Consumer} that will call methods on {@link DeclineInvitationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeclineInvitations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.DeclineInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DeclineInvitations" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeclineInvitationsResponse> declineInvitations(
            Consumer<DeclineInvitationsRequest.Builder> declineInvitationsRequest) {
        return declineInvitations(DeclineInvitationsRequest.builder().applyMutation(declineInvitationsRequest).build());
    }

    /**
     * <p>
     * Soft deletes a custom data identifier.
     * </p>
     *
     * @param deleteCustomDataIdentifierRequest
     * @return A Java Future containing the result of the DeleteCustomDataIdentifier operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.DeleteCustomDataIdentifier
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DeleteCustomDataIdentifier"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCustomDataIdentifierResponse> deleteCustomDataIdentifier(
            DeleteCustomDataIdentifierRequest deleteCustomDataIdentifierRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Soft deletes a custom data identifier.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCustomDataIdentifierRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteCustomDataIdentifierRequest#builder()}
     * </p>
     *
     * @param deleteCustomDataIdentifierRequest
     *        A {@link Consumer} that will call methods on {@link DeleteCustomDataIdentifierRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteCustomDataIdentifier operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.DeleteCustomDataIdentifier
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DeleteCustomDataIdentifier"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCustomDataIdentifierResponse> deleteCustomDataIdentifier(
            Consumer<DeleteCustomDataIdentifierRequest.Builder> deleteCustomDataIdentifierRequest) {
        return deleteCustomDataIdentifier(DeleteCustomDataIdentifierRequest.builder()
                .applyMutation(deleteCustomDataIdentifierRequest).build());
    }

    /**
     * <p>
     * Deletes a findings filter.
     * </p>
     *
     * @param deleteFindingsFilterRequest
     * @return A Java Future containing the result of the DeleteFindingsFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.DeleteFindingsFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DeleteFindingsFilter" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteFindingsFilterResponse> deleteFindingsFilter(
            DeleteFindingsFilterRequest deleteFindingsFilterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a findings filter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFindingsFilterRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteFindingsFilterRequest#builder()}
     * </p>
     *
     * @param deleteFindingsFilterRequest
     *        A {@link Consumer} that will call methods on {@link DeleteFindingsFilterRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteFindingsFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.DeleteFindingsFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DeleteFindingsFilter" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteFindingsFilterResponse> deleteFindingsFilter(
            Consumer<DeleteFindingsFilterRequest.Builder> deleteFindingsFilterRequest) {
        return deleteFindingsFilter(DeleteFindingsFilterRequest.builder().applyMutation(deleteFindingsFilterRequest).build());
    }

    /**
     * <p>
     * Deletes Amazon Macie membership invitations that were received from specific accounts.
     * </p>
     *
     * @param deleteInvitationsRequest
     * @return A Java Future containing the result of the DeleteInvitations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.DeleteInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DeleteInvitations" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteInvitationsResponse> deleteInvitations(DeleteInvitationsRequest deleteInvitationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes Amazon Macie membership invitations that were received from specific accounts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInvitationsRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteInvitationsRequest#builder()}
     * </p>
     *
     * @param deleteInvitationsRequest
     *        A {@link Consumer} that will call methods on {@link DeleteInvitationsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteInvitations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.DeleteInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DeleteInvitations" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteInvitationsResponse> deleteInvitations(
            Consumer<DeleteInvitationsRequest.Builder> deleteInvitationsRequest) {
        return deleteInvitations(DeleteInvitationsRequest.builder().applyMutation(deleteInvitationsRequest).build());
    }

    /**
     * <p>
     * Deletes the association between an Amazon Macie administrator account and an account.
     * </p>
     *
     * @param deleteMemberRequest
     * @return A Java Future containing the result of the DeleteMember operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.DeleteMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DeleteMember" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteMemberResponse> deleteMember(DeleteMemberRequest deleteMemberRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the association between an Amazon Macie administrator account and an account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMemberRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteMemberRequest#builder()}
     * </p>
     *
     * @param deleteMemberRequest
     *        A {@link Consumer} that will call methods on {@link DeleteMemberRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteMember operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.DeleteMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DeleteMember" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteMemberResponse> deleteMember(Consumer<DeleteMemberRequest.Builder> deleteMemberRequest) {
        return deleteMember(DeleteMemberRequest.builder().applyMutation(deleteMemberRequest).build());
    }

    /**
     * <p>
     * Retrieves (queries) statistical data and other information about one or more S3 buckets that Amazon Macie
     * monitors and analyzes.
     * </p>
     *
     * @param describeBucketsRequest
     * @return A Java Future containing the result of the DescribeBuckets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.DescribeBuckets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DescribeBuckets" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeBucketsResponse> describeBuckets(DescribeBucketsRequest describeBucketsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves (queries) statistical data and other information about one or more S3 buckets that Amazon Macie
     * monitors and analyzes.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBucketsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeBucketsRequest#builder()}
     * </p>
     *
     * @param describeBucketsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeBucketsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeBuckets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.DescribeBuckets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DescribeBuckets" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeBucketsResponse> describeBuckets(
            Consumer<DescribeBucketsRequest.Builder> describeBucketsRequest) {
        return describeBuckets(DescribeBucketsRequest.builder().applyMutation(describeBucketsRequest).build());
    }

    /**
     * <p>
     * Retrieves (queries) statistical data and other information about one or more S3 buckets that Amazon Macie
     * monitors and analyzes.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeBuckets(software.amazon.awssdk.services.macie2.model.DescribeBucketsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.DescribeBucketsPublisher publisher = client.describeBucketsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.DescribeBucketsPublisher publisher = client.describeBucketsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.macie2.model.DescribeBucketsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.macie2.model.DescribeBucketsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeBuckets(software.amazon.awssdk.services.macie2.model.DescribeBucketsRequest)} operation.</b>
     * </p>
     *
     * @param describeBucketsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.DescribeBuckets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DescribeBuckets" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeBucketsPublisher describeBucketsPaginator(DescribeBucketsRequest describeBucketsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves (queries) statistical data and other information about one or more S3 buckets that Amazon Macie
     * monitors and analyzes.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeBuckets(software.amazon.awssdk.services.macie2.model.DescribeBucketsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.DescribeBucketsPublisher publisher = client.describeBucketsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.DescribeBucketsPublisher publisher = client.describeBucketsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.macie2.model.DescribeBucketsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.macie2.model.DescribeBucketsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeBuckets(software.amazon.awssdk.services.macie2.model.DescribeBucketsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBucketsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeBucketsRequest#builder()}
     * </p>
     *
     * @param describeBucketsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeBucketsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.DescribeBuckets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DescribeBuckets" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeBucketsPublisher describeBucketsPaginator(Consumer<DescribeBucketsRequest.Builder> describeBucketsRequest) {
        return describeBucketsPaginator(DescribeBucketsRequest.builder().applyMutation(describeBucketsRequest).build());
    }

    /**
     * <p>
     * Retrieves the status and settings for a classification job.
     * </p>
     *
     * @param describeClassificationJobRequest
     * @return A Java Future containing the result of the DescribeClassificationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.DescribeClassificationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DescribeClassificationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeClassificationJobResponse> describeClassificationJob(
            DescribeClassificationJobRequest describeClassificationJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the status and settings for a classification job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeClassificationJobRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeClassificationJobRequest#builder()}
     * </p>
     *
     * @param describeClassificationJobRequest
     *        A {@link Consumer} that will call methods on {@link DescribeClassificationJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeClassificationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.DescribeClassificationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DescribeClassificationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeClassificationJobResponse> describeClassificationJob(
            Consumer<DescribeClassificationJobRequest.Builder> describeClassificationJobRequest) {
        return describeClassificationJob(DescribeClassificationJobRequest.builder()
                .applyMutation(describeClassificationJobRequest).build());
    }

    /**
     * <p>
     * Retrieves the Amazon Macie configuration settings for an organization in Organizations.
     * </p>
     *
     * @param describeOrganizationConfigurationRequest
     * @return A Java Future containing the result of the DescribeOrganizationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.DescribeOrganizationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DescribeOrganizationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeOrganizationConfigurationResponse> describeOrganizationConfiguration(
            DescribeOrganizationConfigurationRequest describeOrganizationConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the Amazon Macie configuration settings for an organization in Organizations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOrganizationConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeOrganizationConfigurationRequest#builder()}
     * </p>
     *
     * @param describeOrganizationConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DescribeOrganizationConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeOrganizationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.DescribeOrganizationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DescribeOrganizationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeOrganizationConfigurationResponse> describeOrganizationConfiguration(
            Consumer<DescribeOrganizationConfigurationRequest.Builder> describeOrganizationConfigurationRequest) {
        return describeOrganizationConfiguration(DescribeOrganizationConfigurationRequest.builder()
                .applyMutation(describeOrganizationConfigurationRequest).build());
    }

    /**
     * <p>
     * Disables Amazon Macie and deletes all settings and resources for a Macie account.
     * </p>
     *
     * @param disableMacieRequest
     * @return A Java Future containing the result of the DisableMacie operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.DisableMacie
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DisableMacie" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DisableMacieResponse> disableMacie(DisableMacieRequest disableMacieRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables Amazon Macie and deletes all settings and resources for a Macie account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisableMacieRequest.Builder} avoiding the need to
     * create one manually via {@link DisableMacieRequest#builder()}
     * </p>
     *
     * @param disableMacieRequest
     *        A {@link Consumer} that will call methods on {@link DisableMacieRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DisableMacie operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.DisableMacie
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DisableMacie" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DisableMacieResponse> disableMacie(Consumer<DisableMacieRequest.Builder> disableMacieRequest) {
        return disableMacie(DisableMacieRequest.builder().applyMutation(disableMacieRequest).build());
    }

    /**
     * <p>
     * Disables an account as the delegated Amazon Macie administrator account for an organization in Organizations.
     * </p>
     *
     * @param disableOrganizationAdminAccountRequest
     * @return A Java Future containing the result of the DisableOrganizationAdminAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.DisableOrganizationAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DisableOrganizationAdminAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisableOrganizationAdminAccountResponse> disableOrganizationAdminAccount(
            DisableOrganizationAdminAccountRequest disableOrganizationAdminAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables an account as the delegated Amazon Macie administrator account for an organization in Organizations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisableOrganizationAdminAccountRequest.Builder}
     * avoiding the need to create one manually via {@link DisableOrganizationAdminAccountRequest#builder()}
     * </p>
     *
     * @param disableOrganizationAdminAccountRequest
     *        A {@link Consumer} that will call methods on {@link DisableOrganizationAdminAccountRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DisableOrganizationAdminAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.DisableOrganizationAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DisableOrganizationAdminAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisableOrganizationAdminAccountResponse> disableOrganizationAdminAccount(
            Consumer<DisableOrganizationAdminAccountRequest.Builder> disableOrganizationAdminAccountRequest) {
        return disableOrganizationAdminAccount(DisableOrganizationAdminAccountRequest.builder()
                .applyMutation(disableOrganizationAdminAccountRequest).build());
    }

    /**
     * <p>
     * Disassociates a member account from its Amazon Macie administrator account.
     * </p>
     *
     * @param disassociateFromAdministratorAccountRequest
     * @return A Java Future containing the result of the DisassociateFromAdministratorAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.DisassociateFromAdministratorAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DisassociateFromAdministratorAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateFromAdministratorAccountResponse> disassociateFromAdministratorAccount(
            DisassociateFromAdministratorAccountRequest disassociateFromAdministratorAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a member account from its Amazon Macie administrator account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DisassociateFromAdministratorAccountRequest.Builder} avoiding the need to create one manually via
     * {@link DisassociateFromAdministratorAccountRequest#builder()}
     * </p>
     *
     * @param disassociateFromAdministratorAccountRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateFromAdministratorAccountRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DisassociateFromAdministratorAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.DisassociateFromAdministratorAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DisassociateFromAdministratorAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateFromAdministratorAccountResponse> disassociateFromAdministratorAccount(
            Consumer<DisassociateFromAdministratorAccountRequest.Builder> disassociateFromAdministratorAccountRequest) {
        return disassociateFromAdministratorAccount(DisassociateFromAdministratorAccountRequest.builder()
                .applyMutation(disassociateFromAdministratorAccountRequest).build());
    }

    /**
     * <p>
     * (Deprecated) Disassociates a member account from its Amazon Macie administrator account. This operation has been
     * replaced by the <link linkend="DisassociateFromAdministratorAccount">DisassociateFromAdministratorAccount</link>
     * operation.
     * </p>
     *
     * @param disassociateFromMasterAccountRequest
     * @return A Java Future containing the result of the DisassociateFromMasterAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.DisassociateFromMasterAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DisassociateFromMasterAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateFromMasterAccountResponse> disassociateFromMasterAccount(
            DisassociateFromMasterAccountRequest disassociateFromMasterAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * (Deprecated) Disassociates a member account from its Amazon Macie administrator account. This operation has been
     * replaced by the <link linkend="DisassociateFromAdministratorAccount">DisassociateFromAdministratorAccount</link>
     * operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateFromMasterAccountRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateFromMasterAccountRequest#builder()}
     * </p>
     *
     * @param disassociateFromMasterAccountRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateFromMasterAccountRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DisassociateFromMasterAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.DisassociateFromMasterAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DisassociateFromMasterAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateFromMasterAccountResponse> disassociateFromMasterAccount(
            Consumer<DisassociateFromMasterAccountRequest.Builder> disassociateFromMasterAccountRequest) {
        return disassociateFromMasterAccount(DisassociateFromMasterAccountRequest.builder()
                .applyMutation(disassociateFromMasterAccountRequest).build());
    }

    /**
     * <p>
     * Disassociates an Amazon Macie administrator account from a member account.
     * </p>
     *
     * @param disassociateMemberRequest
     * @return A Java Future containing the result of the DisassociateMember operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.DisassociateMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DisassociateMember" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DisassociateMemberResponse> disassociateMember(DisassociateMemberRequest disassociateMemberRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates an Amazon Macie administrator account from a member account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateMemberRequest.Builder} avoiding the
     * need to create one manually via {@link DisassociateMemberRequest#builder()}
     * </p>
     *
     * @param disassociateMemberRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateMemberRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DisassociateMember operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.DisassociateMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DisassociateMember" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DisassociateMemberResponse> disassociateMember(
            Consumer<DisassociateMemberRequest.Builder> disassociateMemberRequest) {
        return disassociateMember(DisassociateMemberRequest.builder().applyMutation(disassociateMemberRequest).build());
    }

    /**
     * <p>
     * Enables Amazon Macie and specifies the configuration settings for a Macie account.
     * </p>
     *
     * @param enableMacieRequest
     * @return A Java Future containing the result of the EnableMacie operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.EnableMacie
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/EnableMacie" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<EnableMacieResponse> enableMacie(EnableMacieRequest enableMacieRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables Amazon Macie and specifies the configuration settings for a Macie account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EnableMacieRequest.Builder} avoiding the need to
     * create one manually via {@link EnableMacieRequest#builder()}
     * </p>
     *
     * @param enableMacieRequest
     *        A {@link Consumer} that will call methods on {@link EnableMacieRequest.Builder} to create a request.
     * @return A Java Future containing the result of the EnableMacie operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.EnableMacie
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/EnableMacie" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<EnableMacieResponse> enableMacie(Consumer<EnableMacieRequest.Builder> enableMacieRequest) {
        return enableMacie(EnableMacieRequest.builder().applyMutation(enableMacieRequest).build());
    }

    /**
     * <p>
     * Designates an account as the delegated Amazon Macie administrator account for an organization in Organizations.
     * </p>
     *
     * @param enableOrganizationAdminAccountRequest
     * @return A Java Future containing the result of the EnableOrganizationAdminAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.EnableOrganizationAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/EnableOrganizationAdminAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<EnableOrganizationAdminAccountResponse> enableOrganizationAdminAccount(
            EnableOrganizationAdminAccountRequest enableOrganizationAdminAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Designates an account as the delegated Amazon Macie administrator account for an organization in Organizations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EnableOrganizationAdminAccountRequest.Builder}
     * avoiding the need to create one manually via {@link EnableOrganizationAdminAccountRequest#builder()}
     * </p>
     *
     * @param enableOrganizationAdminAccountRequest
     *        A {@link Consumer} that will call methods on {@link EnableOrganizationAdminAccountRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the EnableOrganizationAdminAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.EnableOrganizationAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/EnableOrganizationAdminAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<EnableOrganizationAdminAccountResponse> enableOrganizationAdminAccount(
            Consumer<EnableOrganizationAdminAccountRequest.Builder> enableOrganizationAdminAccountRequest) {
        return enableOrganizationAdminAccount(EnableOrganizationAdminAccountRequest.builder()
                .applyMutation(enableOrganizationAdminAccountRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the Amazon Macie administrator account for an account.
     * </p>
     *
     * @param getAdministratorAccountRequest
     * @return A Java Future containing the result of the GetAdministratorAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.GetAdministratorAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetAdministratorAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAdministratorAccountResponse> getAdministratorAccount(
            GetAdministratorAccountRequest getAdministratorAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the Amazon Macie administrator account for an account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAdministratorAccountRequest.Builder} avoiding
     * the need to create one manually via {@link GetAdministratorAccountRequest#builder()}
     * </p>
     *
     * @param getAdministratorAccountRequest
     *        A {@link Consumer} that will call methods on {@link GetAdministratorAccountRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetAdministratorAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.GetAdministratorAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetAdministratorAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAdministratorAccountResponse> getAdministratorAccount(
            Consumer<GetAdministratorAccountRequest.Builder> getAdministratorAccountRequest) {
        return getAdministratorAccount(GetAdministratorAccountRequest.builder().applyMutation(getAdministratorAccountRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves (queries) aggregated statistical data about S3 buckets that Amazon Macie monitors and analyzes.
     * </p>
     *
     * @param getBucketStatisticsRequest
     * @return A Java Future containing the result of the GetBucketStatistics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.GetBucketStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetBucketStatistics" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetBucketStatisticsResponse> getBucketStatistics(
            GetBucketStatisticsRequest getBucketStatisticsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves (queries) aggregated statistical data about S3 buckets that Amazon Macie monitors and analyzes.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBucketStatisticsRequest.Builder} avoiding the
     * need to create one manually via {@link GetBucketStatisticsRequest#builder()}
     * </p>
     *
     * @param getBucketStatisticsRequest
     *        A {@link Consumer} that will call methods on {@link GetBucketStatisticsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetBucketStatistics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.GetBucketStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetBucketStatistics" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetBucketStatisticsResponse> getBucketStatistics(
            Consumer<GetBucketStatisticsRequest.Builder> getBucketStatisticsRequest) {
        return getBucketStatistics(GetBucketStatisticsRequest.builder().applyMutation(getBucketStatisticsRequest).build());
    }

    /**
     * <p>
     * Retrieves the configuration settings for storing data classification results.
     * </p>
     *
     * @param getClassificationExportConfigurationRequest
     * @return A Java Future containing the result of the GetClassificationExportConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.GetClassificationExportConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetClassificationExportConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetClassificationExportConfigurationResponse> getClassificationExportConfiguration(
            GetClassificationExportConfigurationRequest getClassificationExportConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the configuration settings for storing data classification results.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetClassificationExportConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link GetClassificationExportConfigurationRequest#builder()}
     * </p>
     *
     * @param getClassificationExportConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link GetClassificationExportConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetClassificationExportConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.GetClassificationExportConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetClassificationExportConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetClassificationExportConfigurationResponse> getClassificationExportConfiguration(
            Consumer<GetClassificationExportConfigurationRequest.Builder> getClassificationExportConfigurationRequest) {
        return getClassificationExportConfiguration(GetClassificationExportConfigurationRequest.builder()
                .applyMutation(getClassificationExportConfigurationRequest).build());
    }

    /**
     * <p>
     * Retrieves the criteria and other settings for a custom data identifier.
     * </p>
     *
     * @param getCustomDataIdentifierRequest
     * @return A Java Future containing the result of the GetCustomDataIdentifier operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.GetCustomDataIdentifier
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetCustomDataIdentifier"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCustomDataIdentifierResponse> getCustomDataIdentifier(
            GetCustomDataIdentifierRequest getCustomDataIdentifierRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the criteria and other settings for a custom data identifier.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCustomDataIdentifierRequest.Builder} avoiding
     * the need to create one manually via {@link GetCustomDataIdentifierRequest#builder()}
     * </p>
     *
     * @param getCustomDataIdentifierRequest
     *        A {@link Consumer} that will call methods on {@link GetCustomDataIdentifierRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetCustomDataIdentifier operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.GetCustomDataIdentifier
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetCustomDataIdentifier"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCustomDataIdentifierResponse> getCustomDataIdentifier(
            Consumer<GetCustomDataIdentifierRequest.Builder> getCustomDataIdentifierRequest) {
        return getCustomDataIdentifier(GetCustomDataIdentifierRequest.builder().applyMutation(getCustomDataIdentifierRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves (queries) aggregated statistical data about findings.
     * </p>
     *
     * @param getFindingStatisticsRequest
     * @return A Java Future containing the result of the GetFindingStatistics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.GetFindingStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetFindingStatistics" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetFindingStatisticsResponse> getFindingStatistics(
            GetFindingStatisticsRequest getFindingStatisticsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves (queries) aggregated statistical data about findings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFindingStatisticsRequest.Builder} avoiding the
     * need to create one manually via {@link GetFindingStatisticsRequest#builder()}
     * </p>
     *
     * @param getFindingStatisticsRequest
     *        A {@link Consumer} that will call methods on {@link GetFindingStatisticsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetFindingStatistics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.GetFindingStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetFindingStatistics" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetFindingStatisticsResponse> getFindingStatistics(
            Consumer<GetFindingStatisticsRequest.Builder> getFindingStatisticsRequest) {
        return getFindingStatistics(GetFindingStatisticsRequest.builder().applyMutation(getFindingStatisticsRequest).build());
    }

    /**
     * <p>
     * Retrieves the details of one or more findings.
     * </p>
     *
     * @param getFindingsRequest
     * @return A Java Future containing the result of the GetFindings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.GetFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetFindingsResponse> getFindings(GetFindingsRequest getFindingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the details of one or more findings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFindingsRequest.Builder} avoiding the need to
     * create one manually via {@link GetFindingsRequest#builder()}
     * </p>
     *
     * @param getFindingsRequest
     *        A {@link Consumer} that will call methods on {@link GetFindingsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetFindings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.GetFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetFindingsResponse> getFindings(Consumer<GetFindingsRequest.Builder> getFindingsRequest) {
        return getFindings(GetFindingsRequest.builder().applyMutation(getFindingsRequest).build());
    }

    /**
     * <p>
     * Retrieves the criteria and other settings for a findings filter.
     * </p>
     *
     * @param getFindingsFilterRequest
     * @return A Java Future containing the result of the GetFindingsFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.GetFindingsFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetFindingsFilter" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetFindingsFilterResponse> getFindingsFilter(GetFindingsFilterRequest getFindingsFilterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the criteria and other settings for a findings filter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFindingsFilterRequest.Builder} avoiding the need
     * to create one manually via {@link GetFindingsFilterRequest#builder()}
     * </p>
     *
     * @param getFindingsFilterRequest
     *        A {@link Consumer} that will call methods on {@link GetFindingsFilterRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetFindingsFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.GetFindingsFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetFindingsFilter" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetFindingsFilterResponse> getFindingsFilter(
            Consumer<GetFindingsFilterRequest.Builder> getFindingsFilterRequest) {
        return getFindingsFilter(GetFindingsFilterRequest.builder().applyMutation(getFindingsFilterRequest).build());
    }

    /**
     * <p>
     * Retrieves the configuration settings for publishing findings to Security Hub.
     * </p>
     *
     * @param getFindingsPublicationConfigurationRequest
     * @return A Java Future containing the result of the GetFindingsPublicationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.GetFindingsPublicationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetFindingsPublicationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetFindingsPublicationConfigurationResponse> getFindingsPublicationConfiguration(
            GetFindingsPublicationConfigurationRequest getFindingsPublicationConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the configuration settings for publishing findings to Security Hub.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFindingsPublicationConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link GetFindingsPublicationConfigurationRequest#builder()}
     * </p>
     *
     * @param getFindingsPublicationConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link GetFindingsPublicationConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetFindingsPublicationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.GetFindingsPublicationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetFindingsPublicationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetFindingsPublicationConfigurationResponse> getFindingsPublicationConfiguration(
            Consumer<GetFindingsPublicationConfigurationRequest.Builder> getFindingsPublicationConfigurationRequest) {
        return getFindingsPublicationConfiguration(GetFindingsPublicationConfigurationRequest.builder()
                .applyMutation(getFindingsPublicationConfigurationRequest).build());
    }

    /**
     * <p>
     * Retrieves the count of Amazon Macie membership invitations that were received by an account.
     * </p>
     *
     * @param getInvitationsCountRequest
     * @return A Java Future containing the result of the GetInvitationsCount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.GetInvitationsCount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetInvitationsCount" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetInvitationsCountResponse> getInvitationsCount(
            GetInvitationsCountRequest getInvitationsCountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the count of Amazon Macie membership invitations that were received by an account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInvitationsCountRequest.Builder} avoiding the
     * need to create one manually via {@link GetInvitationsCountRequest#builder()}
     * </p>
     *
     * @param getInvitationsCountRequest
     *        A {@link Consumer} that will call methods on {@link GetInvitationsCountRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetInvitationsCount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.GetInvitationsCount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetInvitationsCount" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetInvitationsCountResponse> getInvitationsCount(
            Consumer<GetInvitationsCountRequest.Builder> getInvitationsCountRequest) {
        return getInvitationsCount(GetInvitationsCountRequest.builder().applyMutation(getInvitationsCountRequest).build());
    }

    /**
     * <p>
     * Retrieves the current status and configuration settings for an Amazon Macie account.
     * </p>
     *
     * @param getMacieSessionRequest
     * @return A Java Future containing the result of the GetMacieSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.GetMacieSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetMacieSession" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetMacieSessionResponse> getMacieSession(GetMacieSessionRequest getMacieSessionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the current status and configuration settings for an Amazon Macie account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMacieSessionRequest.Builder} avoiding the need
     * to create one manually via {@link GetMacieSessionRequest#builder()}
     * </p>
     *
     * @param getMacieSessionRequest
     *        A {@link Consumer} that will call methods on {@link GetMacieSessionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetMacieSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.GetMacieSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetMacieSession" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetMacieSessionResponse> getMacieSession(
            Consumer<GetMacieSessionRequest.Builder> getMacieSessionRequest) {
        return getMacieSession(GetMacieSessionRequest.builder().applyMutation(getMacieSessionRequest).build());
    }

    /**
     * <p>
     * (Deprecated) Retrieves information about the Amazon Macie administrator account for an account. This operation
     * has been replaced by the <link linkend="GetAdministratorAccount">GetAdministratorAccount</link> operation.
     * </p>
     *
     * @param getMasterAccountRequest
     * @return A Java Future containing the result of the GetMasterAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.GetMasterAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetMasterAccount" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetMasterAccountResponse> getMasterAccount(GetMasterAccountRequest getMasterAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * (Deprecated) Retrieves information about the Amazon Macie administrator account for an account. This operation
     * has been replaced by the <link linkend="GetAdministratorAccount">GetAdministratorAccount</link> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMasterAccountRequest.Builder} avoiding the need
     * to create one manually via {@link GetMasterAccountRequest#builder()}
     * </p>
     *
     * @param getMasterAccountRequest
     *        A {@link Consumer} that will call methods on {@link GetMasterAccountRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetMasterAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.GetMasterAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetMasterAccount" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetMasterAccountResponse> getMasterAccount(
            Consumer<GetMasterAccountRequest.Builder> getMasterAccountRequest) {
        return getMasterAccount(GetMasterAccountRequest.builder().applyMutation(getMasterAccountRequest).build());
    }

    /**
     * <p>
     * Retrieves information about an account that's associated with an Amazon Macie administrator account.
     * </p>
     *
     * @param getMemberRequest
     * @return A Java Future containing the result of the GetMember operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.GetMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetMember" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetMemberResponse> getMember(GetMemberRequest getMemberRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about an account that's associated with an Amazon Macie administrator account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMemberRequest.Builder} avoiding the need to
     * create one manually via {@link GetMemberRequest#builder()}
     * </p>
     *
     * @param getMemberRequest
     *        A {@link Consumer} that will call methods on {@link GetMemberRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetMember operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.GetMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetMember" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetMemberResponse> getMember(Consumer<GetMemberRequest.Builder> getMemberRequest) {
        return getMember(GetMemberRequest.builder().applyMutation(getMemberRequest).build());
    }

    /**
     * <p>
     * Retrieves (queries) quotas and aggregated usage data for one or more accounts.
     * </p>
     *
     * @param getUsageStatisticsRequest
     * @return A Java Future containing the result of the GetUsageStatistics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.GetUsageStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetUsageStatistics" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetUsageStatisticsResponse> getUsageStatistics(GetUsageStatisticsRequest getUsageStatisticsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves (queries) quotas and aggregated usage data for one or more accounts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUsageStatisticsRequest.Builder} avoiding the
     * need to create one manually via {@link GetUsageStatisticsRequest#builder()}
     * </p>
     *
     * @param getUsageStatisticsRequest
     *        A {@link Consumer} that will call methods on {@link GetUsageStatisticsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetUsageStatistics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.GetUsageStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetUsageStatistics" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetUsageStatisticsResponse> getUsageStatistics(
            Consumer<GetUsageStatisticsRequest.Builder> getUsageStatisticsRequest) {
        return getUsageStatistics(GetUsageStatisticsRequest.builder().applyMutation(getUsageStatisticsRequest).build());
    }

    /**
     * <p>
     * Retrieves (queries) quotas and aggregated usage data for one or more accounts.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getUsageStatistics(software.amazon.awssdk.services.macie2.model.GetUsageStatisticsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.GetUsageStatisticsPublisher publisher = client.getUsageStatisticsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.GetUsageStatisticsPublisher publisher = client.getUsageStatisticsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.macie2.model.GetUsageStatisticsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.macie2.model.GetUsageStatisticsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getUsageStatistics(software.amazon.awssdk.services.macie2.model.GetUsageStatisticsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getUsageStatisticsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.GetUsageStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetUsageStatistics" target="_top">AWS API
     *      Documentation</a>
     */
    default GetUsageStatisticsPublisher getUsageStatisticsPaginator(GetUsageStatisticsRequest getUsageStatisticsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves (queries) quotas and aggregated usage data for one or more accounts.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getUsageStatistics(software.amazon.awssdk.services.macie2.model.GetUsageStatisticsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.GetUsageStatisticsPublisher publisher = client.getUsageStatisticsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.GetUsageStatisticsPublisher publisher = client.getUsageStatisticsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.macie2.model.GetUsageStatisticsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.macie2.model.GetUsageStatisticsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getUsageStatistics(software.amazon.awssdk.services.macie2.model.GetUsageStatisticsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUsageStatisticsRequest.Builder} avoiding the
     * need to create one manually via {@link GetUsageStatisticsRequest#builder()}
     * </p>
     *
     * @param getUsageStatisticsRequest
     *        A {@link Consumer} that will call methods on {@link GetUsageStatisticsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.GetUsageStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetUsageStatistics" target="_top">AWS API
     *      Documentation</a>
     */
    default GetUsageStatisticsPublisher getUsageStatisticsPaginator(
            Consumer<GetUsageStatisticsRequest.Builder> getUsageStatisticsRequest) {
        return getUsageStatisticsPaginator(GetUsageStatisticsRequest.builder().applyMutation(getUsageStatisticsRequest).build());
    }

    /**
     * <p>
     * Retrieves (queries) aggregated usage data for an account.
     * </p>
     *
     * @param getUsageTotalsRequest
     * @return A Java Future containing the result of the GetUsageTotals operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.GetUsageTotals
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetUsageTotals" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetUsageTotalsResponse> getUsageTotals(GetUsageTotalsRequest getUsageTotalsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves (queries) aggregated usage data for an account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUsageTotalsRequest.Builder} avoiding the need to
     * create one manually via {@link GetUsageTotalsRequest#builder()}
     * </p>
     *
     * @param getUsageTotalsRequest
     *        A {@link Consumer} that will call methods on {@link GetUsageTotalsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetUsageTotals operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.GetUsageTotals
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetUsageTotals" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetUsageTotalsResponse> getUsageTotals(Consumer<GetUsageTotalsRequest.Builder> getUsageTotalsRequest) {
        return getUsageTotals(GetUsageTotalsRequest.builder().applyMutation(getUsageTotalsRequest).build());
    }

    /**
     * <p>
     * Retrieves a subset of information about one or more classification jobs.
     * </p>
     *
     * @param listClassificationJobsRequest
     * @return A Java Future containing the result of the ListClassificationJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.ListClassificationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListClassificationJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListClassificationJobsResponse> listClassificationJobs(
            ListClassificationJobsRequest listClassificationJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a subset of information about one or more classification jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListClassificationJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListClassificationJobsRequest#builder()}
     * </p>
     *
     * @param listClassificationJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListClassificationJobsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListClassificationJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.ListClassificationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListClassificationJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListClassificationJobsResponse> listClassificationJobs(
            Consumer<ListClassificationJobsRequest.Builder> listClassificationJobsRequest) {
        return listClassificationJobs(ListClassificationJobsRequest.builder().applyMutation(listClassificationJobsRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a subset of information about one or more classification jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listClassificationJobs(software.amazon.awssdk.services.macie2.model.ListClassificationJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.ListClassificationJobsPublisher publisher = client.listClassificationJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.ListClassificationJobsPublisher publisher = client.listClassificationJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.macie2.model.ListClassificationJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.macie2.model.ListClassificationJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listClassificationJobs(software.amazon.awssdk.services.macie2.model.ListClassificationJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listClassificationJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.ListClassificationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListClassificationJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListClassificationJobsPublisher listClassificationJobsPaginator(
            ListClassificationJobsRequest listClassificationJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a subset of information about one or more classification jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listClassificationJobs(software.amazon.awssdk.services.macie2.model.ListClassificationJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.ListClassificationJobsPublisher publisher = client.listClassificationJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.ListClassificationJobsPublisher publisher = client.listClassificationJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.macie2.model.ListClassificationJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.macie2.model.ListClassificationJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listClassificationJobs(software.amazon.awssdk.services.macie2.model.ListClassificationJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListClassificationJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListClassificationJobsRequest#builder()}
     * </p>
     *
     * @param listClassificationJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListClassificationJobsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.ListClassificationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListClassificationJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListClassificationJobsPublisher listClassificationJobsPaginator(
            Consumer<ListClassificationJobsRequest.Builder> listClassificationJobsRequest) {
        return listClassificationJobsPaginator(ListClassificationJobsRequest.builder()
                .applyMutation(listClassificationJobsRequest).build());
    }

    /**
     * <p>
     * Retrieves a subset of information about all the custom data identifiers for an account.
     * </p>
     *
     * @param listCustomDataIdentifiersRequest
     * @return A Java Future containing the result of the ListCustomDataIdentifiers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.ListCustomDataIdentifiers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListCustomDataIdentifiers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCustomDataIdentifiersResponse> listCustomDataIdentifiers(
            ListCustomDataIdentifiersRequest listCustomDataIdentifiersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a subset of information about all the custom data identifiers for an account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCustomDataIdentifiersRequest.Builder} avoiding
     * the need to create one manually via {@link ListCustomDataIdentifiersRequest#builder()}
     * </p>
     *
     * @param listCustomDataIdentifiersRequest
     *        A {@link Consumer} that will call methods on {@link ListCustomDataIdentifiersRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListCustomDataIdentifiers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.ListCustomDataIdentifiers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListCustomDataIdentifiers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCustomDataIdentifiersResponse> listCustomDataIdentifiers(
            Consumer<ListCustomDataIdentifiersRequest.Builder> listCustomDataIdentifiersRequest) {
        return listCustomDataIdentifiers(ListCustomDataIdentifiersRequest.builder()
                .applyMutation(listCustomDataIdentifiersRequest).build());
    }

    /**
     * <p>
     * Retrieves a subset of information about all the custom data identifiers for an account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCustomDataIdentifiers(software.amazon.awssdk.services.macie2.model.ListCustomDataIdentifiersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.ListCustomDataIdentifiersPublisher publisher = client.listCustomDataIdentifiersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.ListCustomDataIdentifiersPublisher publisher = client.listCustomDataIdentifiersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.macie2.model.ListCustomDataIdentifiersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.macie2.model.ListCustomDataIdentifiersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCustomDataIdentifiers(software.amazon.awssdk.services.macie2.model.ListCustomDataIdentifiersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCustomDataIdentifiersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.ListCustomDataIdentifiers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListCustomDataIdentifiers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomDataIdentifiersPublisher listCustomDataIdentifiersPaginator(
            ListCustomDataIdentifiersRequest listCustomDataIdentifiersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a subset of information about all the custom data identifiers for an account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCustomDataIdentifiers(software.amazon.awssdk.services.macie2.model.ListCustomDataIdentifiersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.ListCustomDataIdentifiersPublisher publisher = client.listCustomDataIdentifiersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.ListCustomDataIdentifiersPublisher publisher = client.listCustomDataIdentifiersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.macie2.model.ListCustomDataIdentifiersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.macie2.model.ListCustomDataIdentifiersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCustomDataIdentifiers(software.amazon.awssdk.services.macie2.model.ListCustomDataIdentifiersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCustomDataIdentifiersRequest.Builder} avoiding
     * the need to create one manually via {@link ListCustomDataIdentifiersRequest#builder()}
     * </p>
     *
     * @param listCustomDataIdentifiersRequest
     *        A {@link Consumer} that will call methods on {@link ListCustomDataIdentifiersRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.ListCustomDataIdentifiers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListCustomDataIdentifiers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomDataIdentifiersPublisher listCustomDataIdentifiersPaginator(
            Consumer<ListCustomDataIdentifiersRequest.Builder> listCustomDataIdentifiersRequest) {
        return listCustomDataIdentifiersPaginator(ListCustomDataIdentifiersRequest.builder()
                .applyMutation(listCustomDataIdentifiersRequest).build());
    }

    /**
     * <p>
     * Retrieves a subset of information about one or more findings.
     * </p>
     *
     * @param listFindingsRequest
     * @return A Java Future containing the result of the ListFindings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.ListFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListFindingsResponse> listFindings(ListFindingsRequest listFindingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a subset of information about one or more findings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFindingsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFindingsRequest#builder()}
     * </p>
     *
     * @param listFindingsRequest
     *        A {@link Consumer} that will call methods on {@link ListFindingsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListFindings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.ListFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListFindingsResponse> listFindings(Consumer<ListFindingsRequest.Builder> listFindingsRequest) {
        return listFindings(ListFindingsRequest.builder().applyMutation(listFindingsRequest).build());
    }

    /**
     * <p>
     * Retrieves a subset of information about all the findings filters for an account.
     * </p>
     *
     * @param listFindingsFiltersRequest
     * @return A Java Future containing the result of the ListFindingsFilters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.ListFindingsFilters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListFindingsFilters" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListFindingsFiltersResponse> listFindingsFilters(
            ListFindingsFiltersRequest listFindingsFiltersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a subset of information about all the findings filters for an account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFindingsFiltersRequest.Builder} avoiding the
     * need to create one manually via {@link ListFindingsFiltersRequest#builder()}
     * </p>
     *
     * @param listFindingsFiltersRequest
     *        A {@link Consumer} that will call methods on {@link ListFindingsFiltersRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListFindingsFilters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.ListFindingsFilters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListFindingsFilters" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListFindingsFiltersResponse> listFindingsFilters(
            Consumer<ListFindingsFiltersRequest.Builder> listFindingsFiltersRequest) {
        return listFindingsFilters(ListFindingsFiltersRequest.builder().applyMutation(listFindingsFiltersRequest).build());
    }

    /**
     * <p>
     * Retrieves a subset of information about all the findings filters for an account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFindingsFilters(software.amazon.awssdk.services.macie2.model.ListFindingsFiltersRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.ListFindingsFiltersPublisher publisher = client.listFindingsFiltersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.ListFindingsFiltersPublisher publisher = client.listFindingsFiltersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.macie2.model.ListFindingsFiltersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.macie2.model.ListFindingsFiltersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFindingsFilters(software.amazon.awssdk.services.macie2.model.ListFindingsFiltersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listFindingsFiltersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.ListFindingsFilters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListFindingsFilters" target="_top">AWS
     *      API Documentation</a>
     */
    default ListFindingsFiltersPublisher listFindingsFiltersPaginator(ListFindingsFiltersRequest listFindingsFiltersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a subset of information about all the findings filters for an account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFindingsFilters(software.amazon.awssdk.services.macie2.model.ListFindingsFiltersRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.ListFindingsFiltersPublisher publisher = client.listFindingsFiltersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.ListFindingsFiltersPublisher publisher = client.listFindingsFiltersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.macie2.model.ListFindingsFiltersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.macie2.model.ListFindingsFiltersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFindingsFilters(software.amazon.awssdk.services.macie2.model.ListFindingsFiltersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFindingsFiltersRequest.Builder} avoiding the
     * need to create one manually via {@link ListFindingsFiltersRequest#builder()}
     * </p>
     *
     * @param listFindingsFiltersRequest
     *        A {@link Consumer} that will call methods on {@link ListFindingsFiltersRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.ListFindingsFilters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListFindingsFilters" target="_top">AWS
     *      API Documentation</a>
     */
    default ListFindingsFiltersPublisher listFindingsFiltersPaginator(
            Consumer<ListFindingsFiltersRequest.Builder> listFindingsFiltersRequest) {
        return listFindingsFiltersPaginator(ListFindingsFiltersRequest.builder().applyMutation(listFindingsFiltersRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a subset of information about one or more findings.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listFindings(software.amazon.awssdk.services.macie2.model.ListFindingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.ListFindingsPublisher publisher = client.listFindingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.ListFindingsPublisher publisher = client.listFindingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.macie2.model.ListFindingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.macie2.model.ListFindingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFindings(software.amazon.awssdk.services.macie2.model.ListFindingsRequest)} operation.</b>
     * </p>
     *
     * @param listFindingsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.ListFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFindingsPublisher listFindingsPaginator(ListFindingsRequest listFindingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a subset of information about one or more findings.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listFindings(software.amazon.awssdk.services.macie2.model.ListFindingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.ListFindingsPublisher publisher = client.listFindingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.ListFindingsPublisher publisher = client.listFindingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.macie2.model.ListFindingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.macie2.model.ListFindingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFindings(software.amazon.awssdk.services.macie2.model.ListFindingsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFindingsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFindingsRequest#builder()}
     * </p>
     *
     * @param listFindingsRequest
     *        A {@link Consumer} that will call methods on {@link ListFindingsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.ListFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFindingsPublisher listFindingsPaginator(Consumer<ListFindingsRequest.Builder> listFindingsRequest) {
        return listFindingsPaginator(ListFindingsRequest.builder().applyMutation(listFindingsRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the Amazon Macie membership invitations that were received by an account.
     * </p>
     *
     * @param listInvitationsRequest
     * @return A Java Future containing the result of the ListInvitations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.ListInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListInvitations" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListInvitationsResponse> listInvitations(ListInvitationsRequest listInvitationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the Amazon Macie membership invitations that were received by an account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInvitationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListInvitationsRequest#builder()}
     * </p>
     *
     * @param listInvitationsRequest
     *        A {@link Consumer} that will call methods on {@link ListInvitationsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListInvitations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.ListInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListInvitations" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListInvitationsResponse> listInvitations(
            Consumer<ListInvitationsRequest.Builder> listInvitationsRequest) {
        return listInvitations(ListInvitationsRequest.builder().applyMutation(listInvitationsRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the Amazon Macie membership invitations that were received by an account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listInvitations(software.amazon.awssdk.services.macie2.model.ListInvitationsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.ListInvitationsPublisher publisher = client.listInvitationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.ListInvitationsPublisher publisher = client.listInvitationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.macie2.model.ListInvitationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.macie2.model.ListInvitationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInvitations(software.amazon.awssdk.services.macie2.model.ListInvitationsRequest)} operation.</b>
     * </p>
     *
     * @param listInvitationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.ListInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListInvitations" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInvitationsPublisher listInvitationsPaginator(ListInvitationsRequest listInvitationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the Amazon Macie membership invitations that were received by an account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listInvitations(software.amazon.awssdk.services.macie2.model.ListInvitationsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.ListInvitationsPublisher publisher = client.listInvitationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.ListInvitationsPublisher publisher = client.listInvitationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.macie2.model.ListInvitationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.macie2.model.ListInvitationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInvitations(software.amazon.awssdk.services.macie2.model.ListInvitationsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInvitationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListInvitationsRequest#builder()}
     * </p>
     *
     * @param listInvitationsRequest
     *        A {@link Consumer} that will call methods on {@link ListInvitationsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.ListInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListInvitations" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInvitationsPublisher listInvitationsPaginator(Consumer<ListInvitationsRequest.Builder> listInvitationsRequest) {
        return listInvitationsPaginator(ListInvitationsRequest.builder().applyMutation(listInvitationsRequest).build());
    }

    /**
     * <p>
     * Retrieves information about all the managed data identifiers that Amazon Macie currently provides.
     * </p>
     *
     * @param listManagedDataIdentifiersRequest
     * @return A Java Future containing the result of the ListManagedDataIdentifiers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.ListManagedDataIdentifiers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListManagedDataIdentifiers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListManagedDataIdentifiersResponse> listManagedDataIdentifiers(
            ListManagedDataIdentifiersRequest listManagedDataIdentifiersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about all the managed data identifiers that Amazon Macie currently provides.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListManagedDataIdentifiersRequest.Builder} avoiding
     * the need to create one manually via {@link ListManagedDataIdentifiersRequest#builder()}
     * </p>
     *
     * @param listManagedDataIdentifiersRequest
     *        A {@link Consumer} that will call methods on {@link ListManagedDataIdentifiersRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListManagedDataIdentifiers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.ListManagedDataIdentifiers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListManagedDataIdentifiers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListManagedDataIdentifiersResponse> listManagedDataIdentifiers(
            Consumer<ListManagedDataIdentifiersRequest.Builder> listManagedDataIdentifiersRequest) {
        return listManagedDataIdentifiers(ListManagedDataIdentifiersRequest.builder()
                .applyMutation(listManagedDataIdentifiersRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the accounts that are associated with an Amazon Macie administrator account.
     * </p>
     *
     * @param listMembersRequest
     * @return A Java Future containing the result of the ListMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.ListMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListMembersResponse> listMembers(ListMembersRequest listMembersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the accounts that are associated with an Amazon Macie administrator account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMembersRequest.Builder} avoiding the need to
     * create one manually via {@link ListMembersRequest#builder()}
     * </p>
     *
     * @param listMembersRequest
     *        A {@link Consumer} that will call methods on {@link ListMembersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.ListMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListMembersResponse> listMembers(Consumer<ListMembersRequest.Builder> listMembersRequest) {
        return listMembers(ListMembersRequest.builder().applyMutation(listMembersRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the accounts that are associated with an Amazon Macie administrator account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listMembers(software.amazon.awssdk.services.macie2.model.ListMembersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.ListMembersPublisher publisher = client.listMembersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.ListMembersPublisher publisher = client.listMembersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.macie2.model.ListMembersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.macie2.model.ListMembersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMembers(software.amazon.awssdk.services.macie2.model.ListMembersRequest)} operation.</b>
     * </p>
     *
     * @param listMembersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.ListMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMembersPublisher listMembersPaginator(ListMembersRequest listMembersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the accounts that are associated with an Amazon Macie administrator account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listMembers(software.amazon.awssdk.services.macie2.model.ListMembersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.ListMembersPublisher publisher = client.listMembersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.ListMembersPublisher publisher = client.listMembersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.macie2.model.ListMembersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.macie2.model.ListMembersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMembers(software.amazon.awssdk.services.macie2.model.ListMembersRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMembersRequest.Builder} avoiding the need to
     * create one manually via {@link ListMembersRequest#builder()}
     * </p>
     *
     * @param listMembersRequest
     *        A {@link Consumer} that will call methods on {@link ListMembersRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.ListMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMembersPublisher listMembersPaginator(Consumer<ListMembersRequest.Builder> listMembersRequest) {
        return listMembersPaginator(ListMembersRequest.builder().applyMutation(listMembersRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the delegated Amazon Macie administrator account for an organization in
     * Organizations.
     * </p>
     *
     * @param listOrganizationAdminAccountsRequest
     * @return A Java Future containing the result of the ListOrganizationAdminAccounts operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.ListOrganizationAdminAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListOrganizationAdminAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListOrganizationAdminAccountsResponse> listOrganizationAdminAccounts(
            ListOrganizationAdminAccountsRequest listOrganizationAdminAccountsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the delegated Amazon Macie administrator account for an organization in
     * Organizations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOrganizationAdminAccountsRequest.Builder}
     * avoiding the need to create one manually via {@link ListOrganizationAdminAccountsRequest#builder()}
     * </p>
     *
     * @param listOrganizationAdminAccountsRequest
     *        A {@link Consumer} that will call methods on {@link ListOrganizationAdminAccountsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListOrganizationAdminAccounts operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.ListOrganizationAdminAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListOrganizationAdminAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListOrganizationAdminAccountsResponse> listOrganizationAdminAccounts(
            Consumer<ListOrganizationAdminAccountsRequest.Builder> listOrganizationAdminAccountsRequest) {
        return listOrganizationAdminAccounts(ListOrganizationAdminAccountsRequest.builder()
                .applyMutation(listOrganizationAdminAccountsRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the delegated Amazon Macie administrator account for an organization in
     * Organizations.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listOrganizationAdminAccounts(software.amazon.awssdk.services.macie2.model.ListOrganizationAdminAccountsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.ListOrganizationAdminAccountsPublisher publisher = client.listOrganizationAdminAccountsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.ListOrganizationAdminAccountsPublisher publisher = client.listOrganizationAdminAccountsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.macie2.model.ListOrganizationAdminAccountsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.macie2.model.ListOrganizationAdminAccountsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOrganizationAdminAccounts(software.amazon.awssdk.services.macie2.model.ListOrganizationAdminAccountsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listOrganizationAdminAccountsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.ListOrganizationAdminAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListOrganizationAdminAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOrganizationAdminAccountsPublisher listOrganizationAdminAccountsPaginator(
            ListOrganizationAdminAccountsRequest listOrganizationAdminAccountsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the delegated Amazon Macie administrator account for an organization in
     * Organizations.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listOrganizationAdminAccounts(software.amazon.awssdk.services.macie2.model.ListOrganizationAdminAccountsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.ListOrganizationAdminAccountsPublisher publisher = client.listOrganizationAdminAccountsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.ListOrganizationAdminAccountsPublisher publisher = client.listOrganizationAdminAccountsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.macie2.model.ListOrganizationAdminAccountsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.macie2.model.ListOrganizationAdminAccountsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOrganizationAdminAccounts(software.amazon.awssdk.services.macie2.model.ListOrganizationAdminAccountsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOrganizationAdminAccountsRequest.Builder}
     * avoiding the need to create one manually via {@link ListOrganizationAdminAccountsRequest#builder()}
     * </p>
     *
     * @param listOrganizationAdminAccountsRequest
     *        A {@link Consumer} that will call methods on {@link ListOrganizationAdminAccountsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.ListOrganizationAdminAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListOrganizationAdminAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOrganizationAdminAccountsPublisher listOrganizationAdminAccountsPaginator(
            Consumer<ListOrganizationAdminAccountsRequest.Builder> listOrganizationAdminAccountsRequest) {
        return listOrganizationAdminAccountsPaginator(ListOrganizationAdminAccountsRequest.builder()
                .applyMutation(listOrganizationAdminAccountsRequest).build());
    }

    /**
     * <p>
     * Retrieves the tags (keys and values) that are associated with a classification job, custom data identifier,
     * findings filter, or member account.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the tags (keys and values) that are associated with a classification job, custom data identifier,
     * findings filter, or member account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Creates or updates the configuration settings for storing data classification results.
     * </p>
     *
     * @param putClassificationExportConfigurationRequest
     * @return A Java Future containing the result of the PutClassificationExportConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.PutClassificationExportConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/PutClassificationExportConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutClassificationExportConfigurationResponse> putClassificationExportConfiguration(
            PutClassificationExportConfigurationRequest putClassificationExportConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates the configuration settings for storing data classification results.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link PutClassificationExportConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link PutClassificationExportConfigurationRequest#builder()}
     * </p>
     *
     * @param putClassificationExportConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link PutClassificationExportConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the PutClassificationExportConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.PutClassificationExportConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/PutClassificationExportConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutClassificationExportConfigurationResponse> putClassificationExportConfiguration(
            Consumer<PutClassificationExportConfigurationRequest.Builder> putClassificationExportConfigurationRequest) {
        return putClassificationExportConfiguration(PutClassificationExportConfigurationRequest.builder()
                .applyMutation(putClassificationExportConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates the configuration settings for publishing findings to Security Hub.
     * </p>
     *
     * @param putFindingsPublicationConfigurationRequest
     * @return A Java Future containing the result of the PutFindingsPublicationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.PutFindingsPublicationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/PutFindingsPublicationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutFindingsPublicationConfigurationResponse> putFindingsPublicationConfiguration(
            PutFindingsPublicationConfigurationRequest putFindingsPublicationConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration settings for publishing findings to Security Hub.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutFindingsPublicationConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link PutFindingsPublicationConfigurationRequest#builder()}
     * </p>
     *
     * @param putFindingsPublicationConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link PutFindingsPublicationConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the PutFindingsPublicationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.PutFindingsPublicationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/PutFindingsPublicationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutFindingsPublicationConfigurationResponse> putFindingsPublicationConfiguration(
            Consumer<PutFindingsPublicationConfigurationRequest.Builder> putFindingsPublicationConfigurationRequest) {
        return putFindingsPublicationConfiguration(PutFindingsPublicationConfigurationRequest.builder()
                .applyMutation(putFindingsPublicationConfigurationRequest).build());
    }

    /**
     * <p>
     * Retrieves (queries) statistical data and other information about Amazon Web Services resources that Amazon Macie
     * monitors and analyzes.
     * </p>
     *
     * @param searchResourcesRequest
     * @return A Java Future containing the result of the SearchResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.SearchResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/SearchResources" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SearchResourcesResponse> searchResources(SearchResourcesRequest searchResourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves (queries) statistical data and other information about Amazon Web Services resources that Amazon Macie
     * monitors and analyzes.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchResourcesRequest.Builder} avoiding the need
     * to create one manually via {@link SearchResourcesRequest#builder()}
     * </p>
     *
     * @param searchResourcesRequest
     *        A {@link Consumer} that will call methods on {@link SearchResourcesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the SearchResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.SearchResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/SearchResources" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SearchResourcesResponse> searchResources(
            Consumer<SearchResourcesRequest.Builder> searchResourcesRequest) {
        return searchResources(SearchResourcesRequest.builder().applyMutation(searchResourcesRequest).build());
    }

    /**
     * <p>
     * Retrieves (queries) statistical data and other information about Amazon Web Services resources that Amazon Macie
     * monitors and analyzes.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchResources(software.amazon.awssdk.services.macie2.model.SearchResourcesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.SearchResourcesPublisher publisher = client.searchResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.SearchResourcesPublisher publisher = client.searchResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.macie2.model.SearchResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.macie2.model.SearchResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchResources(software.amazon.awssdk.services.macie2.model.SearchResourcesRequest)} operation.</b>
     * </p>
     *
     * @param searchResourcesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.SearchResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/SearchResources" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchResourcesPublisher searchResourcesPaginator(SearchResourcesRequest searchResourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves (queries) statistical data and other information about Amazon Web Services resources that Amazon Macie
     * monitors and analyzes.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchResources(software.amazon.awssdk.services.macie2.model.SearchResourcesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.SearchResourcesPublisher publisher = client.searchResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.SearchResourcesPublisher publisher = client.searchResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.macie2.model.SearchResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.macie2.model.SearchResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchResources(software.amazon.awssdk.services.macie2.model.SearchResourcesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchResourcesRequest.Builder} avoiding the need
     * to create one manually via {@link SearchResourcesRequest#builder()}
     * </p>
     *
     * @param searchResourcesRequest
     *        A {@link Consumer} that will call methods on {@link SearchResourcesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.SearchResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/SearchResources" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchResourcesPublisher searchResourcesPaginator(Consumer<SearchResourcesRequest.Builder> searchResourcesRequest) {
        return searchResourcesPaginator(SearchResourcesRequest.builder().applyMutation(searchResourcesRequest).build());
    }

    /**
     * <p>
     * Adds or updates one or more tags (keys and values) that are associated with a classification job, custom data
     * identifier, findings filter, or member account.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or updates one or more tags (keys and values) that are associated with a classification job, custom data
     * identifier, findings filter, or member account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Tests a custom data identifier.
     * </p>
     *
     * @param testCustomDataIdentifierRequest
     * @return A Java Future containing the result of the TestCustomDataIdentifier operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.TestCustomDataIdentifier
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/TestCustomDataIdentifier"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TestCustomDataIdentifierResponse> testCustomDataIdentifier(
            TestCustomDataIdentifierRequest testCustomDataIdentifierRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Tests a custom data identifier.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TestCustomDataIdentifierRequest.Builder} avoiding
     * the need to create one manually via {@link TestCustomDataIdentifierRequest#builder()}
     * </p>
     *
     * @param testCustomDataIdentifierRequest
     *        A {@link Consumer} that will call methods on {@link TestCustomDataIdentifierRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the TestCustomDataIdentifier operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.TestCustomDataIdentifier
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/TestCustomDataIdentifier"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TestCustomDataIdentifierResponse> testCustomDataIdentifier(
            Consumer<TestCustomDataIdentifierRequest.Builder> testCustomDataIdentifierRequest) {
        return testCustomDataIdentifier(TestCustomDataIdentifierRequest.builder().applyMutation(testCustomDataIdentifierRequest)
                .build());
    }

    /**
     * <p>
     * Removes one or more tags (keys and values) from a classification job, custom data identifier, findings filter, or
     * member account.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes one or more tags (keys and values) from a classification job, custom data identifier, findings filter, or
     * member account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Changes the status of a classification job.
     * </p>
     *
     * @param updateClassificationJobRequest
     * @return A Java Future containing the result of the UpdateClassificationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.UpdateClassificationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/UpdateClassificationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateClassificationJobResponse> updateClassificationJob(
            UpdateClassificationJobRequest updateClassificationJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Changes the status of a classification job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateClassificationJobRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateClassificationJobRequest#builder()}
     * </p>
     *
     * @param updateClassificationJobRequest
     *        A {@link Consumer} that will call methods on {@link UpdateClassificationJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateClassificationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.UpdateClassificationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/UpdateClassificationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateClassificationJobResponse> updateClassificationJob(
            Consumer<UpdateClassificationJobRequest.Builder> updateClassificationJobRequest) {
        return updateClassificationJob(UpdateClassificationJobRequest.builder().applyMutation(updateClassificationJobRequest)
                .build());
    }

    /**
     * <p>
     * Updates the criteria and other settings for a findings filter.
     * </p>
     *
     * @param updateFindingsFilterRequest
     * @return A Java Future containing the result of the UpdateFindingsFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.UpdateFindingsFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/UpdateFindingsFilter" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateFindingsFilterResponse> updateFindingsFilter(
            UpdateFindingsFilterRequest updateFindingsFilterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the criteria and other settings for a findings filter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFindingsFilterRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateFindingsFilterRequest#builder()}
     * </p>
     *
     * @param updateFindingsFilterRequest
     *        A {@link Consumer} that will call methods on {@link UpdateFindingsFilterRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateFindingsFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.UpdateFindingsFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/UpdateFindingsFilter" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateFindingsFilterResponse> updateFindingsFilter(
            Consumer<UpdateFindingsFilterRequest.Builder> updateFindingsFilterRequest) {
        return updateFindingsFilter(UpdateFindingsFilterRequest.builder().applyMutation(updateFindingsFilterRequest).build());
    }

    /**
     * <p>
     * Suspends or re-enables Amazon Macie, or updates the configuration settings for a Macie account.
     * </p>
     *
     * @param updateMacieSessionRequest
     * @return A Java Future containing the result of the UpdateMacieSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.UpdateMacieSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/UpdateMacieSession" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateMacieSessionResponse> updateMacieSession(UpdateMacieSessionRequest updateMacieSessionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Suspends or re-enables Amazon Macie, or updates the configuration settings for a Macie account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateMacieSessionRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateMacieSessionRequest#builder()}
     * </p>
     *
     * @param updateMacieSessionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateMacieSessionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateMacieSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.UpdateMacieSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/UpdateMacieSession" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateMacieSessionResponse> updateMacieSession(
            Consumer<UpdateMacieSessionRequest.Builder> updateMacieSessionRequest) {
        return updateMacieSession(UpdateMacieSessionRequest.builder().applyMutation(updateMacieSessionRequest).build());
    }

    /**
     * <p>
     * Enables an Amazon Macie administrator to suspend or re-enable Macie for a member account.
     * </p>
     *
     * @param updateMemberSessionRequest
     * @return A Java Future containing the result of the UpdateMemberSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.UpdateMemberSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/UpdateMemberSession" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateMemberSessionResponse> updateMemberSession(
            UpdateMemberSessionRequest updateMemberSessionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables an Amazon Macie administrator to suspend or re-enable Macie for a member account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateMemberSessionRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateMemberSessionRequest#builder()}
     * </p>
     *
     * @param updateMemberSessionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateMemberSessionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateMemberSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.UpdateMemberSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/UpdateMemberSession" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateMemberSessionResponse> updateMemberSession(
            Consumer<UpdateMemberSessionRequest.Builder> updateMemberSessionRequest) {
        return updateMemberSession(UpdateMemberSessionRequest.builder().applyMutation(updateMemberSessionRequest).build());
    }

    /**
     * <p>
     * Updates the Amazon Macie configuration settings for an organization in Organizations.
     * </p>
     *
     * @param updateOrganizationConfigurationRequest
     * @return A Java Future containing the result of the UpdateOrganizationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.UpdateOrganizationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/UpdateOrganizationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateOrganizationConfigurationResponse> updateOrganizationConfiguration(
            UpdateOrganizationConfigurationRequest updateOrganizationConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the Amazon Macie configuration settings for an organization in Organizations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateOrganizationConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateOrganizationConfigurationRequest#builder()}
     * </p>
     *
     * @param updateOrganizationConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateOrganizationConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateOrganizationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because it contains a syntax error.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.UpdateOrganizationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/UpdateOrganizationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateOrganizationConfigurationResponse> updateOrganizationConfiguration(
            Consumer<UpdateOrganizationConfigurationRequest.Builder> updateOrganizationConfigurationRequest) {
        return updateOrganizationConfiguration(UpdateOrganizationConfigurationRequest.builder()
                .applyMutation(updateOrganizationConfigurationRequest).build());
    }
}
