/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.machinelearning.MachineLearningClient;
import software.amazon.awssdk.services.machinelearning.internal.UserAgentUtils;
import software.amazon.awssdk.services.machinelearning.model.DescribeMlModelsRequest;
import software.amazon.awssdk.services.machinelearning.model.DescribeMlModelsResponse;
import software.amazon.awssdk.services.machinelearning.model.MLModel;

public class DescribeMLModelsIterable
implements SdkIterable<DescribeMlModelsResponse> {
    private final MachineLearningClient client;
    private final DescribeMlModelsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeMLModelsIterable(MachineLearningClient client, DescribeMlModelsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeMlModelsResponseFetcher();
    }

    public Iterator<DescribeMlModelsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MLModel> results() {
        Function<DescribeMlModelsResponse, Iterator> getIterator = response -> {
            if (response != null && response.results() != null) {
                return response.results().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeMlModelsResponseFetcher
    implements SyncPageFetcher<DescribeMlModelsResponse> {
        private DescribeMlModelsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeMlModelsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeMlModelsResponse nextPage(DescribeMlModelsResponse previousPage) {
            if (previousPage == null) {
                return DescribeMLModelsIterable.this.client.describeMLModels(DescribeMLModelsIterable.this.firstRequest);
            }
            return DescribeMLModelsIterable.this.client.describeMLModels((DescribeMlModelsRequest)((Object)DescribeMLModelsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

