/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MLModelFilterVariable {
    CREATED_AT("CreatedAt"),
    LAST_UPDATED_AT("LastUpdatedAt"),
    STATUS("Status"),
    NAME("Name"),
    IAM_USER("IAMUser"),
    TRAINING_DATA_SOURCE_ID("TrainingDataSourceId"),
    REALTIME_ENDPOINT_STATUS("RealtimeEndpointStatus"),
    ML_MODEL_TYPE("MLModelType"),
    ALGORITHM("Algorithm"),
    TRAINING_DATA_URI("TrainingDataURI"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MLModelFilterVariable> VALUE_MAP;
    private final String value;

    private MLModelFilterVariable(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MLModelFilterVariable fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MLModelFilterVariable> knownValues() {
        EnumSet<MLModelFilterVariable> knownValues = EnumSet.allOf(MLModelFilterVariable.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MLModelFilterVariable.class, MLModelFilterVariable::toString);
    }
}

