/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.m2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.m2.M2Client;
import software.amazon.awssdk.services.m2.internal.UserAgentUtils;
import software.amazon.awssdk.services.m2.model.BatchJobDefinition;
import software.amazon.awssdk.services.m2.model.ListBatchJobDefinitionsRequest;
import software.amazon.awssdk.services.m2.model.ListBatchJobDefinitionsResponse;

public class ListBatchJobDefinitionsIterable
implements SdkIterable<ListBatchJobDefinitionsResponse> {
    private final M2Client client;
    private final ListBatchJobDefinitionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListBatchJobDefinitionsIterable(M2Client client, ListBatchJobDefinitionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListBatchJobDefinitionsResponseFetcher();
    }

    public Iterator<ListBatchJobDefinitionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<BatchJobDefinition> batchJobDefinitions() {
        Function<ListBatchJobDefinitionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.batchJobDefinitions() != null) {
                return response.batchJobDefinitions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListBatchJobDefinitionsResponseFetcher
    implements SyncPageFetcher<ListBatchJobDefinitionsResponse> {
        private ListBatchJobDefinitionsResponseFetcher() {
        }

        public boolean hasNextPage(ListBatchJobDefinitionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListBatchJobDefinitionsResponse nextPage(ListBatchJobDefinitionsResponse previousPage) {
            if (previousPage == null) {
                return ListBatchJobDefinitionsIterable.this.client.listBatchJobDefinitions(ListBatchJobDefinitionsIterable.this.firstRequest);
            }
            return ListBatchJobDefinitionsIterable.this.client.listBatchJobDefinitions((ListBatchJobDefinitionsRequest)((Object)ListBatchJobDefinitionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

