/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.m2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.m2.model.DataSetImportTask;
import software.amazon.awssdk.services.m2.model.DataSetImportTaskListCopier;
import software.amazon.awssdk.services.m2.model.M2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDataSetImportHistoryResponse
extends M2Response
implements ToCopyableBuilder<Builder, ListDataSetImportHistoryResponse> {
    private static final SdkField<List<DataSetImportTask>> DATA_SET_IMPORT_TASKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dataSetImportTasks").getter(ListDataSetImportHistoryResponse.getter(ListDataSetImportHistoryResponse::dataSetImportTasks)).setter(ListDataSetImportHistoryResponse.setter(Builder::dataSetImportTasks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSetImportTasks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSetImportTask::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListDataSetImportHistoryResponse.getter(ListDataSetImportHistoryResponse::nextToken)).setter(ListDataSetImportHistoryResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SET_IMPORT_TASKS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListDataSetImportHistoryResponse.memberNameToFieldInitializer();
    private final List<DataSetImportTask> dataSetImportTasks;
    private final String nextToken;

    private ListDataSetImportHistoryResponse(BuilderImpl builder) {
        super(builder);
        this.dataSetImportTasks = builder.dataSetImportTasks;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDataSetImportTasks() {
        return this.dataSetImportTasks != null && !(this.dataSetImportTasks instanceof SdkAutoConstructList);
    }

    public final List<DataSetImportTask> dataSetImportTasks() {
        return this.dataSetImportTasks;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataSetImportTasks() ? this.dataSetImportTasks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDataSetImportHistoryResponse)) {
            return false;
        }
        ListDataSetImportHistoryResponse other = (ListDataSetImportHistoryResponse)((Object)obj);
        return this.hasDataSetImportTasks() == other.hasDataSetImportTasks() && Objects.equals(this.dataSetImportTasks(), other.dataSetImportTasks()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListDataSetImportHistoryResponse").add("DataSetImportTasks", this.hasDataSetImportTasks() ? this.dataSetImportTasks() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dataSetImportTasks": {
                return Optional.ofNullable(clazz.cast(this.dataSetImportTasks()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataSetImportTasks", DATA_SET_IMPORT_TASKS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDataSetImportHistoryResponse, T> g) {
        return obj -> g.apply((ListDataSetImportHistoryResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends M2Response.BuilderImpl
    implements Builder {
        private List<DataSetImportTask> dataSetImportTasks = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDataSetImportHistoryResponse model) {
            super(model);
            this.dataSetImportTasks(model.dataSetImportTasks);
            this.nextToken(model.nextToken);
        }

        public final List<DataSetImportTask.Builder> getDataSetImportTasks() {
            List<DataSetImportTask.Builder> result = DataSetImportTaskListCopier.copyToBuilder(this.dataSetImportTasks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataSetImportTasks(Collection<DataSetImportTask.BuilderImpl> dataSetImportTasks) {
            this.dataSetImportTasks = DataSetImportTaskListCopier.copyFromBuilder(dataSetImportTasks);
        }

        @Override
        public final Builder dataSetImportTasks(Collection<DataSetImportTask> dataSetImportTasks) {
            this.dataSetImportTasks = DataSetImportTaskListCopier.copy(dataSetImportTasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSetImportTasks(DataSetImportTask ... dataSetImportTasks) {
            this.dataSetImportTasks(Arrays.asList(dataSetImportTasks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSetImportTasks(Consumer<DataSetImportTask.Builder> ... dataSetImportTasks) {
            this.dataSetImportTasks(Stream.of(dataSetImportTasks).map(c -> (DataSetImportTask)((DataSetImportTask.Builder)DataSetImportTask.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDataSetImportHistoryResponse build() {
            return new ListDataSetImportHistoryResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends M2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDataSetImportHistoryResponse> {
        public Builder dataSetImportTasks(Collection<DataSetImportTask> var1);

        public Builder dataSetImportTasks(DataSetImportTask ... var1);

        public Builder dataSetImportTasks(Consumer<DataSetImportTask.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

