/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutvision.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lookoutvision.LookoutVisionClient;
import software.amazon.awssdk.services.lookoutvision.internal.UserAgentUtils;
import software.amazon.awssdk.services.lookoutvision.model.ListDatasetEntriesRequest;
import software.amazon.awssdk.services.lookoutvision.model.ListDatasetEntriesResponse;

public class ListDatasetEntriesIterable
implements SdkIterable<ListDatasetEntriesResponse> {
    private final LookoutVisionClient client;
    private final ListDatasetEntriesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDatasetEntriesIterable(LookoutVisionClient client, ListDatasetEntriesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDatasetEntriesResponseFetcher();
    }

    public Iterator<ListDatasetEntriesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> datasetEntries() {
        Function<ListDatasetEntriesResponse, Iterator> getIterator = response -> {
            if (response != null && response.datasetEntries() != null) {
                return response.datasetEntries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDatasetEntriesResponseFetcher
    implements SyncPageFetcher<ListDatasetEntriesResponse> {
        private ListDatasetEntriesResponseFetcher() {
        }

        public boolean hasNextPage(ListDatasetEntriesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDatasetEntriesResponse nextPage(ListDatasetEntriesResponse previousPage) {
            if (previousPage == null) {
                return ListDatasetEntriesIterable.this.client.listDatasetEntries(ListDatasetEntriesIterable.this.firstRequest);
            }
            return ListDatasetEntriesIterable.this.client.listDatasetEntries((ListDatasetEntriesRequest)((Object)ListDatasetEntriesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

