/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutvision.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DatasetImageStats
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DatasetImageStats> {
    private static final SdkField<Integer> TOTAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Total").getter(DatasetImageStats.getter(DatasetImageStats::total)).setter(DatasetImageStats.setter(Builder::total)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Total").build()}).build();
    private static final SdkField<Integer> LABELED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Labeled").getter(DatasetImageStats.getter(DatasetImageStats::labeled)).setter(DatasetImageStats.setter(Builder::labeled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Labeled").build()}).build();
    private static final SdkField<Integer> NORMAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Normal").getter(DatasetImageStats.getter(DatasetImageStats::normal)).setter(DatasetImageStats.setter(Builder::normal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Normal").build()}).build();
    private static final SdkField<Integer> ANOMALY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Anomaly").getter(DatasetImageStats.getter(DatasetImageStats::anomaly)).setter(DatasetImageStats.setter(Builder::anomaly)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Anomaly").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_FIELD, LABELED_FIELD, NORMAL_FIELD, ANOMALY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DatasetImageStats.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer total;
    private final Integer labeled;
    private final Integer normal;
    private final Integer anomaly;

    private DatasetImageStats(BuilderImpl builder) {
        this.total = builder.total;
        this.labeled = builder.labeled;
        this.normal = builder.normal;
        this.anomaly = builder.anomaly;
    }

    public final Integer total() {
        return this.total;
    }

    public final Integer labeled() {
        return this.labeled;
    }

    public final Integer normal() {
        return this.normal;
    }

    public final Integer anomaly() {
        return this.anomaly;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.total());
        hashCode = 31 * hashCode + Objects.hashCode(this.labeled());
        hashCode = 31 * hashCode + Objects.hashCode(this.normal());
        hashCode = 31 * hashCode + Objects.hashCode(this.anomaly());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetImageStats)) {
            return false;
        }
        DatasetImageStats other = (DatasetImageStats)obj;
        return Objects.equals(this.total(), other.total()) && Objects.equals(this.labeled(), other.labeled()) && Objects.equals(this.normal(), other.normal()) && Objects.equals(this.anomaly(), other.anomaly());
    }

    public final String toString() {
        return ToString.builder((String)"DatasetImageStats").add("Total", (Object)this.total()).add("Labeled", (Object)this.labeled()).add("Normal", (Object)this.normal()).add("Anomaly", (Object)this.anomaly()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Total": {
                return Optional.ofNullable(clazz.cast(this.total()));
            }
            case "Labeled": {
                return Optional.ofNullable(clazz.cast(this.labeled()));
            }
            case "Normal": {
                return Optional.ofNullable(clazz.cast(this.normal()));
            }
            case "Anomaly": {
                return Optional.ofNullable(clazz.cast(this.anomaly()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Integer>> map = new HashMap<String, SdkField<Integer>>();
        map.put("Total", TOTAL_FIELD);
        map.put("Labeled", LABELED_FIELD);
        map.put("Normal", NORMAL_FIELD);
        map.put("Anomaly", ANOMALY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DatasetImageStats, T> g) {
        return obj -> g.apply((DatasetImageStats)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer total;
        private Integer labeled;
        private Integer normal;
        private Integer anomaly;

        private BuilderImpl() {
        }

        private BuilderImpl(DatasetImageStats model) {
            this.total(model.total);
            this.labeled(model.labeled);
            this.normal(model.normal);
            this.anomaly(model.anomaly);
        }

        public final Integer getTotal() {
            return this.total;
        }

        public final void setTotal(Integer total) {
            this.total = total;
        }

        @Override
        public final Builder total(Integer total) {
            this.total = total;
            return this;
        }

        public final Integer getLabeled() {
            return this.labeled;
        }

        public final void setLabeled(Integer labeled) {
            this.labeled = labeled;
        }

        @Override
        public final Builder labeled(Integer labeled) {
            this.labeled = labeled;
            return this;
        }

        public final Integer getNormal() {
            return this.normal;
        }

        public final void setNormal(Integer normal) {
            this.normal = normal;
        }

        @Override
        public final Builder normal(Integer normal) {
            this.normal = normal;
            return this;
        }

        public final Integer getAnomaly() {
            return this.anomaly;
        }

        public final void setAnomaly(Integer anomaly) {
            this.anomaly = anomaly;
        }

        @Override
        public final Builder anomaly(Integer anomaly) {
            this.anomaly = anomaly;
            return this;
        }

        public DatasetImageStats build() {
            return new DatasetImageStats(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DatasetImageStats> {
        public Builder total(Integer var1);

        public Builder labeled(Integer var1);

        public Builder normal(Integer var1);

        public Builder anomaly(Integer var1);
    }
}

