/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutvision.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lookoutvision.model.DatasetStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DatasetMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DatasetMetadata> {
    private static final SdkField<String> DATASET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatasetType").getter(DatasetMetadata.getter(DatasetMetadata::datasetType)).setter(DatasetMetadata.setter(Builder::datasetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetType").build()}).build();
    private static final SdkField<Instant> CREATION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTimestamp").getter(DatasetMetadata.getter(DatasetMetadata::creationTimestamp)).setter(DatasetMetadata.setter(Builder::creationTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimestamp").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DatasetMetadata.getter(DatasetMetadata::statusAsString)).setter(DatasetMetadata.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(DatasetMetadata.getter(DatasetMetadata::statusMessage)).setter(DatasetMetadata.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_TYPE_FIELD, CREATION_TIMESTAMP_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DatasetMetadata.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String datasetType;
    private final Instant creationTimestamp;
    private final String status;
    private final String statusMessage;

    private DatasetMetadata(BuilderImpl builder) {
        this.datasetType = builder.datasetType;
        this.creationTimestamp = builder.creationTimestamp;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
    }

    public final String datasetType() {
        return this.datasetType;
    }

    public final Instant creationTimestamp() {
        return this.creationTimestamp;
    }

    public final DatasetStatus status() {
        return DatasetStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetType());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetMetadata)) {
            return false;
        }
        DatasetMetadata other = (DatasetMetadata)obj;
        return Objects.equals(this.datasetType(), other.datasetType()) && Objects.equals(this.creationTimestamp(), other.creationTimestamp()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage());
    }

    public final String toString() {
        return ToString.builder((String)"DatasetMetadata").add("DatasetType", (Object)this.datasetType()).add("CreationTimestamp", (Object)this.creationTimestamp()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DatasetType": {
                return Optional.ofNullable(clazz.cast(this.datasetType()));
            }
            case "CreationTimestamp": {
                return Optional.ofNullable(clazz.cast(this.creationTimestamp()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DatasetType", DATASET_TYPE_FIELD);
        map.put("CreationTimestamp", CREATION_TIMESTAMP_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DatasetMetadata, T> g) {
        return obj -> g.apply((DatasetMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String datasetType;
        private Instant creationTimestamp;
        private String status;
        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(DatasetMetadata model) {
            this.datasetType(model.datasetType);
            this.creationTimestamp(model.creationTimestamp);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
        }

        public final String getDatasetType() {
            return this.datasetType;
        }

        public final void setDatasetType(String datasetType) {
            this.datasetType = datasetType;
        }

        @Override
        public final Builder datasetType(String datasetType) {
            this.datasetType = datasetType;
            return this;
        }

        public final Instant getCreationTimestamp() {
            return this.creationTimestamp;
        }

        public final void setCreationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DatasetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public DatasetMetadata build() {
            return new DatasetMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DatasetMetadata> {
        public Builder datasetType(String var1);

        public Builder creationTimestamp(Instant var1);

        public Builder status(String var1);

        public Builder status(DatasetStatus var1);

        public Builder statusMessage(String var1);
    }
}

