/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutvision.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lookoutvision.LookoutVisionAsyncClient;
import software.amazon.awssdk.services.lookoutvision.internal.UserAgentUtils;
import software.amazon.awssdk.services.lookoutvision.model.ListDatasetEntriesRequest;
import software.amazon.awssdk.services.lookoutvision.model.ListDatasetEntriesResponse;

public class ListDatasetEntriesPublisher
implements SdkPublisher<ListDatasetEntriesResponse> {
    private final LookoutVisionAsyncClient client;
    private final ListDatasetEntriesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDatasetEntriesPublisher(LookoutVisionAsyncClient client, ListDatasetEntriesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDatasetEntriesPublisher(LookoutVisionAsyncClient client, ListDatasetEntriesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDatasetEntriesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDatasetEntriesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> datasetEntries() {
        Function<ListDatasetEntriesResponse, Iterator> getIterator = response -> {
            if (response != null && response.datasetEntries() != null) {
                return response.datasetEntries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDatasetEntriesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDatasetEntriesResponseFetcher
    implements AsyncPageFetcher<ListDatasetEntriesResponse> {
        private ListDatasetEntriesResponseFetcher() {
        }

        public boolean hasNextPage(ListDatasetEntriesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDatasetEntriesResponse> nextPage(ListDatasetEntriesResponse previousPage) {
            if (previousPage == null) {
                return ListDatasetEntriesPublisher.this.client.listDatasetEntries(ListDatasetEntriesPublisher.this.firstRequest);
            }
            return ListDatasetEntriesPublisher.this.client.listDatasetEntries((ListDatasetEntriesRequest)((Object)ListDatasetEntriesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

