/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutvision.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The platform on which a model runs on an AWS IoT Greengrass core device.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TargetPlatform implements SdkPojo, Serializable, ToCopyableBuilder<TargetPlatform.Builder, TargetPlatform> {
    private static final SdkField<String> OS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Os")
            .getter(getter(TargetPlatform::osAsString)).setter(setter(Builder::os))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Os").build()).build();

    private static final SdkField<String> ARCH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arch")
            .getter(getter(TargetPlatform::archAsString)).setter(setter(Builder::arch))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arch").build()).build();

    private static final SdkField<String> ACCELERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Accelerator").getter(getter(TargetPlatform::acceleratorAsString)).setter(setter(Builder::accelerator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Accelerator").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OS_FIELD, ARCH_FIELD,
            ACCELERATOR_FIELD));

    private static final long serialVersionUID = 1L;

    private final String os;

    private final String arch;

    private final String accelerator;

    private TargetPlatform(BuilderImpl builder) {
        this.os = builder.os;
        this.arch = builder.arch;
        this.accelerator = builder.accelerator;
    }

    /**
     * <p>
     * The target operating system for the model. Linux is the only operating system that is currently supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #os} will return
     * {@link TargetPlatformOs#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #osAsString}.
     * </p>
     * 
     * @return The target operating system for the model. Linux is the only operating system that is currently
     *         supported.
     * @see TargetPlatformOs
     */
    public final TargetPlatformOs os() {
        return TargetPlatformOs.fromValue(os);
    }

    /**
     * <p>
     * The target operating system for the model. Linux is the only operating system that is currently supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #os} will return
     * {@link TargetPlatformOs#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #osAsString}.
     * </p>
     * 
     * @return The target operating system for the model. Linux is the only operating system that is currently
     *         supported.
     * @see TargetPlatformOs
     */
    public final String osAsString() {
        return os;
    }

    /**
     * <p>
     * The target architecture for the model. The currently supported architectures are X86_64 (64-bit version of the
     * x86 instruction set) and ARM_64 (ARMv8 64-bit CPU).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #arch} will return
     * {@link TargetPlatformArch#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #archAsString}.
     * </p>
     * 
     * @return The target architecture for the model. The currently supported architectures are X86_64 (64-bit version
     *         of the x86 instruction set) and ARM_64 (ARMv8 64-bit CPU).
     * @see TargetPlatformArch
     */
    public final TargetPlatformArch arch() {
        return TargetPlatformArch.fromValue(arch);
    }

    /**
     * <p>
     * The target architecture for the model. The currently supported architectures are X86_64 (64-bit version of the
     * x86 instruction set) and ARM_64 (ARMv8 64-bit CPU).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #arch} will return
     * {@link TargetPlatformArch#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #archAsString}.
     * </p>
     * 
     * @return The target architecture for the model. The currently supported architectures are X86_64 (64-bit version
     *         of the x86 instruction set) and ARM_64 (ARMv8 64-bit CPU).
     * @see TargetPlatformArch
     */
    public final String archAsString() {
        return arch;
    }

    /**
     * <p>
     * The target accelerator for the model. NVIDIA (Nvidia graphics processing unit) is the only accelerator that is
     * currently supported. You must also specify the <code>gpu-code</code>, <code>trt-ver</code>, and
     * <code>cuda-ver</code> compiler options.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accelerator} will
     * return {@link TargetPlatformAccelerator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #acceleratorAsString}.
     * </p>
     * 
     * @return The target accelerator for the model. NVIDIA (Nvidia graphics processing unit) is the only accelerator
     *         that is currently supported. You must also specify the <code>gpu-code</code>, <code>trt-ver</code>, and
     *         <code>cuda-ver</code> compiler options.
     * @see TargetPlatformAccelerator
     */
    public final TargetPlatformAccelerator accelerator() {
        return TargetPlatformAccelerator.fromValue(accelerator);
    }

    /**
     * <p>
     * The target accelerator for the model. NVIDIA (Nvidia graphics processing unit) is the only accelerator that is
     * currently supported. You must also specify the <code>gpu-code</code>, <code>trt-ver</code>, and
     * <code>cuda-ver</code> compiler options.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accelerator} will
     * return {@link TargetPlatformAccelerator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #acceleratorAsString}.
     * </p>
     * 
     * @return The target accelerator for the model. NVIDIA (Nvidia graphics processing unit) is the only accelerator
     *         that is currently supported. You must also specify the <code>gpu-code</code>, <code>trt-ver</code>, and
     *         <code>cuda-ver</code> compiler options.
     * @see TargetPlatformAccelerator
     */
    public final String acceleratorAsString() {
        return accelerator;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(osAsString());
        hashCode = 31 * hashCode + Objects.hashCode(archAsString());
        hashCode = 31 * hashCode + Objects.hashCode(acceleratorAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetPlatform)) {
            return false;
        }
        TargetPlatform other = (TargetPlatform) obj;
        return Objects.equals(osAsString(), other.osAsString()) && Objects.equals(archAsString(), other.archAsString())
                && Objects.equals(acceleratorAsString(), other.acceleratorAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TargetPlatform").add("Os", osAsString()).add("Arch", archAsString())
                .add("Accelerator", acceleratorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Os":
            return Optional.ofNullable(clazz.cast(osAsString()));
        case "Arch":
            return Optional.ofNullable(clazz.cast(archAsString()));
        case "Accelerator":
            return Optional.ofNullable(clazz.cast(acceleratorAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TargetPlatform, T> g) {
        return obj -> g.apply((TargetPlatform) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TargetPlatform> {
        /**
         * <p>
         * The target operating system for the model. Linux is the only operating system that is currently supported.
         * </p>
         * 
         * @param os
         *        The target operating system for the model. Linux is the only operating system that is currently
         *        supported.
         * @see TargetPlatformOs
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetPlatformOs
         */
        Builder os(String os);

        /**
         * <p>
         * The target operating system for the model. Linux is the only operating system that is currently supported.
         * </p>
         * 
         * @param os
         *        The target operating system for the model. Linux is the only operating system that is currently
         *        supported.
         * @see TargetPlatformOs
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetPlatformOs
         */
        Builder os(TargetPlatformOs os);

        /**
         * <p>
         * The target architecture for the model. The currently supported architectures are X86_64 (64-bit version of
         * the x86 instruction set) and ARM_64 (ARMv8 64-bit CPU).
         * </p>
         * 
         * @param arch
         *        The target architecture for the model. The currently supported architectures are X86_64 (64-bit
         *        version of the x86 instruction set) and ARM_64 (ARMv8 64-bit CPU).
         * @see TargetPlatformArch
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetPlatformArch
         */
        Builder arch(String arch);

        /**
         * <p>
         * The target architecture for the model. The currently supported architectures are X86_64 (64-bit version of
         * the x86 instruction set) and ARM_64 (ARMv8 64-bit CPU).
         * </p>
         * 
         * @param arch
         *        The target architecture for the model. The currently supported architectures are X86_64 (64-bit
         *        version of the x86 instruction set) and ARM_64 (ARMv8 64-bit CPU).
         * @see TargetPlatformArch
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetPlatformArch
         */
        Builder arch(TargetPlatformArch arch);

        /**
         * <p>
         * The target accelerator for the model. NVIDIA (Nvidia graphics processing unit) is the only accelerator that
         * is currently supported. You must also specify the <code>gpu-code</code>, <code>trt-ver</code>, and
         * <code>cuda-ver</code> compiler options.
         * </p>
         * 
         * @param accelerator
         *        The target accelerator for the model. NVIDIA (Nvidia graphics processing unit) is the only accelerator
         *        that is currently supported. You must also specify the <code>gpu-code</code>, <code>trt-ver</code>,
         *        and <code>cuda-ver</code> compiler options.
         * @see TargetPlatformAccelerator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetPlatformAccelerator
         */
        Builder accelerator(String accelerator);

        /**
         * <p>
         * The target accelerator for the model. NVIDIA (Nvidia graphics processing unit) is the only accelerator that
         * is currently supported. You must also specify the <code>gpu-code</code>, <code>trt-ver</code>, and
         * <code>cuda-ver</code> compiler options.
         * </p>
         * 
         * @param accelerator
         *        The target accelerator for the model. NVIDIA (Nvidia graphics processing unit) is the only accelerator
         *        that is currently supported. You must also specify the <code>gpu-code</code>, <code>trt-ver</code>,
         *        and <code>cuda-ver</code> compiler options.
         * @see TargetPlatformAccelerator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetPlatformAccelerator
         */
        Builder accelerator(TargetPlatformAccelerator accelerator);
    }

    static final class BuilderImpl implements Builder {
        private String os;

        private String arch;

        private String accelerator;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetPlatform model) {
            os(model.os);
            arch(model.arch);
            accelerator(model.accelerator);
        }

        public final String getOs() {
            return os;
        }

        public final void setOs(String os) {
            this.os = os;
        }

        @Override
        @Transient
        public final Builder os(String os) {
            this.os = os;
            return this;
        }

        @Override
        @Transient
        public final Builder os(TargetPlatformOs os) {
            this.os(os == null ? null : os.toString());
            return this;
        }

        public final String getArch() {
            return arch;
        }

        public final void setArch(String arch) {
            this.arch = arch;
        }

        @Override
        @Transient
        public final Builder arch(String arch) {
            this.arch = arch;
            return this;
        }

        @Override
        @Transient
        public final Builder arch(TargetPlatformArch arch) {
            this.arch(arch == null ? null : arch.toString());
            return this;
        }

        public final String getAccelerator() {
            return accelerator;
        }

        public final void setAccelerator(String accelerator) {
            this.accelerator = accelerator;
        }

        @Override
        @Transient
        public final Builder accelerator(String accelerator) {
            this.accelerator = accelerator;
            return this;
        }

        @Override
        @Transient
        public final Builder accelerator(TargetPlatformAccelerator accelerator) {
            this.accelerator(accelerator == null ? null : accelerator.toString());
            return this;
        }

        @Override
        public TargetPlatform build() {
            return new TargetPlatform(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
