/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutvision.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration information for a Amazon Lookout for Vision model packaging job. For more information, see
 * <a>StartModelPackagingJob</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModelPackagingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ModelPackagingConfiguration.Builder, ModelPackagingConfiguration> {
    private static final SdkField<GreengrassConfiguration> GREENGRASS_FIELD = SdkField
            .<GreengrassConfiguration> builder(MarshallingType.SDK_POJO).memberName("Greengrass")
            .getter(getter(ModelPackagingConfiguration::greengrass)).setter(setter(Builder::greengrass))
            .constructor(GreengrassConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Greengrass").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GREENGRASS_FIELD));

    private static final long serialVersionUID = 1L;

    private final GreengrassConfiguration greengrass;

    private ModelPackagingConfiguration(BuilderImpl builder) {
        this.greengrass = builder.greengrass;
    }

    /**
     * <p>
     * Configuration information for the AWS IoT Greengrass component in a model packaging job.
     * </p>
     * 
     * @return Configuration information for the AWS IoT Greengrass component in a model packaging job.
     */
    public final GreengrassConfiguration greengrass() {
        return greengrass;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(greengrass());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelPackagingConfiguration)) {
            return false;
        }
        ModelPackagingConfiguration other = (ModelPackagingConfiguration) obj;
        return Objects.equals(greengrass(), other.greengrass());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModelPackagingConfiguration").add("Greengrass", greengrass()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Greengrass":
            return Optional.ofNullable(clazz.cast(greengrass()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModelPackagingConfiguration, T> g) {
        return obj -> g.apply((ModelPackagingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModelPackagingConfiguration> {
        /**
         * <p>
         * Configuration information for the AWS IoT Greengrass component in a model packaging job.
         * </p>
         * 
         * @param greengrass
         *        Configuration information for the AWS IoT Greengrass component in a model packaging job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder greengrass(GreengrassConfiguration greengrass);

        /**
         * <p>
         * Configuration information for the AWS IoT Greengrass component in a model packaging job.
         * </p>
         * This is a convenience that creates an instance of the {@link GreengrassConfiguration.Builder} avoiding the
         * need to create one manually via {@link GreengrassConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link GreengrassConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #greengrass(GreengrassConfiguration)}.
         * 
         * @param greengrass
         *        a consumer that will call methods on {@link GreengrassConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #greengrass(GreengrassConfiguration)
         */
        default Builder greengrass(Consumer<GreengrassConfiguration.Builder> greengrass) {
            return greengrass(GreengrassConfiguration.builder().applyMutation(greengrass).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private GreengrassConfiguration greengrass;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelPackagingConfiguration model) {
            greengrass(model.greengrass);
        }

        public final GreengrassConfiguration.Builder getGreengrass() {
            return greengrass != null ? greengrass.toBuilder() : null;
        }

        public final void setGreengrass(GreengrassConfiguration.BuilderImpl greengrass) {
            this.greengrass = greengrass != null ? greengrass.build() : null;
        }

        @Override
        @Transient
        public final Builder greengrass(GreengrassConfiguration greengrass) {
            this.greengrass = greengrass;
            return this;
        }

        @Override
        public ModelPackagingConfiguration build() {
            return new ModelPackagingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
