/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutvision.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The prediction results from a call to <a>DetectAnomalies</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetectAnomalyResult implements SdkPojo, Serializable,
        ToCopyableBuilder<DetectAnomalyResult.Builder, DetectAnomalyResult> {
    private static final SdkField<ImageSource> SOURCE_FIELD = SdkField.<ImageSource> builder(MarshallingType.SDK_POJO)
            .memberName("Source").getter(getter(DetectAnomalyResult::source)).setter(setter(Builder::source))
            .constructor(ImageSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()).build();

    private static final SdkField<Boolean> IS_ANOMALOUS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsAnomalous").getter(getter(DetectAnomalyResult::isAnomalous)).setter(setter(Builder::isAnomalous))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsAnomalous").build()).build();

    private static final SdkField<Float> CONFIDENCE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("Confidence").getter(getter(DetectAnomalyResult::confidence)).setter(setter(Builder::confidence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Confidence").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD,
            IS_ANOMALOUS_FIELD, CONFIDENCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final ImageSource source;

    private final Boolean isAnomalous;

    private final Float confidence;

    private DetectAnomalyResult(BuilderImpl builder) {
        this.source = builder.source;
        this.isAnomalous = builder.isAnomalous;
        this.confidence = builder.confidence;
    }

    /**
     * <p>
     * The source of the image that was analyzed. <code>direct</code> means that the images was supplied from the local
     * computer. No other values are supported.
     * </p>
     * 
     * @return The source of the image that was analyzed. <code>direct</code> means that the images was supplied from
     *         the local computer. No other values are supported.
     */
    public final ImageSource source() {
        return source;
    }

    /**
     * <p>
     * True if the image contains an anomaly, otherwise false.
     * </p>
     * 
     * @return True if the image contains an anomaly, otherwise false.
     */
    public final Boolean isAnomalous() {
        return isAnomalous;
    }

    /**
     * <p>
     * The confidence that Amazon Lookout for Vision has in the accuracy of the prediction.
     * </p>
     * 
     * @return The confidence that Amazon Lookout for Vision has in the accuracy of the prediction.
     */
    public final Float confidence() {
        return confidence;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(isAnomalous());
        hashCode = 31 * hashCode + Objects.hashCode(confidence());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectAnomalyResult)) {
            return false;
        }
        DetectAnomalyResult other = (DetectAnomalyResult) obj;
        return Objects.equals(source(), other.source()) && Objects.equals(isAnomalous(), other.isAnomalous())
                && Objects.equals(confidence(), other.confidence());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DetectAnomalyResult").add("Source", source()).add("IsAnomalous", isAnomalous())
                .add("Confidence", confidence()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        case "IsAnomalous":
            return Optional.ofNullable(clazz.cast(isAnomalous()));
        case "Confidence":
            return Optional.ofNullable(clazz.cast(confidence()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectAnomalyResult, T> g) {
        return obj -> g.apply((DetectAnomalyResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DetectAnomalyResult> {
        /**
         * <p>
         * The source of the image that was analyzed. <code>direct</code> means that the images was supplied from the
         * local computer. No other values are supported.
         * </p>
         * 
         * @param source
         *        The source of the image that was analyzed. <code>direct</code> means that the images was supplied from
         *        the local computer. No other values are supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(ImageSource source);

        /**
         * <p>
         * The source of the image that was analyzed. <code>direct</code> means that the images was supplied from the
         * local computer. No other values are supported.
         * </p>
         * This is a convenience that creates an instance of the {@link ImageSource.Builder} avoiding the need to create
         * one manually via {@link ImageSource#builder()}.
         *
         * When the {@link Consumer} completes, {@link ImageSource.Builder#build()} is called immediately and its result
         * is passed to {@link #source(ImageSource)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link ImageSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(ImageSource)
         */
        default Builder source(Consumer<ImageSource.Builder> source) {
            return source(ImageSource.builder().applyMutation(source).build());
        }

        /**
         * <p>
         * True if the image contains an anomaly, otherwise false.
         * </p>
         * 
         * @param isAnomalous
         *        True if the image contains an anomaly, otherwise false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isAnomalous(Boolean isAnomalous);

        /**
         * <p>
         * The confidence that Amazon Lookout for Vision has in the accuracy of the prediction.
         * </p>
         * 
         * @param confidence
         *        The confidence that Amazon Lookout for Vision has in the accuracy of the prediction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confidence(Float confidence);
    }

    static final class BuilderImpl implements Builder {
        private ImageSource source;

        private Boolean isAnomalous;

        private Float confidence;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectAnomalyResult model) {
            source(model.source);
            isAnomalous(model.isAnomalous);
            confidence(model.confidence);
        }

        public final ImageSource.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        public final void setSource(ImageSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        @Transient
        public final Builder source(ImageSource source) {
            this.source = source;
            return this;
        }

        public final Boolean getIsAnomalous() {
            return isAnomalous;
        }

        public final void setIsAnomalous(Boolean isAnomalous) {
            this.isAnomalous = isAnomalous;
        }

        @Override
        @Transient
        public final Builder isAnomalous(Boolean isAnomalous) {
            this.isAnomalous = isAnomalous;
            return this;
        }

        public final Float getConfidence() {
            return confidence;
        }

        public final void setConfidence(Float confidence) {
            this.confidence = confidence;
        }

        @Override
        @Transient
        public final Builder confidence(Float confidence) {
            this.confidence = confidence;
            return this;
        }

        @Override
        public DetectAnomalyResult build() {
            return new DetectAnomalyResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
