/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutvision.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The description for a dataset. For more information, see <a>DescribeDataset</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatasetDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<DatasetDescription.Builder, DatasetDescription> {
    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProjectName").getter(getter(DatasetDescription::projectName)).setter(setter(Builder::projectName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectName").build()).build();

    private static final SdkField<String> DATASET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatasetType").getter(getter(DatasetDescription::datasetType)).setter(setter(Builder::datasetType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetType").build()).build();

    private static final SdkField<Instant> CREATION_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTimestamp").getter(getter(DatasetDescription::creationTimestamp))
            .setter(setter(Builder::creationTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimestamp").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTimestamp").getter(getter(DatasetDescription::lastUpdatedTimestamp))
            .setter(setter(Builder::lastUpdatedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTimestamp").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DatasetDescription::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(DatasetDescription::statusMessage)).setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final SdkField<DatasetImageStats> IMAGE_STATS_FIELD = SdkField
            .<DatasetImageStats> builder(MarshallingType.SDK_POJO).memberName("ImageStats")
            .getter(getter(DatasetDescription::imageStats)).setter(setter(Builder::imageStats))
            .constructor(DatasetImageStats::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageStats").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_NAME_FIELD,
            DATASET_TYPE_FIELD, CREATION_TIMESTAMP_FIELD, LAST_UPDATED_TIMESTAMP_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD,
            IMAGE_STATS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String projectName;

    private final String datasetType;

    private final Instant creationTimestamp;

    private final Instant lastUpdatedTimestamp;

    private final String status;

    private final String statusMessage;

    private final DatasetImageStats imageStats;

    private DatasetDescription(BuilderImpl builder) {
        this.projectName = builder.projectName;
        this.datasetType = builder.datasetType;
        this.creationTimestamp = builder.creationTimestamp;
        this.lastUpdatedTimestamp = builder.lastUpdatedTimestamp;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.imageStats = builder.imageStats;
    }

    /**
     * <p>
     * The name of the project that contains the dataset.
     * </p>
     * 
     * @return The name of the project that contains the dataset.
     */
    public final String projectName() {
        return projectName;
    }

    /**
     * <p>
     * The type of the dataset. The value <code>train</code> represents a training dataset or single dataset project.
     * The value <code>test</code> represents a test dataset.
     * </p>
     * 
     * @return The type of the dataset. The value <code>train</code> represents a training dataset or single dataset
     *         project. The value <code>test</code> represents a test dataset.
     */
    public final String datasetType() {
        return datasetType;
    }

    /**
     * <p>
     * The Unix timestamp for the time and date that the dataset was created.
     * </p>
     * 
     * @return The Unix timestamp for the time and date that the dataset was created.
     */
    public final Instant creationTimestamp() {
        return creationTimestamp;
    }

    /**
     * <p>
     * The Unix timestamp for the date and time that the dataset was last updated.
     * </p>
     * 
     * @return The Unix timestamp for the date and time that the dataset was last updated.
     */
    public final Instant lastUpdatedTimestamp() {
        return lastUpdatedTimestamp;
    }

    /**
     * <p>
     * The status of the dataset.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DatasetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the dataset.
     * @see DatasetStatus
     */
    public final DatasetStatus status() {
        return DatasetStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the dataset.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DatasetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the dataset.
     * @see DatasetStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The status message for the dataset.
     * </p>
     * 
     * @return The status message for the dataset.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * Statistics about the images in a dataset.
     * </p>
     * 
     * @return Statistics about the images in a dataset.
     */
    public final DatasetImageStats imageStats() {
        return imageStats;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(projectName());
        hashCode = 31 * hashCode + Objects.hashCode(datasetType());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(imageStats());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetDescription)) {
            return false;
        }
        DatasetDescription other = (DatasetDescription) obj;
        return Objects.equals(projectName(), other.projectName()) && Objects.equals(datasetType(), other.datasetType())
                && Objects.equals(creationTimestamp(), other.creationTimestamp())
                && Objects.equals(lastUpdatedTimestamp(), other.lastUpdatedTimestamp())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage()) && Objects.equals(imageStats(), other.imageStats());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DatasetDescription").add("ProjectName", projectName()).add("DatasetType", datasetType())
                .add("CreationTimestamp", creationTimestamp()).add("LastUpdatedTimestamp", lastUpdatedTimestamp())
                .add("Status", statusAsString()).add("StatusMessage", statusMessage()).add("ImageStats", imageStats()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProjectName":
            return Optional.ofNullable(clazz.cast(projectName()));
        case "DatasetType":
            return Optional.ofNullable(clazz.cast(datasetType()));
        case "CreationTimestamp":
            return Optional.ofNullable(clazz.cast(creationTimestamp()));
        case "LastUpdatedTimestamp":
            return Optional.ofNullable(clazz.cast(lastUpdatedTimestamp()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "ImageStats":
            return Optional.ofNullable(clazz.cast(imageStats()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DatasetDescription, T> g) {
        return obj -> g.apply((DatasetDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatasetDescription> {
        /**
         * <p>
         * The name of the project that contains the dataset.
         * </p>
         * 
         * @param projectName
         *        The name of the project that contains the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectName(String projectName);

        /**
         * <p>
         * The type of the dataset. The value <code>train</code> represents a training dataset or single dataset
         * project. The value <code>test</code> represents a test dataset.
         * </p>
         * 
         * @param datasetType
         *        The type of the dataset. The value <code>train</code> represents a training dataset or single dataset
         *        project. The value <code>test</code> represents a test dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetType(String datasetType);

        /**
         * <p>
         * The Unix timestamp for the time and date that the dataset was created.
         * </p>
         * 
         * @param creationTimestamp
         *        The Unix timestamp for the time and date that the dataset was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimestamp(Instant creationTimestamp);

        /**
         * <p>
         * The Unix timestamp for the date and time that the dataset was last updated.
         * </p>
         * 
         * @param lastUpdatedTimestamp
         *        The Unix timestamp for the date and time that the dataset was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTimestamp(Instant lastUpdatedTimestamp);

        /**
         * <p>
         * The status of the dataset.
         * </p>
         * 
         * @param status
         *        The status of the dataset.
         * @see DatasetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatasetStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the dataset.
         * </p>
         * 
         * @param status
         *        The status of the dataset.
         * @see DatasetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatasetStatus
         */
        Builder status(DatasetStatus status);

        /**
         * <p>
         * The status message for the dataset.
         * </p>
         * 
         * @param statusMessage
         *        The status message for the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * Statistics about the images in a dataset.
         * </p>
         * 
         * @param imageStats
         *        Statistics about the images in a dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageStats(DatasetImageStats imageStats);

        /**
         * <p>
         * Statistics about the images in a dataset.
         * </p>
         * This is a convenience that creates an instance of the {@link DatasetImageStats.Builder} avoiding the need to
         * create one manually via {@link DatasetImageStats#builder()}.
         *
         * When the {@link Consumer} completes, {@link DatasetImageStats.Builder#build()} is called immediately and its
         * result is passed to {@link #imageStats(DatasetImageStats)}.
         * 
         * @param imageStats
         *        a consumer that will call methods on {@link DatasetImageStats.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageStats(DatasetImageStats)
         */
        default Builder imageStats(Consumer<DatasetImageStats.Builder> imageStats) {
            return imageStats(DatasetImageStats.builder().applyMutation(imageStats).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String projectName;

        private String datasetType;

        private Instant creationTimestamp;

        private Instant lastUpdatedTimestamp;

        private String status;

        private String statusMessage;

        private DatasetImageStats imageStats;

        private BuilderImpl() {
        }

        private BuilderImpl(DatasetDescription model) {
            projectName(model.projectName);
            datasetType(model.datasetType);
            creationTimestamp(model.creationTimestamp);
            lastUpdatedTimestamp(model.lastUpdatedTimestamp);
            status(model.status);
            statusMessage(model.statusMessage);
            imageStats(model.imageStats);
        }

        public final String getProjectName() {
            return projectName;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @Override
        @Transient
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final String getDatasetType() {
            return datasetType;
        }

        public final void setDatasetType(String datasetType) {
            this.datasetType = datasetType;
        }

        @Override
        @Transient
        public final Builder datasetType(String datasetType) {
            this.datasetType = datasetType;
            return this;
        }

        public final Instant getCreationTimestamp() {
            return creationTimestamp;
        }

        public final void setCreationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        @Override
        @Transient
        public final Builder creationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public final Instant getLastUpdatedTimestamp() {
            return lastUpdatedTimestamp;
        }

        public final void setLastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
        }

        @Override
        @Transient
        public final Builder lastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(DatasetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        @Transient
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final DatasetImageStats.Builder getImageStats() {
            return imageStats != null ? imageStats.toBuilder() : null;
        }

        public final void setImageStats(DatasetImageStats.BuilderImpl imageStats) {
            this.imageStats = imageStats != null ? imageStats.build() : null;
        }

        @Override
        @Transient
        public final Builder imageStats(DatasetImageStats imageStats) {
            this.imageStats = imageStats;
            return this;
        }

        @Override
        public DatasetDescription build() {
            return new DatasetDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
