/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lookoutmetrics.model.DimensionListCopier;
import software.amazon.awssdk.services.lookoutmetrics.model.Frequency;
import software.amazon.awssdk.services.lookoutmetrics.model.LookoutMetricsRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.Metric;
import software.amazon.awssdk.services.lookoutmetrics.model.MetricListCopier;
import software.amazon.awssdk.services.lookoutmetrics.model.MetricSetDimensionFilter;
import software.amazon.awssdk.services.lookoutmetrics.model.MetricSetDimensionFilterListCopier;
import software.amazon.awssdk.services.lookoutmetrics.model.MetricSource;
import software.amazon.awssdk.services.lookoutmetrics.model.TimestampColumn;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateMetricSetRequest
extends LookoutMetricsRequest
implements ToCopyableBuilder<Builder, UpdateMetricSetRequest> {
    private static final SdkField<String> METRIC_SET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricSetArn").getter(UpdateMetricSetRequest.getter(UpdateMetricSetRequest::metricSetArn)).setter(UpdateMetricSetRequest.setter(Builder::metricSetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricSetArn").build()}).build();
    private static final SdkField<String> METRIC_SET_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricSetDescription").getter(UpdateMetricSetRequest.getter(UpdateMetricSetRequest::metricSetDescription)).setter(UpdateMetricSetRequest.setter(Builder::metricSetDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricSetDescription").build()}).build();
    private static final SdkField<List<Metric>> METRIC_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MetricList").getter(UpdateMetricSetRequest.getter(UpdateMetricSetRequest::metricList)).setter(UpdateMetricSetRequest.setter(Builder::metricList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Metric::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Offset").getter(UpdateMetricSetRequest.getter(UpdateMetricSetRequest::offset)).setter(UpdateMetricSetRequest.setter(Builder::offset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Offset").build()}).build();
    private static final SdkField<TimestampColumn> TIMESTAMP_COLUMN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TimestampColumn").getter(UpdateMetricSetRequest.getter(UpdateMetricSetRequest::timestampColumn)).setter(UpdateMetricSetRequest.setter(Builder::timestampColumn)).constructor(TimestampColumn::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimestampColumn").build()}).build();
    private static final SdkField<List<String>> DIMENSION_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DimensionList").getter(UpdateMetricSetRequest.getter(UpdateMetricSetRequest::dimensionList)).setter(UpdateMetricSetRequest.setter(Builder::dimensionList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DimensionList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> METRIC_SET_FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricSetFrequency").getter(UpdateMetricSetRequest.getter(UpdateMetricSetRequest::metricSetFrequencyAsString)).setter(UpdateMetricSetRequest.setter(Builder::metricSetFrequency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricSetFrequency").build()}).build();
    private static final SdkField<MetricSource> METRIC_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MetricSource").getter(UpdateMetricSetRequest.getter(UpdateMetricSetRequest::metricSource)).setter(UpdateMetricSetRequest.setter(Builder::metricSource)).constructor(MetricSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricSource").build()}).build();
    private static final SdkField<List<MetricSetDimensionFilter>> DIMENSION_FILTER_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DimensionFilterList").getter(UpdateMetricSetRequest.getter(UpdateMetricSetRequest::dimensionFilterList)).setter(UpdateMetricSetRequest.setter(Builder::dimensionFilterList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DimensionFilterList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricSetDimensionFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_SET_ARN_FIELD, METRIC_SET_DESCRIPTION_FIELD, METRIC_LIST_FIELD, OFFSET_FIELD, TIMESTAMP_COLUMN_FIELD, DIMENSION_LIST_FIELD, METRIC_SET_FREQUENCY_FIELD, METRIC_SOURCE_FIELD, DIMENSION_FILTER_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateMetricSetRequest.memberNameToFieldInitializer();
    private final String metricSetArn;
    private final String metricSetDescription;
    private final List<Metric> metricList;
    private final Integer offset;
    private final TimestampColumn timestampColumn;
    private final List<String> dimensionList;
    private final String metricSetFrequency;
    private final MetricSource metricSource;
    private final List<MetricSetDimensionFilter> dimensionFilterList;

    private UpdateMetricSetRequest(BuilderImpl builder) {
        super(builder);
        this.metricSetArn = builder.metricSetArn;
        this.metricSetDescription = builder.metricSetDescription;
        this.metricList = builder.metricList;
        this.offset = builder.offset;
        this.timestampColumn = builder.timestampColumn;
        this.dimensionList = builder.dimensionList;
        this.metricSetFrequency = builder.metricSetFrequency;
        this.metricSource = builder.metricSource;
        this.dimensionFilterList = builder.dimensionFilterList;
    }

    public final String metricSetArn() {
        return this.metricSetArn;
    }

    public final String metricSetDescription() {
        return this.metricSetDescription;
    }

    public final boolean hasMetricList() {
        return this.metricList != null && !(this.metricList instanceof SdkAutoConstructList);
    }

    public final List<Metric> metricList() {
        return this.metricList;
    }

    public final Integer offset() {
        return this.offset;
    }

    public final TimestampColumn timestampColumn() {
        return this.timestampColumn;
    }

    public final boolean hasDimensionList() {
        return this.dimensionList != null && !(this.dimensionList instanceof SdkAutoConstructList);
    }

    public final List<String> dimensionList() {
        return this.dimensionList;
    }

    public final Frequency metricSetFrequency() {
        return Frequency.fromValue(this.metricSetFrequency);
    }

    public final String metricSetFrequencyAsString() {
        return this.metricSetFrequency;
    }

    public final MetricSource metricSource() {
        return this.metricSource;
    }

    public final boolean hasDimensionFilterList() {
        return this.dimensionFilterList != null && !(this.dimensionFilterList instanceof SdkAutoConstructList);
    }

    public final List<MetricSetDimensionFilter> dimensionFilterList() {
        return this.dimensionFilterList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.metricSetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricSetDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricList() ? this.metricList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.offset());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestampColumn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDimensionList() ? this.dimensionList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.metricSetFrequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDimensionFilterList() ? this.dimensionFilterList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMetricSetRequest)) {
            return false;
        }
        UpdateMetricSetRequest other = (UpdateMetricSetRequest)((Object)obj);
        return Objects.equals(this.metricSetArn(), other.metricSetArn()) && Objects.equals(this.metricSetDescription(), other.metricSetDescription()) && this.hasMetricList() == other.hasMetricList() && Objects.equals(this.metricList(), other.metricList()) && Objects.equals(this.offset(), other.offset()) && Objects.equals(this.timestampColumn(), other.timestampColumn()) && this.hasDimensionList() == other.hasDimensionList() && Objects.equals(this.dimensionList(), other.dimensionList()) && Objects.equals(this.metricSetFrequencyAsString(), other.metricSetFrequencyAsString()) && Objects.equals(this.metricSource(), other.metricSource()) && this.hasDimensionFilterList() == other.hasDimensionFilterList() && Objects.equals(this.dimensionFilterList(), other.dimensionFilterList());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateMetricSetRequest").add("MetricSetArn", (Object)this.metricSetArn()).add("MetricSetDescription", (Object)this.metricSetDescription()).add("MetricList", this.hasMetricList() ? this.metricList() : null).add("Offset", (Object)this.offset()).add("TimestampColumn", (Object)this.timestampColumn()).add("DimensionList", this.hasDimensionList() ? this.dimensionList() : null).add("MetricSetFrequency", (Object)this.metricSetFrequencyAsString()).add("MetricSource", (Object)this.metricSource()).add("DimensionFilterList", this.hasDimensionFilterList() ? this.dimensionFilterList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MetricSetArn": {
                return Optional.ofNullable(clazz.cast(this.metricSetArn()));
            }
            case "MetricSetDescription": {
                return Optional.ofNullable(clazz.cast(this.metricSetDescription()));
            }
            case "MetricList": {
                return Optional.ofNullable(clazz.cast(this.metricList()));
            }
            case "Offset": {
                return Optional.ofNullable(clazz.cast(this.offset()));
            }
            case "TimestampColumn": {
                return Optional.ofNullable(clazz.cast(this.timestampColumn()));
            }
            case "DimensionList": {
                return Optional.ofNullable(clazz.cast(this.dimensionList()));
            }
            case "MetricSetFrequency": {
                return Optional.ofNullable(clazz.cast(this.metricSetFrequencyAsString()));
            }
            case "MetricSource": {
                return Optional.ofNullable(clazz.cast(this.metricSource()));
            }
            case "DimensionFilterList": {
                return Optional.ofNullable(clazz.cast(this.dimensionFilterList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MetricSetArn", METRIC_SET_ARN_FIELD);
        map.put("MetricSetDescription", METRIC_SET_DESCRIPTION_FIELD);
        map.put("MetricList", METRIC_LIST_FIELD);
        map.put("Offset", OFFSET_FIELD);
        map.put("TimestampColumn", TIMESTAMP_COLUMN_FIELD);
        map.put("DimensionList", DIMENSION_LIST_FIELD);
        map.put("MetricSetFrequency", METRIC_SET_FREQUENCY_FIELD);
        map.put("MetricSource", METRIC_SOURCE_FIELD);
        map.put("DimensionFilterList", DIMENSION_FILTER_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateMetricSetRequest, T> g) {
        return obj -> g.apply((UpdateMetricSetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LookoutMetricsRequest.BuilderImpl
    implements Builder {
        private String metricSetArn;
        private String metricSetDescription;
        private List<Metric> metricList = DefaultSdkAutoConstructList.getInstance();
        private Integer offset;
        private TimestampColumn timestampColumn;
        private List<String> dimensionList = DefaultSdkAutoConstructList.getInstance();
        private String metricSetFrequency;
        private MetricSource metricSource;
        private List<MetricSetDimensionFilter> dimensionFilterList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMetricSetRequest model) {
            super(model);
            this.metricSetArn(model.metricSetArn);
            this.metricSetDescription(model.metricSetDescription);
            this.metricList(model.metricList);
            this.offset(model.offset);
            this.timestampColumn(model.timestampColumn);
            this.dimensionList(model.dimensionList);
            this.metricSetFrequency(model.metricSetFrequency);
            this.metricSource(model.metricSource);
            this.dimensionFilterList(model.dimensionFilterList);
        }

        public final String getMetricSetArn() {
            return this.metricSetArn;
        }

        public final void setMetricSetArn(String metricSetArn) {
            this.metricSetArn = metricSetArn;
        }

        @Override
        public final Builder metricSetArn(String metricSetArn) {
            this.metricSetArn = metricSetArn;
            return this;
        }

        public final String getMetricSetDescription() {
            return this.metricSetDescription;
        }

        public final void setMetricSetDescription(String metricSetDescription) {
            this.metricSetDescription = metricSetDescription;
        }

        @Override
        public final Builder metricSetDescription(String metricSetDescription) {
            this.metricSetDescription = metricSetDescription;
            return this;
        }

        public final List<Metric.Builder> getMetricList() {
            List<Metric.Builder> result = MetricListCopier.copyToBuilder(this.metricList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricList(Collection<Metric.BuilderImpl> metricList) {
            this.metricList = MetricListCopier.copyFromBuilder(metricList);
        }

        @Override
        public final Builder metricList(Collection<Metric> metricList) {
            this.metricList = MetricListCopier.copy(metricList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricList(Metric ... metricList) {
            this.metricList(Arrays.asList(metricList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricList(Consumer<Metric.Builder> ... metricList) {
            this.metricList(Stream.of(metricList).map(c -> (Metric)((Metric.Builder)Metric.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getOffset() {
            return this.offset;
        }

        public final void setOffset(Integer offset) {
            this.offset = offset;
        }

        @Override
        public final Builder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public final TimestampColumn.Builder getTimestampColumn() {
            return this.timestampColumn != null ? this.timestampColumn.toBuilder() : null;
        }

        public final void setTimestampColumn(TimestampColumn.BuilderImpl timestampColumn) {
            this.timestampColumn = timestampColumn != null ? timestampColumn.build() : null;
        }

        @Override
        public final Builder timestampColumn(TimestampColumn timestampColumn) {
            this.timestampColumn = timestampColumn;
            return this;
        }

        public final Collection<String> getDimensionList() {
            if (this.dimensionList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dimensionList;
        }

        public final void setDimensionList(Collection<String> dimensionList) {
            this.dimensionList = DimensionListCopier.copy(dimensionList);
        }

        @Override
        public final Builder dimensionList(Collection<String> dimensionList) {
            this.dimensionList = DimensionListCopier.copy(dimensionList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensionList(String ... dimensionList) {
            this.dimensionList(Arrays.asList(dimensionList));
            return this;
        }

        public final String getMetricSetFrequency() {
            return this.metricSetFrequency;
        }

        public final void setMetricSetFrequency(String metricSetFrequency) {
            this.metricSetFrequency = metricSetFrequency;
        }

        @Override
        public final Builder metricSetFrequency(String metricSetFrequency) {
            this.metricSetFrequency = metricSetFrequency;
            return this;
        }

        @Override
        public final Builder metricSetFrequency(Frequency metricSetFrequency) {
            this.metricSetFrequency(metricSetFrequency == null ? null : metricSetFrequency.toString());
            return this;
        }

        public final MetricSource.Builder getMetricSource() {
            return this.metricSource != null ? this.metricSource.toBuilder() : null;
        }

        public final void setMetricSource(MetricSource.BuilderImpl metricSource) {
            this.metricSource = metricSource != null ? metricSource.build() : null;
        }

        @Override
        public final Builder metricSource(MetricSource metricSource) {
            this.metricSource = metricSource;
            return this;
        }

        public final List<MetricSetDimensionFilter.Builder> getDimensionFilterList() {
            List<MetricSetDimensionFilter.Builder> result = MetricSetDimensionFilterListCopier.copyToBuilder(this.dimensionFilterList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDimensionFilterList(Collection<MetricSetDimensionFilter.BuilderImpl> dimensionFilterList) {
            this.dimensionFilterList = MetricSetDimensionFilterListCopier.copyFromBuilder(dimensionFilterList);
        }

        @Override
        public final Builder dimensionFilterList(Collection<MetricSetDimensionFilter> dimensionFilterList) {
            this.dimensionFilterList = MetricSetDimensionFilterListCopier.copy(dimensionFilterList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensionFilterList(MetricSetDimensionFilter ... dimensionFilterList) {
            this.dimensionFilterList(Arrays.asList(dimensionFilterList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensionFilterList(Consumer<MetricSetDimensionFilter.Builder> ... dimensionFilterList) {
            this.dimensionFilterList(Stream.of(dimensionFilterList).map(c -> (MetricSetDimensionFilter)((MetricSetDimensionFilter.Builder)MetricSetDimensionFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMetricSetRequest build() {
            return new UpdateMetricSetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LookoutMetricsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateMetricSetRequest> {
        public Builder metricSetArn(String var1);

        public Builder metricSetDescription(String var1);

        public Builder metricList(Collection<Metric> var1);

        public Builder metricList(Metric ... var1);

        public Builder metricList(Consumer<Metric.Builder> ... var1);

        public Builder offset(Integer var1);

        public Builder timestampColumn(TimestampColumn var1);

        default public Builder timestampColumn(Consumer<TimestampColumn.Builder> timestampColumn) {
            return this.timestampColumn((TimestampColumn)((TimestampColumn.Builder)TimestampColumn.builder().applyMutation(timestampColumn)).build());
        }

        public Builder dimensionList(Collection<String> var1);

        public Builder dimensionList(String ... var1);

        public Builder metricSetFrequency(String var1);

        public Builder metricSetFrequency(Frequency var1);

        public Builder metricSource(MetricSource var1);

        default public Builder metricSource(Consumer<MetricSource.Builder> metricSource) {
            return this.metricSource((MetricSource)((MetricSource.Builder)MetricSource.builder().applyMutation(metricSource)).build());
        }

        public Builder dimensionFilterList(Collection<MetricSetDimensionFilter> var1);

        public Builder dimensionFilterList(MetricSetDimensionFilter ... var1);

        public Builder dimensionFilterList(Consumer<MetricSetDimensionFilter.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

