/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lookoutmetrics.model.Filter;
import software.amazon.awssdk.services.lookoutmetrics.model.FilterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetricSetDimensionFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MetricSetDimensionFilter> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(MetricSetDimensionFilter.getter(MetricSetDimensionFilter::name)).setter(MetricSetDimensionFilter.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<Filter>> FILTER_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FilterList").getter(MetricSetDimensionFilter.getter(MetricSetDimensionFilter::filterList)).setter(MetricSetDimensionFilter.setter(Builder::filterList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Filter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, FILTER_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MetricSetDimensionFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<Filter> filterList;

    private MetricSetDimensionFilter(BuilderImpl builder) {
        this.name = builder.name;
        this.filterList = builder.filterList;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasFilterList() {
        return this.filterList != null && !(this.filterList instanceof SdkAutoConstructList);
    }

    public final List<Filter> filterList() {
        return this.filterList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilterList() ? this.filterList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricSetDimensionFilter)) {
            return false;
        }
        MetricSetDimensionFilter other = (MetricSetDimensionFilter)obj;
        return Objects.equals(this.name(), other.name()) && this.hasFilterList() == other.hasFilterList() && Objects.equals(this.filterList(), other.filterList());
    }

    public final String toString() {
        return ToString.builder((String)"MetricSetDimensionFilter").add("Name", (Object)this.name()).add("FilterList", this.hasFilterList() ? this.filterList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "FilterList": {
                return Optional.ofNullable(clazz.cast(this.filterList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("FilterList", FILTER_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetricSetDimensionFilter, T> g) {
        return obj -> g.apply((MetricSetDimensionFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private List<Filter> filterList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MetricSetDimensionFilter model) {
            this.name(model.name);
            this.filterList(model.filterList);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<Filter.Builder> getFilterList() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filterList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilterList(Collection<Filter.BuilderImpl> filterList) {
            this.filterList = FilterListCopier.copyFromBuilder(filterList);
        }

        @Override
        public final Builder filterList(Collection<Filter> filterList) {
            this.filterList = FilterListCopier.copy(filterList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterList(Filter ... filterList) {
            this.filterList(Arrays.asList(filterList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterList(Consumer<Filter.Builder> ... filterList) {
            this.filterList(Stream.of(filterList).map(c -> (Filter)((Filter.Builder)Filter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public MetricSetDimensionFilter build() {
            return new MetricSetDimensionFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MetricSetDimensionFilter> {
        public Builder name(String var1);

        public Builder filterList(Collection<Filter> var1);

        public Builder filterList(Filter ... var1);

        public Builder filterList(Consumer<Filter.Builder> ... var1);
    }
}

