/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lookoutmetrics.model.DimensionFilter;
import software.amazon.awssdk.services.lookoutmetrics.model.DimensionFilterListCopier;
import software.amazon.awssdk.services.lookoutmetrics.model.MetricNameListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AlertFilters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AlertFilters> {
    private static final SdkField<List<String>> METRIC_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MetricList").getter(AlertFilters.getter(AlertFilters::metricList)).setter(AlertFilters.setter(Builder::metricList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DimensionFilter>> DIMENSION_FILTER_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DimensionFilterList").getter(AlertFilters.getter(AlertFilters::dimensionFilterList)).setter(AlertFilters.setter(Builder::dimensionFilterList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DimensionFilterList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DimensionFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_LIST_FIELD, DIMENSION_FILTER_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AlertFilters.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> metricList;
    private final List<DimensionFilter> dimensionFilterList;

    private AlertFilters(BuilderImpl builder) {
        this.metricList = builder.metricList;
        this.dimensionFilterList = builder.dimensionFilterList;
    }

    public final boolean hasMetricList() {
        return this.metricList != null && !(this.metricList instanceof SdkAutoConstructList);
    }

    public final List<String> metricList() {
        return this.metricList;
    }

    public final boolean hasDimensionFilterList() {
        return this.dimensionFilterList != null && !(this.dimensionFilterList instanceof SdkAutoConstructList);
    }

    public final List<DimensionFilter> dimensionFilterList() {
        return this.dimensionFilterList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricList() ? this.metricList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDimensionFilterList() ? this.dimensionFilterList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlertFilters)) {
            return false;
        }
        AlertFilters other = (AlertFilters)obj;
        return this.hasMetricList() == other.hasMetricList() && Objects.equals(this.metricList(), other.metricList()) && this.hasDimensionFilterList() == other.hasDimensionFilterList() && Objects.equals(this.dimensionFilterList(), other.dimensionFilterList());
    }

    public final String toString() {
        return ToString.builder((String)"AlertFilters").add("MetricList", this.hasMetricList() ? this.metricList() : null).add("DimensionFilterList", this.hasDimensionFilterList() ? this.dimensionFilterList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MetricList": {
                return Optional.ofNullable(clazz.cast(this.metricList()));
            }
            case "DimensionFilterList": {
                return Optional.ofNullable(clazz.cast(this.dimensionFilterList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MetricList", METRIC_LIST_FIELD);
        map.put("DimensionFilterList", DIMENSION_FILTER_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AlertFilters, T> g) {
        return obj -> g.apply((AlertFilters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> metricList = DefaultSdkAutoConstructList.getInstance();
        private List<DimensionFilter> dimensionFilterList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AlertFilters model) {
            this.metricList(model.metricList);
            this.dimensionFilterList(model.dimensionFilterList);
        }

        public final Collection<String> getMetricList() {
            if (this.metricList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.metricList;
        }

        public final void setMetricList(Collection<String> metricList) {
            this.metricList = MetricNameListCopier.copy(metricList);
        }

        @Override
        public final Builder metricList(Collection<String> metricList) {
            this.metricList = MetricNameListCopier.copy(metricList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricList(String ... metricList) {
            this.metricList(Arrays.asList(metricList));
            return this;
        }

        public final List<DimensionFilter.Builder> getDimensionFilterList() {
            List<DimensionFilter.Builder> result = DimensionFilterListCopier.copyToBuilder(this.dimensionFilterList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDimensionFilterList(Collection<DimensionFilter.BuilderImpl> dimensionFilterList) {
            this.dimensionFilterList = DimensionFilterListCopier.copyFromBuilder(dimensionFilterList);
        }

        @Override
        public final Builder dimensionFilterList(Collection<DimensionFilter> dimensionFilterList) {
            this.dimensionFilterList = DimensionFilterListCopier.copy(dimensionFilterList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensionFilterList(DimensionFilter ... dimensionFilterList) {
            this.dimensionFilterList(Arrays.asList(dimensionFilterList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensionFilterList(Consumer<DimensionFilter.Builder> ... dimensionFilterList) {
            this.dimensionFilterList(Stream.of(dimensionFilterList).map(c -> (DimensionFilter)((DimensionFilter.Builder)DimensionFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AlertFilters build() {
            return new AlertFilters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AlertFilters> {
        public Builder metricList(Collection<String> var1);

        public Builder metricList(String ... var1);

        public Builder dimensionFilterList(Collection<DimensionFilter> var1);

        public Builder dimensionFilterList(DimensionFilter ... var1);

        public Builder dimensionFilterList(Consumer<DimensionFilter.Builder> ... var1);
    }
}

