/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lookoutequipment.model.LookoutEquipmentResponse;
import software.amazon.awssdk.services.lookoutequipment.model.ModelVersionSummariesCopier;
import software.amazon.awssdk.services.lookoutequipment.model.ModelVersionSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListModelVersionsResponse
extends LookoutEquipmentResponse
implements ToCopyableBuilder<Builder, ListModelVersionsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListModelVersionsResponse.getter(ListModelVersionsResponse::nextToken)).setter(ListModelVersionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<ModelVersionSummary>> MODEL_VERSION_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ModelVersionSummaries").getter(ListModelVersionsResponse.getter(ListModelVersionsResponse::modelVersionSummaries)).setter(ListModelVersionsResponse.setter(Builder::modelVersionSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelVersionSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ModelVersionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, MODEL_VERSION_SUMMARIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListModelVersionsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<ModelVersionSummary> modelVersionSummaries;

    private ListModelVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.modelVersionSummaries = builder.modelVersionSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasModelVersionSummaries() {
        return this.modelVersionSummaries != null && !(this.modelVersionSummaries instanceof SdkAutoConstructList);
    }

    public final List<ModelVersionSummary> modelVersionSummaries() {
        return this.modelVersionSummaries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasModelVersionSummaries() ? this.modelVersionSummaries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListModelVersionsResponse)) {
            return false;
        }
        ListModelVersionsResponse other = (ListModelVersionsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasModelVersionSummaries() == other.hasModelVersionSummaries() && Objects.equals(this.modelVersionSummaries(), other.modelVersionSummaries());
    }

    public final String toString() {
        return ToString.builder((String)"ListModelVersionsResponse").add("NextToken", (Object)this.nextToken()).add("ModelVersionSummaries", this.hasModelVersionSummaries() ? this.modelVersionSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ModelVersionSummaries": {
                return Optional.ofNullable(clazz.cast(this.modelVersionSummaries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("ModelVersionSummaries", MODEL_VERSION_SUMMARIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListModelVersionsResponse, T> g) {
        return obj -> g.apply((ListModelVersionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LookoutEquipmentResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ModelVersionSummary> modelVersionSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListModelVersionsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.modelVersionSummaries(model.modelVersionSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ModelVersionSummary.Builder> getModelVersionSummaries() {
            List<ModelVersionSummary.Builder> result = ModelVersionSummariesCopier.copyToBuilder(this.modelVersionSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModelVersionSummaries(Collection<ModelVersionSummary.BuilderImpl> modelVersionSummaries) {
            this.modelVersionSummaries = ModelVersionSummariesCopier.copyFromBuilder(modelVersionSummaries);
        }

        @Override
        public final Builder modelVersionSummaries(Collection<ModelVersionSummary> modelVersionSummaries) {
            this.modelVersionSummaries = ModelVersionSummariesCopier.copy(modelVersionSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelVersionSummaries(ModelVersionSummary ... modelVersionSummaries) {
            this.modelVersionSummaries(Arrays.asList(modelVersionSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelVersionSummaries(Consumer<ModelVersionSummary.Builder> ... modelVersionSummaries) {
            this.modelVersionSummaries(Stream.of(modelVersionSummaries).map(c -> (ModelVersionSummary)((ModelVersionSummary.Builder)ModelVersionSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListModelVersionsResponse build() {
            return new ListModelVersionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LookoutEquipmentResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListModelVersionsResponse> {
        public Builder nextToken(String var1);

        public Builder modelVersionSummaries(Collection<ModelVersionSummary> var1);

        public Builder modelVersionSummaries(ModelVersionSummary ... var1);

        public Builder modelVersionSummaries(Consumer<ModelVersionSummary.Builder> ... var1);
    }
}

