/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lookoutequipment.model.LookoutEquipmentRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListLabelsRequest
extends LookoutEquipmentRequest
implements ToCopyableBuilder<Builder, ListLabelsRequest> {
    private static final SdkField<String> LABEL_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LabelGroupName").getter(ListLabelsRequest.getter(ListLabelsRequest::labelGroupName)).setter(ListLabelsRequest.setter(Builder::labelGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelGroupName").build()}).build();
    private static final SdkField<Instant> INTERVAL_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("IntervalStartTime").getter(ListLabelsRequest.getter(ListLabelsRequest::intervalStartTime)).setter(ListLabelsRequest.setter(Builder::intervalStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntervalStartTime").build()}).build();
    private static final SdkField<Instant> INTERVAL_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("IntervalEndTime").getter(ListLabelsRequest.getter(ListLabelsRequest::intervalEndTime)).setter(ListLabelsRequest.setter(Builder::intervalEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntervalEndTime").build()}).build();
    private static final SdkField<String> FAULT_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FaultCode").getter(ListLabelsRequest.getter(ListLabelsRequest::faultCode)).setter(ListLabelsRequest.setter(Builder::faultCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaultCode").build()}).build();
    private static final SdkField<String> EQUIPMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Equipment").getter(ListLabelsRequest.getter(ListLabelsRequest::equipment)).setter(ListLabelsRequest.setter(Builder::equipment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Equipment").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListLabelsRequest.getter(ListLabelsRequest::nextToken)).setter(ListLabelsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListLabelsRequest.getter(ListLabelsRequest::maxResults)).setter(ListLabelsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LABEL_GROUP_NAME_FIELD, INTERVAL_START_TIME_FIELD, INTERVAL_END_TIME_FIELD, FAULT_CODE_FIELD, EQUIPMENT_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListLabelsRequest.memberNameToFieldInitializer();
    private final String labelGroupName;
    private final Instant intervalStartTime;
    private final Instant intervalEndTime;
    private final String faultCode;
    private final String equipment;
    private final String nextToken;
    private final Integer maxResults;

    private ListLabelsRequest(BuilderImpl builder) {
        super(builder);
        this.labelGroupName = builder.labelGroupName;
        this.intervalStartTime = builder.intervalStartTime;
        this.intervalEndTime = builder.intervalEndTime;
        this.faultCode = builder.faultCode;
        this.equipment = builder.equipment;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final String labelGroupName() {
        return this.labelGroupName;
    }

    public final Instant intervalStartTime() {
        return this.intervalStartTime;
    }

    public final Instant intervalEndTime() {
        return this.intervalEndTime;
    }

    public final String faultCode() {
        return this.faultCode;
    }

    public final String equipment() {
        return this.equipment;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.labelGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.intervalStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.intervalEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.faultCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.equipment());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLabelsRequest)) {
            return false;
        }
        ListLabelsRequest other = (ListLabelsRequest)((Object)obj);
        return Objects.equals(this.labelGroupName(), other.labelGroupName()) && Objects.equals(this.intervalStartTime(), other.intervalStartTime()) && Objects.equals(this.intervalEndTime(), other.intervalEndTime()) && Objects.equals(this.faultCode(), other.faultCode()) && Objects.equals(this.equipment(), other.equipment()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"ListLabelsRequest").add("LabelGroupName", (Object)this.labelGroupName()).add("IntervalStartTime", (Object)this.intervalStartTime()).add("IntervalEndTime", (Object)this.intervalEndTime()).add("FaultCode", (Object)this.faultCode()).add("Equipment", (Object)this.equipment()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LabelGroupName": {
                return Optional.ofNullable(clazz.cast(this.labelGroupName()));
            }
            case "IntervalStartTime": {
                return Optional.ofNullable(clazz.cast(this.intervalStartTime()));
            }
            case "IntervalEndTime": {
                return Optional.ofNullable(clazz.cast(this.intervalEndTime()));
            }
            case "FaultCode": {
                return Optional.ofNullable(clazz.cast(this.faultCode()));
            }
            case "Equipment": {
                return Optional.ofNullable(clazz.cast(this.equipment()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LabelGroupName", LABEL_GROUP_NAME_FIELD);
        map.put("IntervalStartTime", INTERVAL_START_TIME_FIELD);
        map.put("IntervalEndTime", INTERVAL_END_TIME_FIELD);
        map.put("FaultCode", FAULT_CODE_FIELD);
        map.put("Equipment", EQUIPMENT_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListLabelsRequest, T> g) {
        return obj -> g.apply((ListLabelsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LookoutEquipmentRequest.BuilderImpl
    implements Builder {
        private String labelGroupName;
        private Instant intervalStartTime;
        private Instant intervalEndTime;
        private String faultCode;
        private String equipment;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLabelsRequest model) {
            super(model);
            this.labelGroupName(model.labelGroupName);
            this.intervalStartTime(model.intervalStartTime);
            this.intervalEndTime(model.intervalEndTime);
            this.faultCode(model.faultCode);
            this.equipment(model.equipment);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getLabelGroupName() {
            return this.labelGroupName;
        }

        public final void setLabelGroupName(String labelGroupName) {
            this.labelGroupName = labelGroupName;
        }

        @Override
        public final Builder labelGroupName(String labelGroupName) {
            this.labelGroupName = labelGroupName;
            return this;
        }

        public final Instant getIntervalStartTime() {
            return this.intervalStartTime;
        }

        public final void setIntervalStartTime(Instant intervalStartTime) {
            this.intervalStartTime = intervalStartTime;
        }

        @Override
        public final Builder intervalStartTime(Instant intervalStartTime) {
            this.intervalStartTime = intervalStartTime;
            return this;
        }

        public final Instant getIntervalEndTime() {
            return this.intervalEndTime;
        }

        public final void setIntervalEndTime(Instant intervalEndTime) {
            this.intervalEndTime = intervalEndTime;
        }

        @Override
        public final Builder intervalEndTime(Instant intervalEndTime) {
            this.intervalEndTime = intervalEndTime;
            return this;
        }

        public final String getFaultCode() {
            return this.faultCode;
        }

        public final void setFaultCode(String faultCode) {
            this.faultCode = faultCode;
        }

        @Override
        public final Builder faultCode(String faultCode) {
            this.faultCode = faultCode;
            return this;
        }

        public final String getEquipment() {
            return this.equipment;
        }

        public final void setEquipment(String equipment) {
            this.equipment = equipment;
        }

        @Override
        public final Builder equipment(String equipment) {
            this.equipment = equipment;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListLabelsRequest build() {
            return new ListLabelsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LookoutEquipmentRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListLabelsRequest> {
        public Builder labelGroupName(String var1);

        public Builder intervalStartTime(Instant var1);

        public Builder intervalEndTime(Instant var1);

        public Builder faultCode(String var1);

        public Builder equipment(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

