/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lookoutequipment.model.LookoutEquipmentResponse;
import software.amazon.awssdk.services.lookoutequipment.model.ModelVersionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportModelVersionResponse
extends LookoutEquipmentResponse
implements ToCopyableBuilder<Builder, ImportModelVersionResponse> {
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelName").getter(ImportModelVersionResponse.getter(ImportModelVersionResponse::modelName)).setter(ImportModelVersionResponse.setter(Builder::modelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()}).build();
    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelArn").getter(ImportModelVersionResponse.getter(ImportModelVersionResponse::modelArn)).setter(ImportModelVersionResponse.setter(Builder::modelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelArn").build()}).build();
    private static final SdkField<String> MODEL_VERSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelVersionArn").getter(ImportModelVersionResponse.getter(ImportModelVersionResponse::modelVersionArn)).setter(ImportModelVersionResponse.setter(Builder::modelVersionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelVersionArn").build()}).build();
    private static final SdkField<Long> MODEL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ModelVersion").getter(ImportModelVersionResponse.getter(ImportModelVersionResponse::modelVersion)).setter(ImportModelVersionResponse.setter(Builder::modelVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelVersion").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ImportModelVersionResponse.getter(ImportModelVersionResponse::statusAsString)).setter(ImportModelVersionResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_NAME_FIELD, MODEL_ARN_FIELD, MODEL_VERSION_ARN_FIELD, MODEL_VERSION_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ImportModelVersionResponse.memberNameToFieldInitializer();
    private final String modelName;
    private final String modelArn;
    private final String modelVersionArn;
    private final Long modelVersion;
    private final String status;

    private ImportModelVersionResponse(BuilderImpl builder) {
        super(builder);
        this.modelName = builder.modelName;
        this.modelArn = builder.modelArn;
        this.modelVersionArn = builder.modelVersionArn;
        this.modelVersion = builder.modelVersion;
        this.status = builder.status;
    }

    public final String modelName() {
        return this.modelName;
    }

    public final String modelArn() {
        return this.modelArn;
    }

    public final String modelVersionArn() {
        return this.modelVersionArn;
    }

    public final Long modelVersion() {
        return this.modelVersion;
    }

    public final ModelVersionStatus status() {
        return ModelVersionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.modelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportModelVersionResponse)) {
            return false;
        }
        ImportModelVersionResponse other = (ImportModelVersionResponse)((Object)obj);
        return Objects.equals(this.modelName(), other.modelName()) && Objects.equals(this.modelArn(), other.modelArn()) && Objects.equals(this.modelVersionArn(), other.modelVersionArn()) && Objects.equals(this.modelVersion(), other.modelVersion()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ImportModelVersionResponse").add("ModelName", (Object)this.modelName()).add("ModelArn", (Object)this.modelArn()).add("ModelVersionArn", (Object)this.modelVersionArn()).add("ModelVersion", (Object)this.modelVersion()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelName": {
                return Optional.ofNullable(clazz.cast(this.modelName()));
            }
            case "ModelArn": {
                return Optional.ofNullable(clazz.cast(this.modelArn()));
            }
            case "ModelVersionArn": {
                return Optional.ofNullable(clazz.cast(this.modelVersionArn()));
            }
            case "ModelVersion": {
                return Optional.ofNullable(clazz.cast(this.modelVersion()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ModelName", MODEL_NAME_FIELD);
        map.put("ModelArn", MODEL_ARN_FIELD);
        map.put("ModelVersionArn", MODEL_VERSION_ARN_FIELD);
        map.put("ModelVersion", MODEL_VERSION_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImportModelVersionResponse, T> g) {
        return obj -> g.apply((ImportModelVersionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LookoutEquipmentResponse.BuilderImpl
    implements Builder {
        private String modelName;
        private String modelArn;
        private String modelVersionArn;
        private Long modelVersion;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportModelVersionResponse model) {
            super(model);
            this.modelName(model.modelName);
            this.modelArn(model.modelArn);
            this.modelVersionArn(model.modelVersionArn);
            this.modelVersion(model.modelVersion);
            this.status(model.status);
        }

        public final String getModelName() {
            return this.modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final String getModelArn() {
            return this.modelArn;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public final String getModelVersionArn() {
            return this.modelVersionArn;
        }

        public final void setModelVersionArn(String modelVersionArn) {
            this.modelVersionArn = modelVersionArn;
        }

        @Override
        public final Builder modelVersionArn(String modelVersionArn) {
            this.modelVersionArn = modelVersionArn;
            return this;
        }

        public final Long getModelVersion() {
            return this.modelVersion;
        }

        public final void setModelVersion(Long modelVersion) {
            this.modelVersion = modelVersion;
        }

        @Override
        public final Builder modelVersion(Long modelVersion) {
            this.modelVersion = modelVersion;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ModelVersionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public ImportModelVersionResponse build() {
            return new ImportModelVersionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LookoutEquipmentResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ImportModelVersionResponse> {
        public Builder modelName(String var1);

        public Builder modelArn(String var1);

        public Builder modelVersionArn(String var1);

        public Builder modelVersion(Long var1);

        public Builder status(String var1);

        public Builder status(ModelVersionStatus var1);
    }
}

