/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InferenceEventSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InferenceEventSummary> {
    private static final SdkField<String> INFERENCE_SCHEDULER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InferenceSchedulerArn").getter(InferenceEventSummary.getter(InferenceEventSummary::inferenceSchedulerArn)).setter(InferenceEventSummary.setter(Builder::inferenceSchedulerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceSchedulerArn").build()}).build();
    private static final SdkField<String> INFERENCE_SCHEDULER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InferenceSchedulerName").getter(InferenceEventSummary.getter(InferenceEventSummary::inferenceSchedulerName)).setter(InferenceEventSummary.setter(Builder::inferenceSchedulerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceSchedulerName").build()}).build();
    private static final SdkField<Instant> EVENT_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EventStartTime").getter(InferenceEventSummary.getter(InferenceEventSummary::eventStartTime)).setter(InferenceEventSummary.setter(Builder::eventStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventStartTime").build()}).build();
    private static final SdkField<Instant> EVENT_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EventEndTime").getter(InferenceEventSummary.getter(InferenceEventSummary::eventEndTime)).setter(InferenceEventSummary.setter(Builder::eventEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventEndTime").build()}).build();
    private static final SdkField<String> DIAGNOSTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Diagnostics").getter(InferenceEventSummary.getter(InferenceEventSummary::diagnostics)).setter(InferenceEventSummary.setter(Builder::diagnostics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Diagnostics").build()}).build();
    private static final SdkField<Long> EVENT_DURATION_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("EventDurationInSeconds").getter(InferenceEventSummary.getter(InferenceEventSummary::eventDurationInSeconds)).setter(InferenceEventSummary.setter(Builder::eventDurationInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventDurationInSeconds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INFERENCE_SCHEDULER_ARN_FIELD, INFERENCE_SCHEDULER_NAME_FIELD, EVENT_START_TIME_FIELD, EVENT_END_TIME_FIELD, DIAGNOSTICS_FIELD, EVENT_DURATION_IN_SECONDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InferenceEventSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String inferenceSchedulerArn;
    private final String inferenceSchedulerName;
    private final Instant eventStartTime;
    private final Instant eventEndTime;
    private final String diagnostics;
    private final Long eventDurationInSeconds;

    private InferenceEventSummary(BuilderImpl builder) {
        this.inferenceSchedulerArn = builder.inferenceSchedulerArn;
        this.inferenceSchedulerName = builder.inferenceSchedulerName;
        this.eventStartTime = builder.eventStartTime;
        this.eventEndTime = builder.eventEndTime;
        this.diagnostics = builder.diagnostics;
        this.eventDurationInSeconds = builder.eventDurationInSeconds;
    }

    public final String inferenceSchedulerArn() {
        return this.inferenceSchedulerArn;
    }

    public final String inferenceSchedulerName() {
        return this.inferenceSchedulerName;
    }

    public final Instant eventStartTime() {
        return this.eventStartTime;
    }

    public final Instant eventEndTime() {
        return this.eventEndTime;
    }

    public final String diagnostics() {
        return this.diagnostics;
    }

    public final Long eventDurationInSeconds() {
        return this.eventDurationInSeconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceSchedulerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceSchedulerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.diagnostics());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventDurationInSeconds());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InferenceEventSummary)) {
            return false;
        }
        InferenceEventSummary other = (InferenceEventSummary)obj;
        return Objects.equals(this.inferenceSchedulerArn(), other.inferenceSchedulerArn()) && Objects.equals(this.inferenceSchedulerName(), other.inferenceSchedulerName()) && Objects.equals(this.eventStartTime(), other.eventStartTime()) && Objects.equals(this.eventEndTime(), other.eventEndTime()) && Objects.equals(this.diagnostics(), other.diagnostics()) && Objects.equals(this.eventDurationInSeconds(), other.eventDurationInSeconds());
    }

    public final String toString() {
        return ToString.builder((String)"InferenceEventSummary").add("InferenceSchedulerArn", (Object)this.inferenceSchedulerArn()).add("InferenceSchedulerName", (Object)this.inferenceSchedulerName()).add("EventStartTime", (Object)this.eventStartTime()).add("EventEndTime", (Object)this.eventEndTime()).add("Diagnostics", (Object)this.diagnostics()).add("EventDurationInSeconds", (Object)this.eventDurationInSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InferenceSchedulerArn": {
                return Optional.ofNullable(clazz.cast(this.inferenceSchedulerArn()));
            }
            case "InferenceSchedulerName": {
                return Optional.ofNullable(clazz.cast(this.inferenceSchedulerName()));
            }
            case "EventStartTime": {
                return Optional.ofNullable(clazz.cast(this.eventStartTime()));
            }
            case "EventEndTime": {
                return Optional.ofNullable(clazz.cast(this.eventEndTime()));
            }
            case "Diagnostics": {
                return Optional.ofNullable(clazz.cast(this.diagnostics()));
            }
            case "EventDurationInSeconds": {
                return Optional.ofNullable(clazz.cast(this.eventDurationInSeconds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InferenceSchedulerArn", INFERENCE_SCHEDULER_ARN_FIELD);
        map.put("InferenceSchedulerName", INFERENCE_SCHEDULER_NAME_FIELD);
        map.put("EventStartTime", EVENT_START_TIME_FIELD);
        map.put("EventEndTime", EVENT_END_TIME_FIELD);
        map.put("Diagnostics", DIAGNOSTICS_FIELD);
        map.put("EventDurationInSeconds", EVENT_DURATION_IN_SECONDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InferenceEventSummary, T> g) {
        return obj -> g.apply((InferenceEventSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String inferenceSchedulerArn;
        private String inferenceSchedulerName;
        private Instant eventStartTime;
        private Instant eventEndTime;
        private String diagnostics;
        private Long eventDurationInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(InferenceEventSummary model) {
            this.inferenceSchedulerArn(model.inferenceSchedulerArn);
            this.inferenceSchedulerName(model.inferenceSchedulerName);
            this.eventStartTime(model.eventStartTime);
            this.eventEndTime(model.eventEndTime);
            this.diagnostics(model.diagnostics);
            this.eventDurationInSeconds(model.eventDurationInSeconds);
        }

        public final String getInferenceSchedulerArn() {
            return this.inferenceSchedulerArn;
        }

        public final void setInferenceSchedulerArn(String inferenceSchedulerArn) {
            this.inferenceSchedulerArn = inferenceSchedulerArn;
        }

        @Override
        public final Builder inferenceSchedulerArn(String inferenceSchedulerArn) {
            this.inferenceSchedulerArn = inferenceSchedulerArn;
            return this;
        }

        public final String getInferenceSchedulerName() {
            return this.inferenceSchedulerName;
        }

        public final void setInferenceSchedulerName(String inferenceSchedulerName) {
            this.inferenceSchedulerName = inferenceSchedulerName;
        }

        @Override
        public final Builder inferenceSchedulerName(String inferenceSchedulerName) {
            this.inferenceSchedulerName = inferenceSchedulerName;
            return this;
        }

        public final Instant getEventStartTime() {
            return this.eventStartTime;
        }

        public final void setEventStartTime(Instant eventStartTime) {
            this.eventStartTime = eventStartTime;
        }

        @Override
        public final Builder eventStartTime(Instant eventStartTime) {
            this.eventStartTime = eventStartTime;
            return this;
        }

        public final Instant getEventEndTime() {
            return this.eventEndTime;
        }

        public final void setEventEndTime(Instant eventEndTime) {
            this.eventEndTime = eventEndTime;
        }

        @Override
        public final Builder eventEndTime(Instant eventEndTime) {
            this.eventEndTime = eventEndTime;
            return this;
        }

        public final String getDiagnostics() {
            return this.diagnostics;
        }

        public final void setDiagnostics(String diagnostics) {
            this.diagnostics = diagnostics;
        }

        @Override
        public final Builder diagnostics(String diagnostics) {
            this.diagnostics = diagnostics;
            return this;
        }

        public final Long getEventDurationInSeconds() {
            return this.eventDurationInSeconds;
        }

        public final void setEventDurationInSeconds(Long eventDurationInSeconds) {
            this.eventDurationInSeconds = eventDurationInSeconds;
        }

        @Override
        public final Builder eventDurationInSeconds(Long eventDurationInSeconds) {
            this.eventDurationInSeconds = eventDurationInSeconds;
            return this;
        }

        public InferenceEventSummary build() {
            return new InferenceEventSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InferenceEventSummary> {
        public Builder inferenceSchedulerArn(String var1);

        public Builder inferenceSchedulerName(String var1);

        public Builder eventStartTime(Instant var1);

        public Builder eventEndTime(Instant var1);

        public Builder diagnostics(String var1);

        public Builder eventDurationInSeconds(Long var1);
    }
}

