/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lookoutequipment.model.LabelsInputConfiguration;
import software.amazon.awssdk.services.lookoutequipment.model.LookoutEquipmentRequest;
import software.amazon.awssdk.services.lookoutequipment.model.ModelDiagnosticsOutputConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateModelRequest
extends LookoutEquipmentRequest
implements ToCopyableBuilder<Builder, UpdateModelRequest> {
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelName").getter(UpdateModelRequest.getter(UpdateModelRequest::modelName)).setter(UpdateModelRequest.setter(Builder::modelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()}).build();
    private static final SdkField<LabelsInputConfiguration> LABELS_INPUT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LabelsInputConfiguration").getter(UpdateModelRequest.getter(UpdateModelRequest::labelsInputConfiguration)).setter(UpdateModelRequest.setter(Builder::labelsInputConfiguration)).constructor(LabelsInputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelsInputConfiguration").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(UpdateModelRequest.getter(UpdateModelRequest::roleArn)).setter(UpdateModelRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<ModelDiagnosticsOutputConfiguration> MODEL_DIAGNOSTICS_OUTPUT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModelDiagnosticsOutputConfiguration").getter(UpdateModelRequest.getter(UpdateModelRequest::modelDiagnosticsOutputConfiguration)).setter(UpdateModelRequest.setter(Builder::modelDiagnosticsOutputConfiguration)).constructor(ModelDiagnosticsOutputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelDiagnosticsOutputConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_NAME_FIELD, LABELS_INPUT_CONFIGURATION_FIELD, ROLE_ARN_FIELD, MODEL_DIAGNOSTICS_OUTPUT_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateModelRequest.memberNameToFieldInitializer();
    private final String modelName;
    private final LabelsInputConfiguration labelsInputConfiguration;
    private final String roleArn;
    private final ModelDiagnosticsOutputConfiguration modelDiagnosticsOutputConfiguration;

    private UpdateModelRequest(BuilderImpl builder) {
        super(builder);
        this.modelName = builder.modelName;
        this.labelsInputConfiguration = builder.labelsInputConfiguration;
        this.roleArn = builder.roleArn;
        this.modelDiagnosticsOutputConfiguration = builder.modelDiagnosticsOutputConfiguration;
    }

    public final String modelName() {
        return this.modelName;
    }

    public final LabelsInputConfiguration labelsInputConfiguration() {
        return this.labelsInputConfiguration;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final ModelDiagnosticsOutputConfiguration modelDiagnosticsOutputConfiguration() {
        return this.modelDiagnosticsOutputConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.modelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.labelsInputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelDiagnosticsOutputConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateModelRequest)) {
            return false;
        }
        UpdateModelRequest other = (UpdateModelRequest)((Object)obj);
        return Objects.equals(this.modelName(), other.modelName()) && Objects.equals(this.labelsInputConfiguration(), other.labelsInputConfiguration()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.modelDiagnosticsOutputConfiguration(), other.modelDiagnosticsOutputConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateModelRequest").add("ModelName", (Object)this.modelName()).add("LabelsInputConfiguration", (Object)this.labelsInputConfiguration()).add("RoleArn", (Object)this.roleArn()).add("ModelDiagnosticsOutputConfiguration", (Object)this.modelDiagnosticsOutputConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelName": {
                return Optional.ofNullable(clazz.cast(this.modelName()));
            }
            case "LabelsInputConfiguration": {
                return Optional.ofNullable(clazz.cast(this.labelsInputConfiguration()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "ModelDiagnosticsOutputConfiguration": {
                return Optional.ofNullable(clazz.cast(this.modelDiagnosticsOutputConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ModelName", MODEL_NAME_FIELD);
        map.put("LabelsInputConfiguration", LABELS_INPUT_CONFIGURATION_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("ModelDiagnosticsOutputConfiguration", MODEL_DIAGNOSTICS_OUTPUT_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateModelRequest, T> g) {
        return obj -> g.apply((UpdateModelRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LookoutEquipmentRequest.BuilderImpl
    implements Builder {
        private String modelName;
        private LabelsInputConfiguration labelsInputConfiguration;
        private String roleArn;
        private ModelDiagnosticsOutputConfiguration modelDiagnosticsOutputConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateModelRequest model) {
            super(model);
            this.modelName(model.modelName);
            this.labelsInputConfiguration(model.labelsInputConfiguration);
            this.roleArn(model.roleArn);
            this.modelDiagnosticsOutputConfiguration(model.modelDiagnosticsOutputConfiguration);
        }

        public final String getModelName() {
            return this.modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final LabelsInputConfiguration.Builder getLabelsInputConfiguration() {
            return this.labelsInputConfiguration != null ? this.labelsInputConfiguration.toBuilder() : null;
        }

        public final void setLabelsInputConfiguration(LabelsInputConfiguration.BuilderImpl labelsInputConfiguration) {
            this.labelsInputConfiguration = labelsInputConfiguration != null ? labelsInputConfiguration.build() : null;
        }

        @Override
        public final Builder labelsInputConfiguration(LabelsInputConfiguration labelsInputConfiguration) {
            this.labelsInputConfiguration = labelsInputConfiguration;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final ModelDiagnosticsOutputConfiguration.Builder getModelDiagnosticsOutputConfiguration() {
            return this.modelDiagnosticsOutputConfiguration != null ? this.modelDiagnosticsOutputConfiguration.toBuilder() : null;
        }

        public final void setModelDiagnosticsOutputConfiguration(ModelDiagnosticsOutputConfiguration.BuilderImpl modelDiagnosticsOutputConfiguration) {
            this.modelDiagnosticsOutputConfiguration = modelDiagnosticsOutputConfiguration != null ? modelDiagnosticsOutputConfiguration.build() : null;
        }

        @Override
        public final Builder modelDiagnosticsOutputConfiguration(ModelDiagnosticsOutputConfiguration modelDiagnosticsOutputConfiguration) {
            this.modelDiagnosticsOutputConfiguration = modelDiagnosticsOutputConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateModelRequest build() {
            return new UpdateModelRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LookoutEquipmentRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateModelRequest> {
        public Builder modelName(String var1);

        public Builder labelsInputConfiguration(LabelsInputConfiguration var1);

        default public Builder labelsInputConfiguration(Consumer<LabelsInputConfiguration.Builder> labelsInputConfiguration) {
            return this.labelsInputConfiguration((LabelsInputConfiguration)((LabelsInputConfiguration.Builder)LabelsInputConfiguration.builder().applyMutation(labelsInputConfiguration)).build());
        }

        public Builder roleArn(String var1);

        public Builder modelDiagnosticsOutputConfiguration(ModelDiagnosticsOutputConfiguration var1);

        default public Builder modelDiagnosticsOutputConfiguration(Consumer<ModelDiagnosticsOutputConfiguration.Builder> modelDiagnosticsOutputConfiguration) {
            return this.modelDiagnosticsOutputConfiguration((ModelDiagnosticsOutputConfiguration)((ModelDiagnosticsOutputConfiguration.Builder)ModelDiagnosticsOutputConfiguration.builder().applyMutation(modelDiagnosticsOutputConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

