/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum StatisticalIssueStatus {
    POTENTIAL_ISSUE_DETECTED("POTENTIAL_ISSUE_DETECTED"),
    NO_ISSUE_DETECTED("NO_ISSUE_DETECTED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StatisticalIssueStatus> VALUE_MAP;
    private final String value;

    private StatisticalIssueStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StatisticalIssueStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StatisticalIssueStatus> knownValues() {
        EnumSet<StatisticalIssueStatus> knownValues = EnumSet.allOf(StatisticalIssueStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(StatisticalIssueStatus.class, StatisticalIssueStatus::toString);
    }
}

