/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lookoutequipment.LookoutEquipmentAsyncClient;
import software.amazon.awssdk.services.lookoutequipment.internal.UserAgentUtils;
import software.amazon.awssdk.services.lookoutequipment.model.ListInferenceSchedulersRequest;
import software.amazon.awssdk.services.lookoutequipment.model.ListInferenceSchedulersResponse;

public class ListInferenceSchedulersPublisher
implements SdkPublisher<ListInferenceSchedulersResponse> {
    private final LookoutEquipmentAsyncClient client;
    private final ListInferenceSchedulersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListInferenceSchedulersPublisher(LookoutEquipmentAsyncClient client, ListInferenceSchedulersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListInferenceSchedulersPublisher(LookoutEquipmentAsyncClient client, ListInferenceSchedulersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListInferenceSchedulersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListInferenceSchedulersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListInferenceSchedulersResponseFetcher
    implements AsyncPageFetcher<ListInferenceSchedulersResponse> {
        private ListInferenceSchedulersResponseFetcher() {
        }

        public boolean hasNextPage(ListInferenceSchedulersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListInferenceSchedulersResponse> nextPage(ListInferenceSchedulersResponse previousPage) {
            if (previousPage == null) {
                return ListInferenceSchedulersPublisher.this.client.listInferenceSchedulers(ListInferenceSchedulersPublisher.this.firstRequest);
            }
            return ListInferenceSchedulersPublisher.this.client.listInferenceSchedulers((ListInferenceSchedulersRequest)((Object)ListInferenceSchedulersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

