/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lookoutequipment.model.LookoutEquipmentResponse;
import software.amazon.awssdk.services.lookoutequipment.model.RetrainingSchedulerSummariesCopier;
import software.amazon.awssdk.services.lookoutequipment.model.RetrainingSchedulerSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRetrainingSchedulersResponse
extends LookoutEquipmentResponse
implements ToCopyableBuilder<Builder, ListRetrainingSchedulersResponse> {
    private static final SdkField<List<RetrainingSchedulerSummary>> RETRAINING_SCHEDULER_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RetrainingSchedulerSummaries").getter(ListRetrainingSchedulersResponse.getter(ListRetrainingSchedulersResponse::retrainingSchedulerSummaries)).setter(ListRetrainingSchedulersResponse.setter(Builder::retrainingSchedulerSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetrainingSchedulerSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RetrainingSchedulerSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListRetrainingSchedulersResponse.getter(ListRetrainingSchedulersResponse::nextToken)).setter(ListRetrainingSchedulersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RETRAINING_SCHEDULER_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListRetrainingSchedulersResponse.memberNameToFieldInitializer();
    private final List<RetrainingSchedulerSummary> retrainingSchedulerSummaries;
    private final String nextToken;

    private ListRetrainingSchedulersResponse(BuilderImpl builder) {
        super(builder);
        this.retrainingSchedulerSummaries = builder.retrainingSchedulerSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasRetrainingSchedulerSummaries() {
        return this.retrainingSchedulerSummaries != null && !(this.retrainingSchedulerSummaries instanceof SdkAutoConstructList);
    }

    public final List<RetrainingSchedulerSummary> retrainingSchedulerSummaries() {
        return this.retrainingSchedulerSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRetrainingSchedulerSummaries() ? this.retrainingSchedulerSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRetrainingSchedulersResponse)) {
            return false;
        }
        ListRetrainingSchedulersResponse other = (ListRetrainingSchedulersResponse)((Object)obj);
        return this.hasRetrainingSchedulerSummaries() == other.hasRetrainingSchedulerSummaries() && Objects.equals(this.retrainingSchedulerSummaries(), other.retrainingSchedulerSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListRetrainingSchedulersResponse").add("RetrainingSchedulerSummaries", this.hasRetrainingSchedulerSummaries() ? this.retrainingSchedulerSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RetrainingSchedulerSummaries": {
                return Optional.ofNullable(clazz.cast(this.retrainingSchedulerSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RetrainingSchedulerSummaries", RETRAINING_SCHEDULER_SUMMARIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRetrainingSchedulersResponse, T> g) {
        return obj -> g.apply((ListRetrainingSchedulersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LookoutEquipmentResponse.BuilderImpl
    implements Builder {
        private List<RetrainingSchedulerSummary> retrainingSchedulerSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRetrainingSchedulersResponse model) {
            super(model);
            this.retrainingSchedulerSummaries(model.retrainingSchedulerSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<RetrainingSchedulerSummary.Builder> getRetrainingSchedulerSummaries() {
            List<RetrainingSchedulerSummary.Builder> result = RetrainingSchedulerSummariesCopier.copyToBuilder(this.retrainingSchedulerSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRetrainingSchedulerSummaries(Collection<RetrainingSchedulerSummary.BuilderImpl> retrainingSchedulerSummaries) {
            this.retrainingSchedulerSummaries = RetrainingSchedulerSummariesCopier.copyFromBuilder(retrainingSchedulerSummaries);
        }

        @Override
        public final Builder retrainingSchedulerSummaries(Collection<RetrainingSchedulerSummary> retrainingSchedulerSummaries) {
            this.retrainingSchedulerSummaries = RetrainingSchedulerSummariesCopier.copy(retrainingSchedulerSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder retrainingSchedulerSummaries(RetrainingSchedulerSummary ... retrainingSchedulerSummaries) {
            this.retrainingSchedulerSummaries(Arrays.asList(retrainingSchedulerSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder retrainingSchedulerSummaries(Consumer<RetrainingSchedulerSummary.Builder> ... retrainingSchedulerSummaries) {
            this.retrainingSchedulerSummaries(Stream.of(retrainingSchedulerSummaries).map(c -> (RetrainingSchedulerSummary)((RetrainingSchedulerSummary.Builder)RetrainingSchedulerSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListRetrainingSchedulersResponse build() {
            return new ListRetrainingSchedulersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LookoutEquipmentResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRetrainingSchedulersResponse> {
        public Builder retrainingSchedulerSummaries(Collection<RetrainingSchedulerSummary> var1);

        public Builder retrainingSchedulerSummaries(RetrainingSchedulerSummary ... var1);

        public Builder retrainingSchedulerSummaries(Consumer<RetrainingSchedulerSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

