/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InferenceDataImportStrategy {
    NO_IMPORT("NO_IMPORT"),
    ADD_WHEN_EMPTY("ADD_WHEN_EMPTY"),
    OVERWRITE("OVERWRITE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InferenceDataImportStrategy> VALUE_MAP;
    private final String value;

    private InferenceDataImportStrategy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InferenceDataImportStrategy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InferenceDataImportStrategy> knownValues() {
        EnumSet<InferenceDataImportStrategy> knownValues = EnumSet.allOf(InferenceDataImportStrategy.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InferenceDataImportStrategy.class, InferenceDataImportStrategy::toString);
    }
}

