/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lookoutequipment.model.ModelDiagnosticsS3OutputConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModelDiagnosticsOutputConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ModelDiagnosticsOutputConfiguration> {
    private static final SdkField<ModelDiagnosticsS3OutputConfiguration> S3_OUTPUT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3OutputConfiguration").getter(ModelDiagnosticsOutputConfiguration.getter(ModelDiagnosticsOutputConfiguration::s3OutputConfiguration)).setter(ModelDiagnosticsOutputConfiguration.setter(Builder::s3OutputConfiguration)).constructor(ModelDiagnosticsS3OutputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3OutputConfiguration").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(ModelDiagnosticsOutputConfiguration.getter(ModelDiagnosticsOutputConfiguration::kmsKeyId)).setter(ModelDiagnosticsOutputConfiguration.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_OUTPUT_CONFIGURATION_FIELD, KMS_KEY_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final ModelDiagnosticsS3OutputConfiguration s3OutputConfiguration;
    private final String kmsKeyId;

    private ModelDiagnosticsOutputConfiguration(BuilderImpl builder) {
        this.s3OutputConfiguration = builder.s3OutputConfiguration;
        this.kmsKeyId = builder.kmsKeyId;
    }

    public final ModelDiagnosticsS3OutputConfiguration s3OutputConfiguration() {
        return this.s3OutputConfiguration;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3OutputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelDiagnosticsOutputConfiguration)) {
            return false;
        }
        ModelDiagnosticsOutputConfiguration other = (ModelDiagnosticsOutputConfiguration)obj;
        return Objects.equals(this.s3OutputConfiguration(), other.s3OutputConfiguration()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId());
    }

    public final String toString() {
        return ToString.builder((String)"ModelDiagnosticsOutputConfiguration").add("S3OutputConfiguration", (Object)this.s3OutputConfiguration()).add("KmsKeyId", (Object)this.kmsKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3OutputConfiguration": {
                return Optional.ofNullable(clazz.cast(this.s3OutputConfiguration()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModelDiagnosticsOutputConfiguration, T> g) {
        return obj -> g.apply((ModelDiagnosticsOutputConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ModelDiagnosticsS3OutputConfiguration s3OutputConfiguration;
        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelDiagnosticsOutputConfiguration model) {
            this.s3OutputConfiguration(model.s3OutputConfiguration);
            this.kmsKeyId(model.kmsKeyId);
        }

        public final ModelDiagnosticsS3OutputConfiguration.Builder getS3OutputConfiguration() {
            return this.s3OutputConfiguration != null ? this.s3OutputConfiguration.toBuilder() : null;
        }

        public final void setS3OutputConfiguration(ModelDiagnosticsS3OutputConfiguration.BuilderImpl s3OutputConfiguration) {
            this.s3OutputConfiguration = s3OutputConfiguration != null ? s3OutputConfiguration.build() : null;
        }

        @Override
        public final Builder s3OutputConfiguration(ModelDiagnosticsS3OutputConfiguration s3OutputConfiguration) {
            this.s3OutputConfiguration = s3OutputConfiguration;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public ModelDiagnosticsOutputConfiguration build() {
            return new ModelDiagnosticsOutputConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ModelDiagnosticsOutputConfiguration> {
        public Builder s3OutputConfiguration(ModelDiagnosticsS3OutputConfiguration var1);

        default public Builder s3OutputConfiguration(Consumer<ModelDiagnosticsS3OutputConfiguration.Builder> s3OutputConfiguration) {
            return this.s3OutputConfiguration((ModelDiagnosticsS3OutputConfiguration)((ModelDiagnosticsS3OutputConfiguration.Builder)ModelDiagnosticsS3OutputConfiguration.builder().applyMutation(s3OutputConfiguration)).build());
        }

        public Builder kmsKeyId(String var1);
    }
}

