/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.location.model.PositionCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchPlaceIndexForPositionSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SearchPlaceIndexForPositionSummary> {
    private static final SdkField<List<Double>> POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Position").getter(SearchPlaceIndexForPositionSummary.getter(SearchPlaceIndexForPositionSummary::position)).setter(SearchPlaceIndexForPositionSummary.setter(Builder::position)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Position").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(SearchPlaceIndexForPositionSummary.getter(SearchPlaceIndexForPositionSummary::maxResults)).setter(SearchPlaceIndexForPositionSummary.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSource").getter(SearchPlaceIndexForPositionSummary.getter(SearchPlaceIndexForPositionSummary::dataSource)).setter(SearchPlaceIndexForPositionSummary.setter(Builder::dataSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSource").build()}).build();
    private static final SdkField<String> LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Language").getter(SearchPlaceIndexForPositionSummary.getter(SearchPlaceIndexForPositionSummary::language)).setter(SearchPlaceIndexForPositionSummary.setter(Builder::language)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Language").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POSITION_FIELD, MAX_RESULTS_FIELD, DATA_SOURCE_FIELD, LANGUAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SearchPlaceIndexForPositionSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<Double> position;
    private final Integer maxResults;
    private final String dataSource;
    private final String language;

    private SearchPlaceIndexForPositionSummary(BuilderImpl builder) {
        this.position = builder.position;
        this.maxResults = builder.maxResults;
        this.dataSource = builder.dataSource;
        this.language = builder.language;
    }

    public final boolean hasPosition() {
        return this.position != null && !(this.position instanceof SdkAutoConstructList);
    }

    public final List<Double> position() {
        return this.position;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String dataSource() {
        return this.dataSource;
    }

    public final String language() {
        return this.language;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPosition() ? this.position() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.language());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchPlaceIndexForPositionSummary)) {
            return false;
        }
        SearchPlaceIndexForPositionSummary other = (SearchPlaceIndexForPositionSummary)obj;
        return this.hasPosition() == other.hasPosition() && Objects.equals(this.position(), other.position()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.dataSource(), other.dataSource()) && Objects.equals(this.language(), other.language());
    }

    public final String toString() {
        return ToString.builder((String)"SearchPlaceIndexForPositionSummary").add("Position", (Object)(this.position() == null ? null : "*** Sensitive Data Redacted ***")).add("MaxResults", (Object)this.maxResults()).add("DataSource", (Object)this.dataSource()).add("Language", (Object)this.language()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Position": {
                return Optional.ofNullable(clazz.cast(this.position()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "DataSource": {
                return Optional.ofNullable(clazz.cast(this.dataSource()));
            }
            case "Language": {
                return Optional.ofNullable(clazz.cast(this.language()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Position", POSITION_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("DataSource", DATA_SOURCE_FIELD);
        map.put("Language", LANGUAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchPlaceIndexForPositionSummary, T> g) {
        return obj -> g.apply((SearchPlaceIndexForPositionSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Double> position = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String dataSource;
        private String language;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchPlaceIndexForPositionSummary model) {
            this.position(model.position);
            this.maxResults(model.maxResults);
            this.dataSource(model.dataSource);
            this.language(model.language);
        }

        public final Collection<Double> getPosition() {
            if (this.position instanceof SdkAutoConstructList) {
                return null;
            }
            return this.position;
        }

        public final void setPosition(Collection<Double> position) {
            this.position = PositionCopier.copy(position);
        }

        @Override
        public final Builder position(Collection<Double> position) {
            this.position = PositionCopier.copy(position);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder position(Double ... position) {
            this.position(Arrays.asList(position));
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getDataSource() {
            return this.dataSource;
        }

        public final void setDataSource(String dataSource) {
            this.dataSource = dataSource;
        }

        @Override
        public final Builder dataSource(String dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final String getLanguage() {
            return this.language;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public SearchPlaceIndexForPositionSummary build() {
            return new SearchPlaceIndexForPositionSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SearchPlaceIndexForPositionSummary> {
        public Builder position(Collection<Double> var1);

        public Builder position(Double ... var1);

        public Builder maxResults(Integer var1);

        public Builder dataSource(String var1);

        public Builder language(String var1);
    }
}

