/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.location.model.DistanceUnit;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CalculateRouteMatrixSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CalculateRouteMatrixSummary> {
    private static final SdkField<String> DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSource").getter(CalculateRouteMatrixSummary.getter(CalculateRouteMatrixSummary::dataSource)).setter(CalculateRouteMatrixSummary.setter(Builder::dataSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSource").build()}).build();
    private static final SdkField<Integer> ROUTE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RouteCount").getter(CalculateRouteMatrixSummary.getter(CalculateRouteMatrixSummary::routeCount)).setter(CalculateRouteMatrixSummary.setter(Builder::routeCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteCount").build()}).build();
    private static final SdkField<Integer> ERROR_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ErrorCount").getter(CalculateRouteMatrixSummary.getter(CalculateRouteMatrixSummary::errorCount)).setter(CalculateRouteMatrixSummary.setter(Builder::errorCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCount").build()}).build();
    private static final SdkField<String> DISTANCE_UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DistanceUnit").getter(CalculateRouteMatrixSummary.getter(CalculateRouteMatrixSummary::distanceUnitAsString)).setter(CalculateRouteMatrixSummary.setter(Builder::distanceUnit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DistanceUnit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_FIELD, ROUTE_COUNT_FIELD, ERROR_COUNT_FIELD, DISTANCE_UNIT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CalculateRouteMatrixSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String dataSource;
    private final Integer routeCount;
    private final Integer errorCount;
    private final String distanceUnit;

    private CalculateRouteMatrixSummary(BuilderImpl builder) {
        this.dataSource = builder.dataSource;
        this.routeCount = builder.routeCount;
        this.errorCount = builder.errorCount;
        this.distanceUnit = builder.distanceUnit;
    }

    public final String dataSource() {
        return this.dataSource;
    }

    public final Integer routeCount() {
        return this.routeCount;
    }

    public final Integer errorCount() {
        return this.errorCount;
    }

    public final DistanceUnit distanceUnit() {
        return DistanceUnit.fromValue(this.distanceUnit);
    }

    public final String distanceUnitAsString() {
        return this.distanceUnit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.routeCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.distanceUnitAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CalculateRouteMatrixSummary)) {
            return false;
        }
        CalculateRouteMatrixSummary other = (CalculateRouteMatrixSummary)obj;
        return Objects.equals(this.dataSource(), other.dataSource()) && Objects.equals(this.routeCount(), other.routeCount()) && Objects.equals(this.errorCount(), other.errorCount()) && Objects.equals(this.distanceUnitAsString(), other.distanceUnitAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CalculateRouteMatrixSummary").add("DataSource", (Object)this.dataSource()).add("RouteCount", (Object)this.routeCount()).add("ErrorCount", (Object)this.errorCount()).add("DistanceUnit", (Object)this.distanceUnitAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataSource": {
                return Optional.ofNullable(clazz.cast(this.dataSource()));
            }
            case "RouteCount": {
                return Optional.ofNullable(clazz.cast(this.routeCount()));
            }
            case "ErrorCount": {
                return Optional.ofNullable(clazz.cast(this.errorCount()));
            }
            case "DistanceUnit": {
                return Optional.ofNullable(clazz.cast(this.distanceUnitAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DataSource", DATA_SOURCE_FIELD);
        map.put("RouteCount", ROUTE_COUNT_FIELD);
        map.put("ErrorCount", ERROR_COUNT_FIELD);
        map.put("DistanceUnit", DISTANCE_UNIT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CalculateRouteMatrixSummary, T> g) {
        return obj -> g.apply((CalculateRouteMatrixSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dataSource;
        private Integer routeCount;
        private Integer errorCount;
        private String distanceUnit;

        private BuilderImpl() {
        }

        private BuilderImpl(CalculateRouteMatrixSummary model) {
            this.dataSource(model.dataSource);
            this.routeCount(model.routeCount);
            this.errorCount(model.errorCount);
            this.distanceUnit(model.distanceUnit);
        }

        public final String getDataSource() {
            return this.dataSource;
        }

        public final void setDataSource(String dataSource) {
            this.dataSource = dataSource;
        }

        @Override
        public final Builder dataSource(String dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final Integer getRouteCount() {
            return this.routeCount;
        }

        public final void setRouteCount(Integer routeCount) {
            this.routeCount = routeCount;
        }

        @Override
        public final Builder routeCount(Integer routeCount) {
            this.routeCount = routeCount;
            return this;
        }

        public final Integer getErrorCount() {
            return this.errorCount;
        }

        public final void setErrorCount(Integer errorCount) {
            this.errorCount = errorCount;
        }

        @Override
        public final Builder errorCount(Integer errorCount) {
            this.errorCount = errorCount;
            return this;
        }

        public final String getDistanceUnit() {
            return this.distanceUnit;
        }

        public final void setDistanceUnit(String distanceUnit) {
            this.distanceUnit = distanceUnit;
        }

        @Override
        public final Builder distanceUnit(String distanceUnit) {
            this.distanceUnit = distanceUnit;
            return this;
        }

        @Override
        public final Builder distanceUnit(DistanceUnit distanceUnit) {
            this.distanceUnit(distanceUnit == null ? null : distanceUnit.toString());
            return this;
        }

        public CalculateRouteMatrixSummary build() {
            return new CalculateRouteMatrixSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CalculateRouteMatrixSummary> {
        public Builder dataSource(String var1);

        public Builder routeCount(Integer var1);

        public Builder errorCount(Integer var1);

        public Builder distanceUnit(String var1);

        public Builder distanceUnit(DistanceUnit var1);
    }
}

