/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.location.model.LocationRequest;
import software.amazon.awssdk.services.location.model.PositionFiltering;
import software.amazon.awssdk.services.location.model.PricingPlan;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateTrackerRequest
extends LocationRequest
implements ToCopyableBuilder<Builder, UpdateTrackerRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateTrackerRequest.getter(UpdateTrackerRequest::description)).setter(UpdateTrackerRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Boolean> EVENT_BRIDGE_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EventBridgeEnabled").getter(UpdateTrackerRequest.getter(UpdateTrackerRequest::eventBridgeEnabled)).setter(UpdateTrackerRequest.setter(Builder::eventBridgeEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventBridgeEnabled").build()}).build();
    private static final SdkField<Boolean> KMS_KEY_ENABLE_GEOSPATIAL_QUERIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("KmsKeyEnableGeospatialQueries").getter(UpdateTrackerRequest.getter(UpdateTrackerRequest::kmsKeyEnableGeospatialQueries)).setter(UpdateTrackerRequest.setter(Builder::kmsKeyEnableGeospatialQueries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyEnableGeospatialQueries").build()}).build();
    private static final SdkField<String> POSITION_FILTERING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PositionFiltering").getter(UpdateTrackerRequest.getter(UpdateTrackerRequest::positionFilteringAsString)).setter(UpdateTrackerRequest.setter(Builder::positionFiltering)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PositionFiltering").build()}).build();
    private static final SdkField<String> PRICING_PLAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PricingPlan").getter(UpdateTrackerRequest.getter(UpdateTrackerRequest::pricingPlanAsString)).setter(UpdateTrackerRequest.setter(Builder::pricingPlan)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PricingPlan").build()}).build();
    private static final SdkField<String> PRICING_PLAN_DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PricingPlanDataSource").getter(UpdateTrackerRequest.getter(UpdateTrackerRequest::pricingPlanDataSource)).setter(UpdateTrackerRequest.setter(Builder::pricingPlanDataSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PricingPlanDataSource").build()}).build();
    private static final SdkField<String> TRACKER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrackerName").getter(UpdateTrackerRequest.getter(UpdateTrackerRequest::trackerName)).setter(UpdateTrackerRequest.setter(Builder::trackerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("TrackerName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, EVENT_BRIDGE_ENABLED_FIELD, KMS_KEY_ENABLE_GEOSPATIAL_QUERIES_FIELD, POSITION_FILTERING_FIELD, PRICING_PLAN_FIELD, PRICING_PLAN_DATA_SOURCE_FIELD, TRACKER_NAME_FIELD));
    private final String description;
    private final Boolean eventBridgeEnabled;
    private final Boolean kmsKeyEnableGeospatialQueries;
    private final String positionFiltering;
    private final String pricingPlan;
    private final String pricingPlanDataSource;
    private final String trackerName;

    private UpdateTrackerRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.eventBridgeEnabled = builder.eventBridgeEnabled;
        this.kmsKeyEnableGeospatialQueries = builder.kmsKeyEnableGeospatialQueries;
        this.positionFiltering = builder.positionFiltering;
        this.pricingPlan = builder.pricingPlan;
        this.pricingPlanDataSource = builder.pricingPlanDataSource;
        this.trackerName = builder.trackerName;
    }

    public final String description() {
        return this.description;
    }

    public final Boolean eventBridgeEnabled() {
        return this.eventBridgeEnabled;
    }

    public final Boolean kmsKeyEnableGeospatialQueries() {
        return this.kmsKeyEnableGeospatialQueries;
    }

    public final PositionFiltering positionFiltering() {
        return PositionFiltering.fromValue(this.positionFiltering);
    }

    public final String positionFilteringAsString() {
        return this.positionFiltering;
    }

    @Deprecated
    public final PricingPlan pricingPlan() {
        return PricingPlan.fromValue(this.pricingPlan);
    }

    @Deprecated
    public final String pricingPlanAsString() {
        return this.pricingPlan;
    }

    @Deprecated
    public final String pricingPlanDataSource() {
        return this.pricingPlanDataSource;
    }

    public final String trackerName() {
        return this.trackerName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventBridgeEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyEnableGeospatialQueries());
        hashCode = 31 * hashCode + Objects.hashCode(this.positionFilteringAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.pricingPlanAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.pricingPlanDataSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.trackerName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTrackerRequest)) {
            return false;
        }
        UpdateTrackerRequest other = (UpdateTrackerRequest)((Object)obj);
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.eventBridgeEnabled(), other.eventBridgeEnabled()) && Objects.equals(this.kmsKeyEnableGeospatialQueries(), other.kmsKeyEnableGeospatialQueries()) && Objects.equals(this.positionFilteringAsString(), other.positionFilteringAsString()) && Objects.equals(this.pricingPlanAsString(), other.pricingPlanAsString()) && Objects.equals(this.pricingPlanDataSource(), other.pricingPlanDataSource()) && Objects.equals(this.trackerName(), other.trackerName());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateTrackerRequest").add("Description", (Object)this.description()).add("EventBridgeEnabled", (Object)this.eventBridgeEnabled()).add("KmsKeyEnableGeospatialQueries", (Object)this.kmsKeyEnableGeospatialQueries()).add("PositionFiltering", (Object)this.positionFilteringAsString()).add("PricingPlan", (Object)this.pricingPlanAsString()).add("PricingPlanDataSource", (Object)this.pricingPlanDataSource()).add("TrackerName", (Object)this.trackerName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "EventBridgeEnabled": {
                return Optional.ofNullable(clazz.cast(this.eventBridgeEnabled()));
            }
            case "KmsKeyEnableGeospatialQueries": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyEnableGeospatialQueries()));
            }
            case "PositionFiltering": {
                return Optional.ofNullable(clazz.cast(this.positionFilteringAsString()));
            }
            case "PricingPlan": {
                return Optional.ofNullable(clazz.cast(this.pricingPlanAsString()));
            }
            case "PricingPlanDataSource": {
                return Optional.ofNullable(clazz.cast(this.pricingPlanDataSource()));
            }
            case "TrackerName": {
                return Optional.ofNullable(clazz.cast(this.trackerName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTrackerRequest, T> g) {
        return obj -> g.apply((UpdateTrackerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LocationRequest.BuilderImpl
    implements Builder {
        private String description;
        private Boolean eventBridgeEnabled;
        private Boolean kmsKeyEnableGeospatialQueries;
        private String positionFiltering;
        private String pricingPlan;
        private String pricingPlanDataSource;
        private String trackerName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTrackerRequest model) {
            super(model);
            this.description(model.description);
            this.eventBridgeEnabled(model.eventBridgeEnabled);
            this.kmsKeyEnableGeospatialQueries(model.kmsKeyEnableGeospatialQueries);
            this.positionFiltering(model.positionFiltering);
            this.pricingPlan(model.pricingPlan);
            this.pricingPlanDataSource(model.pricingPlanDataSource);
            this.trackerName(model.trackerName);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getEventBridgeEnabled() {
            return this.eventBridgeEnabled;
        }

        public final void setEventBridgeEnabled(Boolean eventBridgeEnabled) {
            this.eventBridgeEnabled = eventBridgeEnabled;
        }

        @Override
        public final Builder eventBridgeEnabled(Boolean eventBridgeEnabled) {
            this.eventBridgeEnabled = eventBridgeEnabled;
            return this;
        }

        public final Boolean getKmsKeyEnableGeospatialQueries() {
            return this.kmsKeyEnableGeospatialQueries;
        }

        public final void setKmsKeyEnableGeospatialQueries(Boolean kmsKeyEnableGeospatialQueries) {
            this.kmsKeyEnableGeospatialQueries = kmsKeyEnableGeospatialQueries;
        }

        @Override
        public final Builder kmsKeyEnableGeospatialQueries(Boolean kmsKeyEnableGeospatialQueries) {
            this.kmsKeyEnableGeospatialQueries = kmsKeyEnableGeospatialQueries;
            return this;
        }

        public final String getPositionFiltering() {
            return this.positionFiltering;
        }

        public final void setPositionFiltering(String positionFiltering) {
            this.positionFiltering = positionFiltering;
        }

        @Override
        public final Builder positionFiltering(String positionFiltering) {
            this.positionFiltering = positionFiltering;
            return this;
        }

        @Override
        public final Builder positionFiltering(PositionFiltering positionFiltering) {
            this.positionFiltering(positionFiltering == null ? null : positionFiltering.toString());
            return this;
        }

        @Deprecated
        public final String getPricingPlan() {
            return this.pricingPlan;
        }

        @Deprecated
        public final void setPricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
        }

        @Override
        @Deprecated
        public final Builder pricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
            return this;
        }

        @Override
        @Deprecated
        public final Builder pricingPlan(PricingPlan pricingPlan) {
            this.pricingPlan(pricingPlan == null ? null : pricingPlan.toString());
            return this;
        }

        @Deprecated
        public final String getPricingPlanDataSource() {
            return this.pricingPlanDataSource;
        }

        @Deprecated
        public final void setPricingPlanDataSource(String pricingPlanDataSource) {
            this.pricingPlanDataSource = pricingPlanDataSource;
        }

        @Override
        @Deprecated
        public final Builder pricingPlanDataSource(String pricingPlanDataSource) {
            this.pricingPlanDataSource = pricingPlanDataSource;
            return this;
        }

        public final String getTrackerName() {
            return this.trackerName;
        }

        public final void setTrackerName(String trackerName) {
            this.trackerName = trackerName;
        }

        @Override
        public final Builder trackerName(String trackerName) {
            this.trackerName = trackerName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTrackerRequest build() {
            return new UpdateTrackerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LocationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateTrackerRequest> {
        public Builder description(String var1);

        public Builder eventBridgeEnabled(Boolean var1);

        public Builder kmsKeyEnableGeospatialQueries(Boolean var1);

        public Builder positionFiltering(String var1);

        public Builder positionFiltering(PositionFiltering var1);

        @Deprecated
        public Builder pricingPlan(String var1);

        @Deprecated
        public Builder pricingPlan(PricingPlan var1);

        @Deprecated
        public Builder pricingPlanDataSource(String var1);

        public Builder trackerName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

