/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.location.model.PlaceCategoryListCopier;
import software.amazon.awssdk.services.location.model.PlaceGeometry;
import software.amazon.awssdk.services.location.model.PlaceSupplementalCategoryListCopier;
import software.amazon.awssdk.services.location.model.TimeZone;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Place
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Place> {
    private static final SdkField<String> ADDRESS_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AddressNumber").getter(Place.getter(Place::addressNumber)).setter(Place.setter(Builder::addressNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressNumber").build()}).build();
    private static final SdkField<List<String>> CATEGORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Categories").getter(Place.getter(Place::categories)).setter(Place.setter(Builder::categories)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Categories").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> COUNTRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Country").getter(Place.getter(Place::country)).setter(Place.setter(Builder::country)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Country").build()}).build();
    private static final SdkField<PlaceGeometry> GEOMETRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Geometry").getter(Place.getter(Place::geometry)).setter(Place.setter(Builder::geometry)).constructor(PlaceGeometry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Geometry").build()}).build();
    private static final SdkField<Boolean> INTERPOLATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Interpolated").getter(Place.getter(Place::interpolated)).setter(Place.setter(Builder::interpolated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Interpolated").build()}).build();
    private static final SdkField<String> LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Label").getter(Place.getter(Place::label)).setter(Place.setter(Builder::label)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Label").build()}).build();
    private static final SdkField<String> MUNICIPALITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Municipality").getter(Place.getter(Place::municipality)).setter(Place.setter(Builder::municipality)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Municipality").build()}).build();
    private static final SdkField<String> NEIGHBORHOOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Neighborhood").getter(Place.getter(Place::neighborhood)).setter(Place.setter(Builder::neighborhood)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Neighborhood").build()}).build();
    private static final SdkField<String> POSTAL_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PostalCode").getter(Place.getter(Place::postalCode)).setter(Place.setter(Builder::postalCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostalCode").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Region").getter(Place.getter(Place::region)).setter(Place.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()}).build();
    private static final SdkField<String> STREET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Street").getter(Place.getter(Place::street)).setter(Place.setter(Builder::street)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Street").build()}).build();
    private static final SdkField<String> SUB_MUNICIPALITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubMunicipality").getter(Place.getter(Place::subMunicipality)).setter(Place.setter(Builder::subMunicipality)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubMunicipality").build()}).build();
    private static final SdkField<String> SUB_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubRegion").getter(Place.getter(Place::subRegion)).setter(Place.setter(Builder::subRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubRegion").build()}).build();
    private static final SdkField<List<String>> SUPPLEMENTAL_CATEGORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupplementalCategories").getter(Place.getter(Place::supplementalCategories)).setter(Place.setter(Builder::supplementalCategories)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupplementalCategories").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<TimeZone> TIME_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TimeZone").getter(Place.getter(Place::timeZone)).setter(Place.setter(Builder::timeZone)).constructor(TimeZone::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeZone").build()}).build();
    private static final SdkField<String> UNIT_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UnitNumber").getter(Place.getter(Place::unitNumber)).setter(Place.setter(Builder::unitNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnitNumber").build()}).build();
    private static final SdkField<String> UNIT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UnitType").getter(Place.getter(Place::unitType)).setter(Place.setter(Builder::unitType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnitType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDRESS_NUMBER_FIELD, CATEGORIES_FIELD, COUNTRY_FIELD, GEOMETRY_FIELD, INTERPOLATED_FIELD, LABEL_FIELD, MUNICIPALITY_FIELD, NEIGHBORHOOD_FIELD, POSTAL_CODE_FIELD, REGION_FIELD, STREET_FIELD, SUB_MUNICIPALITY_FIELD, SUB_REGION_FIELD, SUPPLEMENTAL_CATEGORIES_FIELD, TIME_ZONE_FIELD, UNIT_NUMBER_FIELD, UNIT_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String addressNumber;
    private final List<String> categories;
    private final String country;
    private final PlaceGeometry geometry;
    private final Boolean interpolated;
    private final String label;
    private final String municipality;
    private final String neighborhood;
    private final String postalCode;
    private final String region;
    private final String street;
    private final String subMunicipality;
    private final String subRegion;
    private final List<String> supplementalCategories;
    private final TimeZone timeZone;
    private final String unitNumber;
    private final String unitType;

    private Place(BuilderImpl builder) {
        this.addressNumber = builder.addressNumber;
        this.categories = builder.categories;
        this.country = builder.country;
        this.geometry = builder.geometry;
        this.interpolated = builder.interpolated;
        this.label = builder.label;
        this.municipality = builder.municipality;
        this.neighborhood = builder.neighborhood;
        this.postalCode = builder.postalCode;
        this.region = builder.region;
        this.street = builder.street;
        this.subMunicipality = builder.subMunicipality;
        this.subRegion = builder.subRegion;
        this.supplementalCategories = builder.supplementalCategories;
        this.timeZone = builder.timeZone;
        this.unitNumber = builder.unitNumber;
        this.unitType = builder.unitType;
    }

    public final String addressNumber() {
        return this.addressNumber;
    }

    public final boolean hasCategories() {
        return this.categories != null && !(this.categories instanceof SdkAutoConstructList);
    }

    public final List<String> categories() {
        return this.categories;
    }

    public final String country() {
        return this.country;
    }

    public final PlaceGeometry geometry() {
        return this.geometry;
    }

    public final Boolean interpolated() {
        return this.interpolated;
    }

    public final String label() {
        return this.label;
    }

    public final String municipality() {
        return this.municipality;
    }

    public final String neighborhood() {
        return this.neighborhood;
    }

    public final String postalCode() {
        return this.postalCode;
    }

    public final String region() {
        return this.region;
    }

    public final String street() {
        return this.street;
    }

    public final String subMunicipality() {
        return this.subMunicipality;
    }

    public final String subRegion() {
        return this.subRegion;
    }

    public final boolean hasSupplementalCategories() {
        return this.supplementalCategories != null && !(this.supplementalCategories instanceof SdkAutoConstructList);
    }

    public final List<String> supplementalCategories() {
        return this.supplementalCategories;
    }

    public final TimeZone timeZone() {
        return this.timeZone;
    }

    public final String unitNumber() {
        return this.unitNumber;
    }

    public final String unitType() {
        return this.unitType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.addressNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCategories() ? this.categories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.country());
        hashCode = 31 * hashCode + Objects.hashCode(this.geometry());
        hashCode = 31 * hashCode + Objects.hashCode(this.interpolated());
        hashCode = 31 * hashCode + Objects.hashCode(this.label());
        hashCode = 31 * hashCode + Objects.hashCode(this.municipality());
        hashCode = 31 * hashCode + Objects.hashCode(this.neighborhood());
        hashCode = 31 * hashCode + Objects.hashCode(this.postalCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.street());
        hashCode = 31 * hashCode + Objects.hashCode(this.subMunicipality());
        hashCode = 31 * hashCode + Objects.hashCode(this.subRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupplementalCategories() ? this.supplementalCategories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.timeZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.unitNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.unitType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Place)) {
            return false;
        }
        Place other = (Place)obj;
        return Objects.equals(this.addressNumber(), other.addressNumber()) && this.hasCategories() == other.hasCategories() && Objects.equals(this.categories(), other.categories()) && Objects.equals(this.country(), other.country()) && Objects.equals(this.geometry(), other.geometry()) && Objects.equals(this.interpolated(), other.interpolated()) && Objects.equals(this.label(), other.label()) && Objects.equals(this.municipality(), other.municipality()) && Objects.equals(this.neighborhood(), other.neighborhood()) && Objects.equals(this.postalCode(), other.postalCode()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.street(), other.street()) && Objects.equals(this.subMunicipality(), other.subMunicipality()) && Objects.equals(this.subRegion(), other.subRegion()) && this.hasSupplementalCategories() == other.hasSupplementalCategories() && Objects.equals(this.supplementalCategories(), other.supplementalCategories()) && Objects.equals(this.timeZone(), other.timeZone()) && Objects.equals(this.unitNumber(), other.unitNumber()) && Objects.equals(this.unitType(), other.unitType());
    }

    public final String toString() {
        return ToString.builder((String)"Place").add("AddressNumber", (Object)this.addressNumber()).add("Categories", this.hasCategories() ? this.categories() : null).add("Country", (Object)this.country()).add("Geometry", (Object)this.geometry()).add("Interpolated", (Object)this.interpolated()).add("Label", (Object)this.label()).add("Municipality", (Object)this.municipality()).add("Neighborhood", (Object)this.neighborhood()).add("PostalCode", (Object)this.postalCode()).add("Region", (Object)this.region()).add("Street", (Object)this.street()).add("SubMunicipality", (Object)this.subMunicipality()).add("SubRegion", (Object)this.subRegion()).add("SupplementalCategories", this.hasSupplementalCategories() ? this.supplementalCategories() : null).add("TimeZone", (Object)this.timeZone()).add("UnitNumber", (Object)this.unitNumber()).add("UnitType", (Object)this.unitType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AddressNumber": {
                return Optional.ofNullable(clazz.cast(this.addressNumber()));
            }
            case "Categories": {
                return Optional.ofNullable(clazz.cast(this.categories()));
            }
            case "Country": {
                return Optional.ofNullable(clazz.cast(this.country()));
            }
            case "Geometry": {
                return Optional.ofNullable(clazz.cast(this.geometry()));
            }
            case "Interpolated": {
                return Optional.ofNullable(clazz.cast(this.interpolated()));
            }
            case "Label": {
                return Optional.ofNullable(clazz.cast(this.label()));
            }
            case "Municipality": {
                return Optional.ofNullable(clazz.cast(this.municipality()));
            }
            case "Neighborhood": {
                return Optional.ofNullable(clazz.cast(this.neighborhood()));
            }
            case "PostalCode": {
                return Optional.ofNullable(clazz.cast(this.postalCode()));
            }
            case "Region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "Street": {
                return Optional.ofNullable(clazz.cast(this.street()));
            }
            case "SubMunicipality": {
                return Optional.ofNullable(clazz.cast(this.subMunicipality()));
            }
            case "SubRegion": {
                return Optional.ofNullable(clazz.cast(this.subRegion()));
            }
            case "SupplementalCategories": {
                return Optional.ofNullable(clazz.cast(this.supplementalCategories()));
            }
            case "TimeZone": {
                return Optional.ofNullable(clazz.cast(this.timeZone()));
            }
            case "UnitNumber": {
                return Optional.ofNullable(clazz.cast(this.unitNumber()));
            }
            case "UnitType": {
                return Optional.ofNullable(clazz.cast(this.unitType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Place, T> g) {
        return obj -> g.apply((Place)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String addressNumber;
        private List<String> categories = DefaultSdkAutoConstructList.getInstance();
        private String country;
        private PlaceGeometry geometry;
        private Boolean interpolated;
        private String label;
        private String municipality;
        private String neighborhood;
        private String postalCode;
        private String region;
        private String street;
        private String subMunicipality;
        private String subRegion;
        private List<String> supplementalCategories = DefaultSdkAutoConstructList.getInstance();
        private TimeZone timeZone;
        private String unitNumber;
        private String unitType;

        private BuilderImpl() {
        }

        private BuilderImpl(Place model) {
            this.addressNumber(model.addressNumber);
            this.categories(model.categories);
            this.country(model.country);
            this.geometry(model.geometry);
            this.interpolated(model.interpolated);
            this.label(model.label);
            this.municipality(model.municipality);
            this.neighborhood(model.neighborhood);
            this.postalCode(model.postalCode);
            this.region(model.region);
            this.street(model.street);
            this.subMunicipality(model.subMunicipality);
            this.subRegion(model.subRegion);
            this.supplementalCategories(model.supplementalCategories);
            this.timeZone(model.timeZone);
            this.unitNumber(model.unitNumber);
            this.unitType(model.unitType);
        }

        public final String getAddressNumber() {
            return this.addressNumber;
        }

        public final void setAddressNumber(String addressNumber) {
            this.addressNumber = addressNumber;
        }

        @Override
        public final Builder addressNumber(String addressNumber) {
            this.addressNumber = addressNumber;
            return this;
        }

        public final Collection<String> getCategories() {
            if (this.categories instanceof SdkAutoConstructList) {
                return null;
            }
            return this.categories;
        }

        public final void setCategories(Collection<String> categories) {
            this.categories = PlaceCategoryListCopier.copy(categories);
        }

        @Override
        public final Builder categories(Collection<String> categories) {
            this.categories = PlaceCategoryListCopier.copy(categories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categories(String ... categories) {
            this.categories(Arrays.asList(categories));
            return this;
        }

        public final String getCountry() {
            return this.country;
        }

        public final void setCountry(String country) {
            this.country = country;
        }

        @Override
        public final Builder country(String country) {
            this.country = country;
            return this;
        }

        public final PlaceGeometry.Builder getGeometry() {
            return this.geometry != null ? this.geometry.toBuilder() : null;
        }

        public final void setGeometry(PlaceGeometry.BuilderImpl geometry) {
            this.geometry = geometry != null ? geometry.build() : null;
        }

        @Override
        public final Builder geometry(PlaceGeometry geometry) {
            this.geometry = geometry;
            return this;
        }

        public final Boolean getInterpolated() {
            return this.interpolated;
        }

        public final void setInterpolated(Boolean interpolated) {
            this.interpolated = interpolated;
        }

        @Override
        public final Builder interpolated(Boolean interpolated) {
            this.interpolated = interpolated;
            return this;
        }

        public final String getLabel() {
            return this.label;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final String getMunicipality() {
            return this.municipality;
        }

        public final void setMunicipality(String municipality) {
            this.municipality = municipality;
        }

        @Override
        public final Builder municipality(String municipality) {
            this.municipality = municipality;
            return this;
        }

        public final String getNeighborhood() {
            return this.neighborhood;
        }

        public final void setNeighborhood(String neighborhood) {
            this.neighborhood = neighborhood;
        }

        @Override
        public final Builder neighborhood(String neighborhood) {
            this.neighborhood = neighborhood;
            return this;
        }

        public final String getPostalCode() {
            return this.postalCode;
        }

        public final void setPostalCode(String postalCode) {
            this.postalCode = postalCode;
        }

        @Override
        public final Builder postalCode(String postalCode) {
            this.postalCode = postalCode;
            return this;
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getStreet() {
            return this.street;
        }

        public final void setStreet(String street) {
            this.street = street;
        }

        @Override
        public final Builder street(String street) {
            this.street = street;
            return this;
        }

        public final String getSubMunicipality() {
            return this.subMunicipality;
        }

        public final void setSubMunicipality(String subMunicipality) {
            this.subMunicipality = subMunicipality;
        }

        @Override
        public final Builder subMunicipality(String subMunicipality) {
            this.subMunicipality = subMunicipality;
            return this;
        }

        public final String getSubRegion() {
            return this.subRegion;
        }

        public final void setSubRegion(String subRegion) {
            this.subRegion = subRegion;
        }

        @Override
        public final Builder subRegion(String subRegion) {
            this.subRegion = subRegion;
            return this;
        }

        public final Collection<String> getSupplementalCategories() {
            if (this.supplementalCategories instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supplementalCategories;
        }

        public final void setSupplementalCategories(Collection<String> supplementalCategories) {
            this.supplementalCategories = PlaceSupplementalCategoryListCopier.copy(supplementalCategories);
        }

        @Override
        public final Builder supplementalCategories(Collection<String> supplementalCategories) {
            this.supplementalCategories = PlaceSupplementalCategoryListCopier.copy(supplementalCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supplementalCategories(String ... supplementalCategories) {
            this.supplementalCategories(Arrays.asList(supplementalCategories));
            return this;
        }

        public final TimeZone.Builder getTimeZone() {
            return this.timeZone != null ? this.timeZone.toBuilder() : null;
        }

        public final void setTimeZone(TimeZone.BuilderImpl timeZone) {
            this.timeZone = timeZone != null ? timeZone.build() : null;
        }

        @Override
        public final Builder timeZone(TimeZone timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        public final String getUnitNumber() {
            return this.unitNumber;
        }

        public final void setUnitNumber(String unitNumber) {
            this.unitNumber = unitNumber;
        }

        @Override
        public final Builder unitNumber(String unitNumber) {
            this.unitNumber = unitNumber;
            return this;
        }

        public final String getUnitType() {
            return this.unitType;
        }

        public final void setUnitType(String unitType) {
            this.unitType = unitType;
        }

        @Override
        public final Builder unitType(String unitType) {
            this.unitType = unitType;
            return this;
        }

        public Place build() {
            return new Place(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Place> {
        public Builder addressNumber(String var1);

        public Builder categories(Collection<String> var1);

        public Builder categories(String ... var1);

        public Builder country(String var1);

        public Builder geometry(PlaceGeometry var1);

        default public Builder geometry(Consumer<PlaceGeometry.Builder> geometry) {
            return this.geometry((PlaceGeometry)((PlaceGeometry.Builder)PlaceGeometry.builder().applyMutation(geometry)).build());
        }

        public Builder interpolated(Boolean var1);

        public Builder label(String var1);

        public Builder municipality(String var1);

        public Builder neighborhood(String var1);

        public Builder postalCode(String var1);

        public Builder region(String var1);

        public Builder street(String var1);

        public Builder subMunicipality(String var1);

        public Builder subRegion(String var1);

        public Builder supplementalCategories(Collection<String> var1);

        public Builder supplementalCategories(String ... var1);

        public Builder timeZone(TimeZone var1);

        default public Builder timeZone(Consumer<TimeZone.Builder> timeZone) {
            return this.timeZone((TimeZone)((TimeZone.Builder)TimeZone.builder().applyMutation(timeZone)).build());
        }

        public Builder unitNumber(String var1);

        public Builder unitType(String var1);
    }
}

