/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the level of certainty of the position.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PositionalAccuracy implements SdkPojo, Serializable,
        ToCopyableBuilder<PositionalAccuracy.Builder, PositionalAccuracy> {
    private static final SdkField<Double> HORIZONTAL_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("Horizontal").getter(getter(PositionalAccuracy::horizontal)).setter(setter(Builder::horizontal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Horizontal").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HORIZONTAL_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double horizontal;

    private PositionalAccuracy(BuilderImpl builder) {
        this.horizontal = builder.horizontal;
    }

    /**
     * <p>
     * Estimated maximum distance, in meters, between the measured position and the true position of a device, along the
     * Earth's surface.
     * </p>
     * 
     * @return Estimated maximum distance, in meters, between the measured position and the true position of a device,
     *         along the Earth's surface.
     */
    public final Double horizontal() {
        return horizontal;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(horizontal());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PositionalAccuracy)) {
            return false;
        }
        PositionalAccuracy other = (PositionalAccuracy) obj;
        return Objects.equals(horizontal(), other.horizontal());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PositionalAccuracy").add("Horizontal", horizontal()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Horizontal":
            return Optional.ofNullable(clazz.cast(horizontal()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PositionalAccuracy, T> g) {
        return obj -> g.apply((PositionalAccuracy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PositionalAccuracy> {
        /**
         * <p>
         * Estimated maximum distance, in meters, between the measured position and the true position of a device, along
         * the Earth's surface.
         * </p>
         * 
         * @param horizontal
         *        Estimated maximum distance, in meters, between the measured position and the true position of a
         *        device, along the Earth's surface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder horizontal(Double horizontal);
    }

    static final class BuilderImpl implements Builder {
        private Double horizontal;

        private BuilderImpl() {
        }

        private BuilderImpl(PositionalAccuracy model) {
            horizontal(model.horizontal);
        }

        public final Double getHorizontal() {
            return horizontal;
        }

        public final void setHorizontal(Double horizontal) {
            this.horizontal = horizontal;
        }

        @Override
        @Transient
        public final Builder horizontal(Double horizontal) {
            this.horizontal = horizontal;
            return this;
        }

        @Override
        public PositionalAccuracy build() {
            return new PositionalAccuracy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
