/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetGeofenceRequest extends LocationRequest implements
        ToCopyableBuilder<GetGeofenceRequest.Builder, GetGeofenceRequest> {
    private static final SdkField<String> COLLECTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CollectionName").getter(getter(GetGeofenceRequest::collectionName))
            .setter(setter(Builder::collectionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("CollectionName").build()).build();

    private static final SdkField<String> GEOFENCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GeofenceId").getter(getter(GetGeofenceRequest::geofenceId)).setter(setter(Builder::geofenceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("GeofenceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLECTION_NAME_FIELD,
            GEOFENCE_ID_FIELD));

    private final String collectionName;

    private final String geofenceId;

    private GetGeofenceRequest(BuilderImpl builder) {
        super(builder);
        this.collectionName = builder.collectionName;
        this.geofenceId = builder.geofenceId;
    }

    /**
     * <p>
     * The geofence collection storing the target geofence.
     * </p>
     * 
     * @return The geofence collection storing the target geofence.
     */
    public final String collectionName() {
        return collectionName;
    }

    /**
     * <p>
     * The geofence you're retrieving details for.
     * </p>
     * 
     * @return The geofence you're retrieving details for.
     */
    public final String geofenceId() {
        return geofenceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(collectionName());
        hashCode = 31 * hashCode + Objects.hashCode(geofenceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetGeofenceRequest)) {
            return false;
        }
        GetGeofenceRequest other = (GetGeofenceRequest) obj;
        return Objects.equals(collectionName(), other.collectionName()) && Objects.equals(geofenceId(), other.geofenceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetGeofenceRequest").add("CollectionName", collectionName()).add("GeofenceId", geofenceId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CollectionName":
            return Optional.ofNullable(clazz.cast(collectionName()));
        case "GeofenceId":
            return Optional.ofNullable(clazz.cast(geofenceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetGeofenceRequest, T> g) {
        return obj -> g.apply((GetGeofenceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LocationRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetGeofenceRequest> {
        /**
         * <p>
         * The geofence collection storing the target geofence.
         * </p>
         * 
         * @param collectionName
         *        The geofence collection storing the target geofence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectionName(String collectionName);

        /**
         * <p>
         * The geofence you're retrieving details for.
         * </p>
         * 
         * @param geofenceId
         *        The geofence you're retrieving details for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder geofenceId(String geofenceId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LocationRequest.BuilderImpl implements Builder {
        private String collectionName;

        private String geofenceId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetGeofenceRequest model) {
            super(model);
            collectionName(model.collectionName);
            geofenceId(model.geofenceId);
        }

        public final String getCollectionName() {
            return collectionName;
        }

        public final void setCollectionName(String collectionName) {
            this.collectionName = collectionName;
        }

        @Override
        @Transient
        public final Builder collectionName(String collectionName) {
            this.collectionName = collectionName;
            return this;
        }

        public final String getGeofenceId() {
            return geofenceId;
        }

        public final void setGeofenceId(String geofenceId) {
            this.geofenceId = geofenceId;
        }

        @Override
        @Transient
        public final Builder geofenceId(String geofenceId) {
            this.geofenceId = geofenceId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetGeofenceRequest build() {
            return new GetGeofenceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
