/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateGeofenceCollectionRequest extends LocationRequest implements
        ToCopyableBuilder<CreateGeofenceCollectionRequest.Builder, CreateGeofenceCollectionRequest> {
    private static final SdkField<String> COLLECTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CollectionName").getter(getter(CreateGeofenceCollectionRequest::collectionName))
            .setter(setter(Builder::collectionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectionName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateGeofenceCollectionRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(CreateGeofenceCollectionRequest::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<String> PRICING_PLAN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PricingPlan").getter(getter(CreateGeofenceCollectionRequest::pricingPlanAsString))
            .setter(setter(Builder::pricingPlan))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PricingPlan").build()).build();

    private static final SdkField<String> PRICING_PLAN_DATA_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PricingPlanDataSource").getter(getter(CreateGeofenceCollectionRequest::pricingPlanDataSource))
            .setter(setter(Builder::pricingPlanDataSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PricingPlanDataSource").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateGeofenceCollectionRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLECTION_NAME_FIELD,
            DESCRIPTION_FIELD, KMS_KEY_ID_FIELD, PRICING_PLAN_FIELD, PRICING_PLAN_DATA_SOURCE_FIELD, TAGS_FIELD));

    private final String collectionName;

    private final String description;

    private final String kmsKeyId;

    private final String pricingPlan;

    private final String pricingPlanDataSource;

    private final Map<String, String> tags;

    private CreateGeofenceCollectionRequest(BuilderImpl builder) {
        super(builder);
        this.collectionName = builder.collectionName;
        this.description = builder.description;
        this.kmsKeyId = builder.kmsKeyId;
        this.pricingPlan = builder.pricingPlan;
        this.pricingPlanDataSource = builder.pricingPlanDataSource;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A custom name for the geofence collection.
     * </p>
     * <p>
     * Requirements:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and underscores (_).
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be a unique geofence collection name.
     * </p>
     * </li>
     * <li>
     * <p>
     * No spaces allowed. For example, <code>ExampleGeofenceCollection</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return A custom name for the geofence collection.</p>
     *         <p>
     *         Requirements:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and underscores (_).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must be a unique geofence collection name.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         No spaces allowed. For example, <code>ExampleGeofenceCollection</code>.
     *         </p>
     *         </li>
     */
    public final String collectionName() {
        return collectionName;
    }

    /**
     * <p>
     * An optional description for the geofence collection.
     * </p>
     * 
     * @return An optional description for the geofence collection.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * A key identifier for an <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html">AWS KMS
     * customer managed key</a>. Enter a key ID, key ARN, alias name, or alias ARN.
     * </p>
     * 
     * @return A key identifier for an <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html">AWS KMS customer managed
     *         key</a>. Enter a key ID, key ARN, alias name, or alias ARN.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * Optionally specifies the pricing plan for the geofence collection. Defaults to <code>RequestBasedUsage</code>.
     * </p>
     * <p>
     * For additional details and restrictions on each pricing plan option, see the <a
     * href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing page</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pricingPlan} will
     * return {@link PricingPlan#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pricingPlanAsString}.
     * </p>
     * 
     * @return Optionally specifies the pricing plan for the geofence collection. Defaults to
     *         <code>RequestBasedUsage</code>.</p>
     *         <p>
     *         For additional details and restrictions on each pricing plan option, see the <a
     *         href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing page</a>.
     * @see PricingPlan
     */
    public final PricingPlan pricingPlan() {
        return PricingPlan.fromValue(pricingPlan);
    }

    /**
     * <p>
     * Optionally specifies the pricing plan for the geofence collection. Defaults to <code>RequestBasedUsage</code>.
     * </p>
     * <p>
     * For additional details and restrictions on each pricing plan option, see the <a
     * href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing page</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pricingPlan} will
     * return {@link PricingPlan#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pricingPlanAsString}.
     * </p>
     * 
     * @return Optionally specifies the pricing plan for the geofence collection. Defaults to
     *         <code>RequestBasedUsage</code>.</p>
     *         <p>
     *         For additional details and restrictions on each pricing plan option, see the <a
     *         href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing page</a>.
     * @see PricingPlan
     */
    public final String pricingPlanAsString() {
        return pricingPlan;
    }

    /**
     * <p>
     * Specifies the data provider for the geofence collection.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Required value for the following pricing plans: <code>MobileAssetTracking </code>|
     * <code>MobileAssetManagement</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about <a href="https://aws.amazon.com/location/data-providers/">Data Providers</a>, and <a
     * href="https://aws.amazon.com/location/pricing/">Pricing plans</a>, see the Amazon Location Service product page.
     * </p>
     * <note>
     * <p>
     * Amazon Location Service only uses <code>PricingPlanDataSource</code> to calculate billing for your geofence
     * collection. Your data won't be shared with the data provider, and will remain in your AWS account or Region
     * unless you move it.
     * </p>
     * </note>
     * <p>
     * Valid Values: <code>Esri </code>| <code>Here</code>
     * </p>
     * 
     * @return Specifies the data provider for the geofence collection.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Required value for the following pricing plans: <code>MobileAssetTracking </code>|
     *         <code>MobileAssetManagement</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information about <a href="https://aws.amazon.com/location/data-providers/">Data Providers</a>,
     *         and <a href="https://aws.amazon.com/location/pricing/">Pricing plans</a>, see the Amazon Location Service
     *         product page.
     *         </p>
     *         <note>
     *         <p>
     *         Amazon Location Service only uses <code>PricingPlanDataSource</code> to calculate billing for your
     *         geofence collection. Your data won't be shared with the data provider, and will remain in your AWS
     *         account or Region unless you move it.
     *         </p>
     *         </note>
     *         <p>
     *         Valid Values: <code>Esri </code>| <code>Here</code>
     */
    public final String pricingPlanDataSource() {
        return pricingPlanDataSource;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Applies one or more tags to the geofence collection. A tag is a key-value pair helps manage, identify, search,
     * and filter your resources by labelling them.
     * </p>
     * <p>
     * Format: <code>"key" : "value"</code>
     * </p>
     * <p>
     * Restrictions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Maximum 50 tags per resource
     * </p>
     * </li>
     * <li>
     * <p>
     * Each resource tag must be unique with a maximum of one value.
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum key length: 128 Unicode characters in UTF-8
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum value length: 256 Unicode characters in UTF-8
     * </p>
     * </li>
     * <li>
     * <p>
     * Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @.
     * </p>
     * </li>
     * <li>
     * <p>
     * Cannot use "aws:" as a prefix for a key.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Applies one or more tags to the geofence collection. A tag is a key-value pair helps manage, identify,
     *         search, and filter your resources by labelling them.</p>
     *         <p>
     *         Format: <code>"key" : "value"</code>
     *         </p>
     *         <p>
     *         Restrictions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Maximum 50 tags per resource
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Each resource tag must be unique with a maximum of one value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Maximum key length: 128 Unicode characters in UTF-8
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Maximum value length: 256 Unicode characters in UTF-8
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Cannot use "aws:" as a prefix for a key.
     *         </p>
     *         </li>
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(collectionName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(pricingPlanAsString());
        hashCode = 31 * hashCode + Objects.hashCode(pricingPlanDataSource());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGeofenceCollectionRequest)) {
            return false;
        }
        CreateGeofenceCollectionRequest other = (CreateGeofenceCollectionRequest) obj;
        return Objects.equals(collectionName(), other.collectionName()) && Objects.equals(description(), other.description())
                && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(pricingPlanAsString(), other.pricingPlanAsString())
                && Objects.equals(pricingPlanDataSource(), other.pricingPlanDataSource()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateGeofenceCollectionRequest").add("CollectionName", collectionName())
                .add("Description", description()).add("KmsKeyId", kmsKeyId()).add("PricingPlan", pricingPlanAsString())
                .add("PricingPlanDataSource", pricingPlanDataSource()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CollectionName":
            return Optional.ofNullable(clazz.cast(collectionName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "PricingPlan":
            return Optional.ofNullable(clazz.cast(pricingPlanAsString()));
        case "PricingPlanDataSource":
            return Optional.ofNullable(clazz.cast(pricingPlanDataSource()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateGeofenceCollectionRequest, T> g) {
        return obj -> g.apply((CreateGeofenceCollectionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LocationRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateGeofenceCollectionRequest> {
        /**
         * <p>
         * A custom name for the geofence collection.
         * </p>
         * <p>
         * Requirements:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and underscores (_).
         * </p>
         * </li>
         * <li>
         * <p>
         * Must be a unique geofence collection name.
         * </p>
         * </li>
         * <li>
         * <p>
         * No spaces allowed. For example, <code>ExampleGeofenceCollection</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param collectionName
         *        A custom name for the geofence collection.</p>
         *        <p>
         *        Requirements:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and underscores (_).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must be a unique geofence collection name.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        No spaces allowed. For example, <code>ExampleGeofenceCollection</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectionName(String collectionName);

        /**
         * <p>
         * An optional description for the geofence collection.
         * </p>
         * 
         * @param description
         *        An optional description for the geofence collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A key identifier for an <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html">AWS
         * KMS customer managed key</a>. Enter a key ID, key ARN, alias name, or alias ARN.
         * </p>
         * 
         * @param kmsKeyId
         *        A key identifier for an <a
         *        href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html">AWS KMS customer managed
         *        key</a>. Enter a key ID, key ARN, alias name, or alias ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * Optionally specifies the pricing plan for the geofence collection. Defaults to <code>RequestBasedUsage</code>
         * .
         * </p>
         * <p>
         * For additional details and restrictions on each pricing plan option, see the <a
         * href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing page</a>.
         * </p>
         * 
         * @param pricingPlan
         *        Optionally specifies the pricing plan for the geofence collection. Defaults to
         *        <code>RequestBasedUsage</code>.</p>
         *        <p>
         *        For additional details and restrictions on each pricing plan option, see the <a
         *        href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing page</a>.
         * @see PricingPlan
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PricingPlan
         */
        Builder pricingPlan(String pricingPlan);

        /**
         * <p>
         * Optionally specifies the pricing plan for the geofence collection. Defaults to <code>RequestBasedUsage</code>
         * .
         * </p>
         * <p>
         * For additional details and restrictions on each pricing plan option, see the <a
         * href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing page</a>.
         * </p>
         * 
         * @param pricingPlan
         *        Optionally specifies the pricing plan for the geofence collection. Defaults to
         *        <code>RequestBasedUsage</code>.</p>
         *        <p>
         *        For additional details and restrictions on each pricing plan option, see the <a
         *        href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing page</a>.
         * @see PricingPlan
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PricingPlan
         */
        Builder pricingPlan(PricingPlan pricingPlan);

        /**
         * <p>
         * Specifies the data provider for the geofence collection.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Required value for the following pricing plans: <code>MobileAssetTracking </code>|
         * <code>MobileAssetManagement</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information about <a href="https://aws.amazon.com/location/data-providers/">Data Providers</a>, and
         * <a href="https://aws.amazon.com/location/pricing/">Pricing plans</a>, see the Amazon Location Service product
         * page.
         * </p>
         * <note>
         * <p>
         * Amazon Location Service only uses <code>PricingPlanDataSource</code> to calculate billing for your geofence
         * collection. Your data won't be shared with the data provider, and will remain in your AWS account or Region
         * unless you move it.
         * </p>
         * </note>
         * <p>
         * Valid Values: <code>Esri </code>| <code>Here</code>
         * </p>
         * 
         * @param pricingPlanDataSource
         *        Specifies the data provider for the geofence collection.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Required value for the following pricing plans: <code>MobileAssetTracking </code>|
         *        <code>MobileAssetManagement</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information about <a href="https://aws.amazon.com/location/data-providers/">Data
         *        Providers</a>, and <a href="https://aws.amazon.com/location/pricing/">Pricing plans</a>, see the
         *        Amazon Location Service product page.
         *        </p>
         *        <note>
         *        <p>
         *        Amazon Location Service only uses <code>PricingPlanDataSource</code> to calculate billing for your
         *        geofence collection. Your data won't be shared with the data provider, and will remain in your AWS
         *        account or Region unless you move it.
         *        </p>
         *        </note>
         *        <p>
         *        Valid Values: <code>Esri </code>| <code>Here</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pricingPlanDataSource(String pricingPlanDataSource);

        /**
         * <p>
         * Applies one or more tags to the geofence collection. A tag is a key-value pair helps manage, identify,
         * search, and filter your resources by labelling them.
         * </p>
         * <p>
         * Format: <code>"key" : "value"</code>
         * </p>
         * <p>
         * Restrictions:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Maximum 50 tags per resource
         * </p>
         * </li>
         * <li>
         * <p>
         * Each resource tag must be unique with a maximum of one value.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum key length: 128 Unicode characters in UTF-8
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum value length: 256 Unicode characters in UTF-8
         * </p>
         * </li>
         * <li>
         * <p>
         * Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @.
         * </p>
         * </li>
         * <li>
         * <p>
         * Cannot use "aws:" as a prefix for a key.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tags
         *        Applies one or more tags to the geofence collection. A tag is a key-value pair helps manage, identify,
         *        search, and filter your resources by labelling them.</p>
         *        <p>
         *        Format: <code>"key" : "value"</code>
         *        </p>
         *        <p>
         *        Restrictions:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Maximum 50 tags per resource
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Each resource tag must be unique with a maximum of one value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum key length: 128 Unicode characters in UTF-8
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum value length: 256 Unicode characters in UTF-8
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cannot use "aws:" as a prefix for a key.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LocationRequest.BuilderImpl implements Builder {
        private String collectionName;

        private String description;

        private String kmsKeyId;

        private String pricingPlan;

        private String pricingPlanDataSource;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGeofenceCollectionRequest model) {
            super(model);
            collectionName(model.collectionName);
            description(model.description);
            kmsKeyId(model.kmsKeyId);
            pricingPlan(model.pricingPlan);
            pricingPlanDataSource(model.pricingPlanDataSource);
            tags(model.tags);
        }

        public final String getCollectionName() {
            return collectionName;
        }

        public final void setCollectionName(String collectionName) {
            this.collectionName = collectionName;
        }

        @Override
        @Transient
        public final Builder collectionName(String collectionName) {
            this.collectionName = collectionName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        @Transient
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getPricingPlan() {
            return pricingPlan;
        }

        public final void setPricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
        }

        @Override
        @Transient
        public final Builder pricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
            return this;
        }

        @Override
        @Transient
        public final Builder pricingPlan(PricingPlan pricingPlan) {
            this.pricingPlan(pricingPlan == null ? null : pricingPlan.toString());
            return this;
        }

        public final String getPricingPlanDataSource() {
            return pricingPlanDataSource;
        }

        public final void setPricingPlanDataSource(String pricingPlanDataSource) {
            this.pricingPlanDataSource = pricingPlanDataSource;
        }

        @Override
        @Transient
        public final Builder pricingPlanDataSource(String pricingPlanDataSource) {
            this.pricingPlanDataSource = pricingPlanDataSource;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateGeofenceCollectionRequest build() {
            return new CreateGeofenceCollectionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
