/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchEvaluateGeofencesRequest extends LocationRequest implements
        ToCopyableBuilder<BatchEvaluateGeofencesRequest.Builder, BatchEvaluateGeofencesRequest> {
    private static final SdkField<String> COLLECTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CollectionName").getter(getter(BatchEvaluateGeofencesRequest::collectionName))
            .setter(setter(Builder::collectionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("CollectionName").build()).build();

    private static final SdkField<List<DevicePositionUpdate>> DEVICE_POSITION_UPDATES_FIELD = SdkField
            .<List<DevicePositionUpdate>> builder(MarshallingType.LIST)
            .memberName("DevicePositionUpdates")
            .getter(getter(BatchEvaluateGeofencesRequest::devicePositionUpdates))
            .setter(setter(Builder::devicePositionUpdates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DevicePositionUpdates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DevicePositionUpdate> builder(MarshallingType.SDK_POJO)
                                            .constructor(DevicePositionUpdate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLECTION_NAME_FIELD,
            DEVICE_POSITION_UPDATES_FIELD));

    private final String collectionName;

    private final List<DevicePositionUpdate> devicePositionUpdates;

    private BatchEvaluateGeofencesRequest(BuilderImpl builder) {
        super(builder);
        this.collectionName = builder.collectionName;
        this.devicePositionUpdates = builder.devicePositionUpdates;
    }

    /**
     * <p>
     * The geofence collection used in evaluating the position of devices against its geofences.
     * </p>
     * 
     * @return The geofence collection used in evaluating the position of devices against its geofences.
     */
    public final String collectionName() {
        return collectionName;
    }

    /**
     * For responses, this returns true if the service returned a value for the DevicePositionUpdates property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDevicePositionUpdates() {
        return devicePositionUpdates != null && !(devicePositionUpdates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains device details for each device to be evaluated against the given geofence collection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDevicePositionUpdates} method.
     * </p>
     * 
     * @return Contains device details for each device to be evaluated against the given geofence collection.
     */
    public final List<DevicePositionUpdate> devicePositionUpdates() {
        return devicePositionUpdates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(collectionName());
        hashCode = 31 * hashCode + Objects.hashCode(hasDevicePositionUpdates() ? devicePositionUpdates() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchEvaluateGeofencesRequest)) {
            return false;
        }
        BatchEvaluateGeofencesRequest other = (BatchEvaluateGeofencesRequest) obj;
        return Objects.equals(collectionName(), other.collectionName())
                && hasDevicePositionUpdates() == other.hasDevicePositionUpdates()
                && Objects.equals(devicePositionUpdates(), other.devicePositionUpdates());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchEvaluateGeofencesRequest").add("CollectionName", collectionName())
                .add("DevicePositionUpdates", hasDevicePositionUpdates() ? devicePositionUpdates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CollectionName":
            return Optional.ofNullable(clazz.cast(collectionName()));
        case "DevicePositionUpdates":
            return Optional.ofNullable(clazz.cast(devicePositionUpdates()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchEvaluateGeofencesRequest, T> g) {
        return obj -> g.apply((BatchEvaluateGeofencesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LocationRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchEvaluateGeofencesRequest> {
        /**
         * <p>
         * The geofence collection used in evaluating the position of devices against its geofences.
         * </p>
         * 
         * @param collectionName
         *        The geofence collection used in evaluating the position of devices against its geofences.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectionName(String collectionName);

        /**
         * <p>
         * Contains device details for each device to be evaluated against the given geofence collection.
         * </p>
         * 
         * @param devicePositionUpdates
         *        Contains device details for each device to be evaluated against the given geofence collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder devicePositionUpdates(Collection<DevicePositionUpdate> devicePositionUpdates);

        /**
         * <p>
         * Contains device details for each device to be evaluated against the given geofence collection.
         * </p>
         * 
         * @param devicePositionUpdates
         *        Contains device details for each device to be evaluated against the given geofence collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder devicePositionUpdates(DevicePositionUpdate... devicePositionUpdates);

        /**
         * <p>
         * Contains device details for each device to be evaluated against the given geofence collection.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DevicePositionUpdate>.Builder} avoiding the
         * need to create one manually via {@link List<DevicePositionUpdate>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DevicePositionUpdate>.Builder#build()} is called immediately
         * and its result is passed to {@link #devicePositionUpdates(List<DevicePositionUpdate>)}.
         * 
         * @param devicePositionUpdates
         *        a consumer that will call methods on {@link List<DevicePositionUpdate>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #devicePositionUpdates(List<DevicePositionUpdate>)
         */
        Builder devicePositionUpdates(Consumer<DevicePositionUpdate.Builder>... devicePositionUpdates);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LocationRequest.BuilderImpl implements Builder {
        private String collectionName;

        private List<DevicePositionUpdate> devicePositionUpdates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchEvaluateGeofencesRequest model) {
            super(model);
            collectionName(model.collectionName);
            devicePositionUpdates(model.devicePositionUpdates);
        }

        public final String getCollectionName() {
            return collectionName;
        }

        public final void setCollectionName(String collectionName) {
            this.collectionName = collectionName;
        }

        @Override
        @Transient
        public final Builder collectionName(String collectionName) {
            this.collectionName = collectionName;
            return this;
        }

        public final List<DevicePositionUpdate.Builder> getDevicePositionUpdates() {
            List<DevicePositionUpdate.Builder> result = BatchEvaluateGeofencesRequestDevicePositionUpdatesListCopier
                    .copyToBuilder(this.devicePositionUpdates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDevicePositionUpdates(Collection<DevicePositionUpdate.BuilderImpl> devicePositionUpdates) {
            this.devicePositionUpdates = BatchEvaluateGeofencesRequestDevicePositionUpdatesListCopier
                    .copyFromBuilder(devicePositionUpdates);
        }

        @Override
        @Transient
        public final Builder devicePositionUpdates(Collection<DevicePositionUpdate> devicePositionUpdates) {
            this.devicePositionUpdates = BatchEvaluateGeofencesRequestDevicePositionUpdatesListCopier.copy(devicePositionUpdates);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder devicePositionUpdates(DevicePositionUpdate... devicePositionUpdates) {
            devicePositionUpdates(Arrays.asList(devicePositionUpdates));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder devicePositionUpdates(Consumer<DevicePositionUpdate.Builder>... devicePositionUpdates) {
            devicePositionUpdates(Stream.of(devicePositionUpdates)
                    .map(c -> DevicePositionUpdate.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchEvaluateGeofencesRequest build() {
            return new BatchEvaluateGeofencesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
