/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.Blueprint;
import software.amazon.awssdk.services.lightsail.model.BlueprintListCopier;
import software.amazon.awssdk.services.lightsail.model.LightsailResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetBlueprintsResponse
extends LightsailResponse
implements ToCopyableBuilder<Builder, GetBlueprintsResponse> {
    private static final SdkField<List<Blueprint>> BLUEPRINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("blueprints").getter(GetBlueprintsResponse.getter(GetBlueprintsResponse::blueprints)).setter(GetBlueprintsResponse.setter(Builder::blueprints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blueprints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Blueprint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextPageToken").getter(GetBlueprintsResponse.getter(GetBlueprintsResponse::nextPageToken)).setter(GetBlueprintsResponse.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextPageToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLUEPRINTS_FIELD, NEXT_PAGE_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetBlueprintsResponse.memberNameToFieldInitializer();
    private final List<Blueprint> blueprints;
    private final String nextPageToken;

    private GetBlueprintsResponse(BuilderImpl builder) {
        super(builder);
        this.blueprints = builder.blueprints;
        this.nextPageToken = builder.nextPageToken;
    }

    public final boolean hasBlueprints() {
        return this.blueprints != null && !(this.blueprints instanceof SdkAutoConstructList);
    }

    public final List<Blueprint> blueprints() {
        return this.blueprints;
    }

    public final String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBlueprints() ? this.blueprints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBlueprintsResponse)) {
            return false;
        }
        GetBlueprintsResponse other = (GetBlueprintsResponse)((Object)obj);
        return this.hasBlueprints() == other.hasBlueprints() && Objects.equals(this.blueprints(), other.blueprints()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetBlueprintsResponse").add("Blueprints", this.hasBlueprints() ? this.blueprints() : null).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "blueprints": {
                return Optional.ofNullable(clazz.cast(this.blueprints()));
            }
            case "nextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("blueprints", BLUEPRINTS_FIELD);
        map.put("nextPageToken", NEXT_PAGE_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetBlueprintsResponse, T> g) {
        return obj -> g.apply((GetBlueprintsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailResponse.BuilderImpl
    implements Builder {
        private List<Blueprint> blueprints = DefaultSdkAutoConstructList.getInstance();
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBlueprintsResponse model) {
            super(model);
            this.blueprints(model.blueprints);
            this.nextPageToken(model.nextPageToken);
        }

        public final List<Blueprint.Builder> getBlueprints() {
            List<Blueprint.Builder> result = BlueprintListCopier.copyToBuilder(this.blueprints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBlueprints(Collection<Blueprint.BuilderImpl> blueprints) {
            this.blueprints = BlueprintListCopier.copyFromBuilder(blueprints);
        }

        @Override
        public final Builder blueprints(Collection<Blueprint> blueprints) {
            this.blueprints = BlueprintListCopier.copy(blueprints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blueprints(Blueprint ... blueprints) {
            this.blueprints(Arrays.asList(blueprints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blueprints(Consumer<Blueprint.Builder> ... blueprints) {
            this.blueprints(Stream.of(blueprints).map(c -> (Blueprint)((Blueprint.Builder)Blueprint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        @Override
        public GetBlueprintsResponse build() {
            return new GetBlueprintsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LightsailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetBlueprintsResponse> {
        public Builder blueprints(Collection<Blueprint> var1);

        public Builder blueprints(Blueprint ... var1);

        public Builder blueprints(Consumer<Blueprint.Builder> ... var1);

        public Builder nextPageToken(String var1);
    }
}

